/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.LensBlurFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class JHLensBlur
extends FilterWithSOParametrizedGUI {
    private RangeParam amount = new RangeParam("Amount (Radius)", 0, 100, 0);
    private RangeParam numberOfSides = new RangeParam("Number of Sides of the Aperture", 3, 12, 5);
    private RangeParam bloomFactor = new RangeParam("Bloom Factor", 1, 8, 1);
    private RangeParam bloomThreshold = new RangeParam("Bloom Threshold", 0, 255, 200);
    private BooleanParam hpSharpening = BooleanParam.createParamForHPSharpening();
    private LensBlurFilter filter;

    public JHLensBlur() {
        super("Lens Blur");
        this.paramSet = new ParamSet(this.amount, this.numberOfSides, this.bloomFactor, this.bloomThreshold, this.hpSharpening, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.amount.getValue();
        if (n == 0 || this.showOriginalParam.getValue()) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new LensBlurFilter();
        }
        this.filter.setRadius(n);
        this.filter.setSides(this.numberOfSides.getValue());
        this.filter.setBloom(this.bloomFactor.getValue());
        this.filter.setBloomThreshold(this.bloomThreshold.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        if (this.hpSharpening.getValue()) {
            bufferedImage2 = ImageUtils.getHighPassSharpenedImage(bufferedImage, bufferedImage2);
        }
        return bufferedImage2;
    }
}

