/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.MotionBlur;
import com.jhlabs.image.MotionBlurFilter;
import com.jhlabs.image.MotionBlurOp;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class JHMotionBlur
extends FilterWithSOParametrizedGUI {
    private AngleParam angle = new AngleParam("Direction", 0.0);
    private RangeParam distance = new RangeParam("Distance", 0, 200, 0);
    private RangeParam rotation = new RangeParam("Spin Blur Amount (Degrees)", -45, 45, 0);
    private RangeParam zoom = new RangeParam("Zoom Blur Amount (%)", 0, 200, 0);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private BooleanParam hpSharpening = BooleanParam.createParamForHPSharpening();
    private Mode mode;
    private static IntChoiceParam.Value[] methodChoices = new IntChoiceParam.Value[]{new IntChoiceParam.Value("Fast", MBMethod.FAST.ordinal()), new IntChoiceParam.Value("High Quality", MBMethod.GOOD.ordinal())};
    private IntChoiceParam method = new IntChoiceParam("Quality", methodChoices, true);

    public JHMotionBlur(Mode mode) {
        super(mode.toString());
        this.mode = mode;
        if (mode == Mode.MOTION_BLUR) {
            this.paramSet = new ParamSet(this.distance, this.angle, this.method, this.hpSharpening, this.showOriginalParam);
        } else if (mode == Mode.SPIN_ZOOM_BLUR) {
            this.paramSet = new ParamSet(this.rotation, this.zoom, this.center, this.method, this.hpSharpening, this.showOriginalParam);
        } else {
            throw new IllegalStateException("should not get here");
        }
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.distance.getValue();
        float f = this.zoom.getValueAsPercentage();
        float f2 = this.rotation.getValueInRadians();
        if (this.mode == Mode.MOTION_BLUR ? n == 0 : this.mode == Mode.SPIN_ZOOM_BLUR && f == 0.0f && f2 == 0.0f) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        int n2 = this.method.getValue();
        MBMethod mBMethod = MBMethod.values()[n2];
        MotionBlur motionBlur = mBMethod.getImplementation();
        motionBlur.setCentreX(this.center.getRelativeX());
        motionBlur.setCentreY(this.center.getRelativeY());
        motionBlur.setAngle((float)this.angle.getValueInIntuitiveRadians());
        motionBlur.setDistance(n);
        motionBlur.setRotation(f2);
        motionBlur.setZoom(f);
        bufferedImage2 = motionBlur.filter(bufferedImage, bufferedImage2);
        if (this.hpSharpening.getValue()) {
            bufferedImage2 = ImageUtils.getHighPassSharpenedImage(bufferedImage, bufferedImage2);
        }
        return bufferedImage2;
    }

    public static enum Mode {
        MOTION_BLUR{

            public String toString() {
                return "Motion Blur";
            }
        }
        ,
        SPIN_ZOOM_BLUR{

            public String toString() {
                return "Spin and Zoom Blur";
            }
        };

    }

    static enum MBMethod {
        FAST{

            @Override
            public MotionBlur getImplementation() {
                MotionBlurOp motionBlurOp = new MotionBlurOp();
                return motionBlurOp;
            }
        }
        ,
        GOOD{

            @Override
            public MotionBlur getImplementation() {
                MotionBlurFilter motionBlurFilter = new MotionBlurFilter();
                motionBlurFilter.setPremultiplyAlpha(false);
                motionBlurFilter.setWrapEdges(false);
                return motionBlurFilter;
            }
        };


        public abstract MotionBlur getImplementation();
    }
}

