/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.PointillizeFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHPointillize
extends FilterWithParametrizedGUI {
    private RangeParam size = new RangeParam("Grid Size", 1, 200, 15);
    private RangeParam dotSize = new RangeParam("Dot Relative Size", 0, 100, 45);
    private RangeParam fuzziness = new RangeParam("Fuzziness (%)", 0, 100, 0);
    private ColorParam edgeColor = new ColorParam("Fill Color", Color.BLACK, true, true);
    private BooleanParam fadeEdges = new BooleanParam("Fade Instead of Fill", false);
    private RangeParam randomness = new RangeParam("Grid Randomness (%)", 0, 100, 0);
    private IntChoiceParam gridType = IntChoiceParam.getGridTypeChoices("Grid Type", this.randomness);
    private PointillizeFilter filter;

    public JHPointillize() {
        super("Pointillize");
        this.paramSet = new ParamSet(this.size, this.dotSize, this.fuzziness, this.gridType, this.randomness, this.edgeColor, this.fadeEdges);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new PointillizeFilter();
        }
        this.filter.setScale(this.size.getValue());
        this.filter.setRandomness(this.randomness.getValueAsPercentage());
        this.filter.setEdgeThickness(this.dotSize.getValueAsPercentage());
        this.filter.setFuzziness(this.fuzziness.getValueAsPercentage());
        this.filter.setGridType(this.gridType.getValue());
        this.filter.setFadeEdges(this.fadeEdges.getValue());
        this.filter.setEdgeColor(this.edgeColor.getColor().getRGB());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

