/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.levels.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.filters.levels.GrayScaleLookup;
import pixelitor.filters.levels.RGBLookup;
import pixelitor.filters.levels.gui.GrayScaleAdjustmentChangeListener;
import pixelitor.filters.levels.gui.OneChannelLevelsPanel;
import pixelitor.filters.lookup.DynamicLookupFilter;
import pixelitor.utils.GUIUtils;

public class LevelsPanel
extends AdjustPanel
implements ItemListener,
GrayScaleAdjustmentChangeListener {
    private DefaultComboBoxModel selectorModel;
    private OneChannelLevelsPanel rgbPanel;
    private OneChannelLevelsPanel rPanel;
    private OneChannelLevelsPanel gPanel;
    private OneChannelLevelsPanel bPanel;
    private OneChannelLevelsPanel rgPanel;
    private OneChannelLevelsPanel gbPanel;
    private OneChannelLevelsPanel rbPanel;
    private JPanel cardPanel;
    private Collection<OneChannelLevelsPanel> levelsPanels = new ArrayList<OneChannelLevelsPanel>();

    public LevelsPanel(DynamicLookupFilter dynamicLookupFilter) {
        super(dynamicLookupFilter);
        this.rgbPanel = new OneChannelLevelsPanel(OneChannelLevelsPanel.Type.RGB, this);
        this.rPanel = new OneChannelLevelsPanel(OneChannelLevelsPanel.Type.R, this);
        this.gPanel = new OneChannelLevelsPanel(OneChannelLevelsPanel.Type.G, this);
        this.bPanel = new OneChannelLevelsPanel(OneChannelLevelsPanel.Type.B, this);
        this.rgPanel = new OneChannelLevelsPanel(OneChannelLevelsPanel.Type.RG, this);
        this.gbPanel = new OneChannelLevelsPanel(OneChannelLevelsPanel.Type.GB, this);
        this.rbPanel = new OneChannelLevelsPanel(OneChannelLevelsPanel.Type.RB, this);
        this.setLayout(new BorderLayout());
        this.selectorModel = new DefaultComboBoxModel();
        JComboBox jComboBox = new JComboBox(this.selectorModel);
        jComboBox.addItemListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(jComboBox);
        JButton jButton = new JButton("Reset all");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelsPanel.this.resetToDefaultSettings();
            }
        });
        jPanel.add(jButton);
        this.add((Component)jPanel, "North");
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        this.addNewCard(this.rgbPanel);
        this.addNewCard(this.rPanel);
        this.addNewCard(this.gPanel);
        this.addNewCard(this.bPanel);
        this.addNewCard(this.rgPanel);
        this.addNewCard(this.gbPanel);
        this.addNewCard(this.rbPanel);
        this.add((Component)this.cardPanel, "Center");
    }

    private void addNewCard(OneChannelLevelsPanel oneChannelLevelsPanel) {
        String string = oneChannelLevelsPanel.getCardName();
        this.cardPanel.add((Component)oneChannelLevelsPanel, string);
        this.selectorModel.addElement(string);
        this.levelsPanels.add(oneChannelLevelsPanel);
    }

    public static void main(String[] stringArray) {
        GUIUtils.testJComponent(new LevelsPanel(null));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, (String)itemEvent.getItem());
    }

    private void resetToDefaultSettings() {
        for (OneChannelLevelsPanel oneChannelLevelsPanel : this.levelsPanels) {
            oneChannelLevelsPanel.resetToDefaultSettings();
        }
        this.grayScaleAdjustmentHasChanged();
    }

    @Override
    public void grayScaleAdjustmentHasChanged() {
        GrayScaleLookup grayScaleLookup = this.rgbPanel.getAdjustment();
        GrayScaleLookup grayScaleLookup2 = this.rPanel.getAdjustment();
        GrayScaleLookup grayScaleLookup3 = this.gPanel.getAdjustment();
        GrayScaleLookup grayScaleLookup4 = this.bPanel.getAdjustment();
        GrayScaleLookup grayScaleLookup5 = this.rgPanel.getAdjustment();
        GrayScaleLookup grayScaleLookup6 = this.gbPanel.getAdjustment();
        GrayScaleLookup grayScaleLookup7 = this.rbPanel.getAdjustment();
        RGBLookup rGBLookup = new RGBLookup(grayScaleLookup, grayScaleLookup2, grayScaleLookup3, grayScaleLookup4, grayScaleLookup5, grayScaleLookup7, grayScaleLookup6);
        DynamicLookupFilter dynamicLookupFilter = (DynamicLookupFilter)this.op;
        dynamicLookupFilter.setRGBLookup(rGBLookup);
        super.executeFilterPreview();
    }
}

