/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.painters;

import com.bric.swing.ColorPicker;
import com.bric.swing.ColorSwatch;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jdesktop.swingx.painter.effects.AbstractAreaEffect;
import pixelitor.PixelitorWindow;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.SliderSpinner;

public class EffectConfigurator
extends JPanel {
    private JCheckBox checkBox;
    private ColorSwatch colorSwatch;
    private Color color;
    static final int BUTTON_SIZE = 20;
    private SliderSpinner widthSlider;
    private RangeParam widthRange;
    ParamAdjustmentListener adjustmentListener;

    EffectConfigurator(String string, boolean bl, Color color, int n) {
        this(string, bl, color, n, "Width:");
    }

    EffectConfigurator(String string, boolean bl, Color color, int n, String string2) {
        this.setBorder(BorderFactory.createTitledBorder("\"" + string + "\" Configuration"));
        this.checkBox = new JCheckBox();
        this.checkBox.setSelected(bl);
        this.colorSwatch = new ColorSwatch(color, 20);
        this.color = color;
        this.colorSwatch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Color color = ColorPicker.showDialog(PixelitorWindow.getInstance(), "Select Color", EffectConfigurator.this.color, true);
                if (color != null) {
                    EffectConfigurator.this.color = color;
                    EffectConfigurator.this.colorSwatch.setForeground(EffectConfigurator.this.color);
                    EffectConfigurator.this.colorSwatch.paintImmediately(0, 0, 20, 20);
                    if (EffectConfigurator.this.adjustmentListener != null) {
                        EffectConfigurator.this.adjustmentListener.paramAdjusted();
                    }
                }
            }
        });
        this.widthRange = new RangeParam(string2, 1, 100, n);
        this.widthSlider = new SliderSpinner(this.widthRange, false, SliderSpinner.TextPosition.NONE);
        this.setLayout(new GridBagLayout());
        GridBagHelper.addLabel((Container)this, "Enabled:", 0, 0);
        GridBagHelper.addControl(this, this.checkBox);
        GridBagHelper.addLabel((Container)this, "Color:", 0, 1);
        GridBagHelper.addControlNoFill(this, this.colorSwatch);
        GridBagHelper.addLabel((Container)this, string2, 0, 2);
        GridBagHelper.addControl(this, this.widthSlider);
    }

    ButtonModel getEnabledModel() {
        return this.checkBox.getModel();
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public Color getColor() {
        return this.color;
    }

    public int getBrushWidth() {
        return this.widthSlider.getCurrentValue();
    }

    public void setAdjustmentListener(final ParamAdjustmentListener paramAdjustmentListener) {
        if (this.adjustmentListener != null) {
            throw new IllegalStateException("only one is allowed");
        }
        this.adjustmentListener = paramAdjustmentListener;
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                paramAdjustmentListener.paramAdjusted();
            }
        });
        this.widthRange.setAdjustmentListener(paramAdjustmentListener);
    }

    public void updateEffectColorAndBrush(AbstractAreaEffect abstractAreaEffect) {
        abstractAreaEffect.setBrushColor(this.getColor());
        int n = this.getBrushWidth();
        abstractAreaEffect.setEffectWidth(n);
        abstractAreaEffect.setBrushSteps(EffectConfigurator.calculateBrushSteps(n));
    }

    public static int calculateBrushSteps(int n) {
        int n2 = 1 + n / 3;
        return n2;
    }
}

