/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.DefaultListSelectionModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import pixelitor.PixelitorWindow;
import pixelitor.history.PixelitorEdit;
import pixelitor.utils.GUIUtils;

public class PixelitorUndoManager
extends UndoManager
implements ListModel {
    private DefaultListSelectionModel selectionModel;
    private EventListenerList listenerList = new EventListenerList();
    private JDialog historyDialog;

    public PixelitorUndoManager() {
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
    }

    public PixelitorEdit getLastEdit() {
        UndoableEdit undoableEdit = super.lastEdit();
        if (undoableEdit != null) {
            return (PixelitorEdit)undoableEdit;
        }
        return null;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        boolean bl = super.addEdit(undoableEdit);
        int n = this.edits.size() - 1;
        this.fireIntervalAdded(this, n, n);
        this.selectionModel.setSelectionInterval(n, n);
        return bl;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        int n = this.selectionModel.getLeadSelectionIndex();
        if (n > 0) {
            this.selectionModel.setSelectionInterval(n - 1, n - 1);
        } else {
            this.selectionModel.clearSelection();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.selectionModel.isSelectionEmpty()) {
            this.selectionModel.setSelectionInterval(0, 0);
        } else {
            int n = this.selectionModel.getLeadSelectionIndex();
            this.selectionModel.setSelectionInterval(n + 1, n + 1);
        }
    }

    @Override
    public int getSize() {
        return this.edits.size();
    }

    public Object getElementAt(int n) {
        return this.edits.get(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(ListDataListener.class, listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(ListDataListener.class, listDataListener);
    }

    protected void fireIntervalAdded(Object object, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(object, 1, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
        }
    }

    public void showHistory() {
        JList jList = new JList(this);
        jList.setSelectionModel(this.selectionModel);
        if (this.historyDialog == null) {
            this.historyDialog = new JDialog(PixelitorWindow.getInstance(), "History", false);
            this.historyDialog.getContentPane().add(new JScrollPane(jList));
            this.historyDialog.setSize(200, 300);
            GUIUtils.centerOnScreen(this.historyDialog);
        }
        if (!this.historyDialog.isVisible()) {
            this.historyDialog.setVisible(true);
        }
    }

    public void dumpHistory() {
        int n = this.edits.size();
        System.out.println("PixelitorUndoManager.dumpHistory:");
        for (int i = 0; i < n; ++i) {
            PixelitorEdit pixelitorEdit = (PixelitorEdit)this.edits.get(i);
            System.out.println("edit [" + i + "] = " + pixelitorEdit.dump());
        }
    }
}

