/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import java.awt.Shape;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.selection.Selection;

public class SelectionChangeEdit
extends PixelitorEdit {
    private Shape backupShape;

    public SelectionChangeEdit(Composition composition, Shape shape, String string) {
        super(composition, string);
        if (shape == null) {
            throw new IllegalArgumentException("backupShape is null");
        }
        this.backupShape = shape;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.swapShapes();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.swapShapes();
    }

    private void swapShapes() {
        Selection selection = this.comp.getSelection();
        if (selection == null) {
            throw new IllegalStateException();
        }
        Shape shape = selection.getShape();
        selection.setShape(this.backupShape);
        this.backupShape = shape;
        History.postEdit(this);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

