/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.menus.ZoomLevel;

public class ZoomChangeEdit
extends PixelitorEdit {
    private ZoomLevel before;
    private ZoomLevel after;

    public ZoomChangeEdit(Composition composition, ZoomLevel zoomLevel, ZoomLevel zoomLevel2) {
        super(composition, "Zoom to " + zoomLevel2.toString());
        this.before = zoomLevel;
        this.after = zoomLevel2;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.comp.getIC().setZoom(this.before, false);
        History.postEdit(this);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.comp.getIC().setZoom(this.after, false);
        History.postEdit(this);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

