/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pixelitor.filters.gui.ParamAdjustmentListener;
import pixelitor.filters.gui.RangeParam;
import pixelitor.io.ImagePanel;
import pixelitor.io.JpegOutput;
import pixelitor.io.OpenSaveManager;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.OKCancelDialog;
import pixelitor.utils.SliderSpinner;
import pixelitor.utils.Utils;

public class OptimizedJpegSavePanel
extends JPanel {
    private BufferedImage image;
    private ImagePanel optimized;
    private RangeParam qualityParam;
    private JLabel sizeLabel;

    public OptimizedJpegSavePanel(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.qualityParam = new RangeParam("JPEG Quality", 1, 100, 60);
        this.sizeLabel = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 10, 10));
        ImagePanel imagePanel = new ImagePanel(bufferedImage);
        this.optimized = new ImagePanel();
        Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        imagePanel.setPreferredSize(dimension);
        this.optimized.setPreferredSize(dimension);
        this.updateAfterPreview();
        JScrollPane jScrollPane = new JScrollPane(imagePanel);
        jPanel.add(jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane(this.optimized);
        jPanel.add(jScrollPane2);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Original"));
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Optimized"));
        jScrollPane2.getVerticalScrollBar().setModel(jScrollPane.getVerticalScrollBar().getModel());
        jScrollPane2.getHorizontalScrollBar().setModel(jScrollPane.getHorizontalScrollBar().getModel());
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)jPanel, "Center");
        this.qualityParam.setAdjustmentListener(new ParamAdjustmentListener(){

            @Override
            public void paramAdjusted() {
                OptimizedJpegSavePanel.this.updateAfterPreview();
            }
        });
        SliderSpinner sliderSpinner = new SliderSpinner(this.qualityParam, false, SliderSpinner.TextPosition.WEST);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(sliderSpinner);
        jPanel2.add(this.sizeLabel);
        this.add((Component)jPanel2, "South");
    }

    private void updateAfterPreview() {
        final float f = this.getSelectedQuality();
        final JpegOutput.ImageWithSize[] imageWithSizeArray = new JpegOutput.ImageWithSize[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                imageWithSizeArray[0] = JpegOutput.writeJPGtoPreviewImage(OptimizedJpegSavePanel.this.image, f);
            }
        };
        Utils.executeWithBusyCursor(this, runnable, false);
        BufferedImage bufferedImage = imageWithSizeArray[0].getImage();
        this.optimized.updateImage(bufferedImage);
        int n = imageWithSizeArray[0].getSize();
        this.sizeLabel.setText("Size: " + Utils.bytesToString(n));
    }

    private float getSelectedQuality() {
        return this.qualityParam.getValueAsPercentage();
    }

    public static void showInDialog(BufferedImage bufferedImage, JFrame jFrame) {
        BufferedImage bufferedImage2 = ImageUtils.convertToRGB(bufferedImage, false);
        final OptimizedJpegSavePanel optimizedJpegSavePanel = new OptimizedJpegSavePanel(bufferedImage2);
        OKCancelDialog oKCancelDialog = new OKCancelDialog(optimizedJpegSavePanel, jFrame, "Optimized JPEG Save", "Save", "Cancel", false){

            @Override
            protected void dialogAccepted() {
                super.dialogAccepted();
                this.dispose();
                float f = optimizedJpegSavePanel.getSelectedQuality();
                OpenSaveManager.saveJpegWithQuality(f);
            }

            @Override
            protected void dialogCancelled() {
                super.dialogCancelled();
                this.dispose();
            }
        };
        oKCancelDialog.setVisible(true);
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File("C:\\Documents and Settings\\Laci\\Asztal\\bosch.jpg"));
        OptimizedJpegSavePanel.showInDialog(bufferedImage, null);
    }
}

