/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import pixelitor.Composition;
import pixelitor.filters.comp.Flip;
import pixelitor.history.History;
import pixelitor.history.TranslateEdit;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.Layer;

public abstract class ContentLayer
extends Layer {
    private static final long serialVersionUID = 2L;
    private transient int temporaryTranslationX = 0;
    private transient int temporaryTranslationY = 0;
    int translationX = 0;
    int translationY = 0;

    protected ContentLayer(Composition composition, String string) {
        super(composition, string);
    }

    public void moveLayerRelative(int n, int n2) {
        this.temporaryTranslationX = n;
        this.temporaryTranslationY = n2;
    }

    public int getTranslationX() {
        return this.translationX + this.temporaryTranslationX;
    }

    public int getTranslationY() {
        return this.translationY + this.temporaryTranslationY;
    }

    public void startTranslation() {
        this.temporaryTranslationX = 0;
        this.temporaryTranslationY = 0;
    }

    public void endTranslation() {
        int n = this.translationX;
        int n2 = this.translationY;
        this.translationX += this.temporaryTranslationX;
        this.translationY += this.temporaryTranslationY;
        this.temporaryTranslationX = 0;
        this.temporaryTranslationY = 0;
        TranslateEdit translateEdit = this.createTranslateEdit(n, n2);
        History.addEdit(translateEdit);
    }

    abstract TranslateEdit createTranslateEdit(int var1, int var2);

    public void setTranslationX(int n) {
        this.translationX = n;
    }

    public void setTranslationY(int n) {
        this.translationY = n;
    }

    public abstract void flip(Flip.Direction var1);

    public abstract void rotate(int var1);

    public abstract void enlargeCanvas(int var1, int var2, int var3, int var4);

    @Override
    public BufferedImage paintLayer(Graphics2D graphics2D, boolean bl, BufferedImage bufferedImage) {
        if (this.layerMask == null) {
            this.paintLayerOnGraphics(graphics2D, bl);
        } else {
            BufferedImage bufferedImage2 = this.getMaskedImage(bl);
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        }
        return null;
    }

    BufferedImage getMaskedImage(boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(this.comp.getCanvasWidth(), this.comp.getCanvasHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintLayerOnGraphics(graphics2D, bl);
        graphics2D.setComposite(AlphaComposite.DstIn);
        graphics2D.drawImage((Image)this.layerMask.getTransparentImage(), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected void setupDrawingComposite(Graphics2D graphics2D, boolean bl) {
        if (bl) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        } else {
            Composite composite = this.blendingMode.getComposite(this.opacity);
            graphics2D.setComposite(composite);
        }
    }

    public abstract void paintLayerOnGraphics(Graphics2D var1, boolean var2);

    @Override
    public void mergeDownOn(ImageLayer imageLayer) {
        int n = this.getTranslationX();
        int n2 = this.getTranslationY();
        BufferedImage bufferedImage = imageLayer.getBufferedImage();
        int n3 = imageLayer.getTranslationX();
        int n4 = imageLayer.getTranslationY();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n5 = n - n3;
        int n6 = n2 - n4;
        this.paintLayerOnGraphics(graphics2D, false);
        graphics2D.dispose();
    }
}

