/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ConsistencyChecks;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerChangeListener;
import pixelitor.utils.IconUtils;
import pixelitor.utils.ImageSwitchListener;

public class DeleteActiveLayerAction
extends AbstractAction
implements ImageSwitchListener,
LayerChangeListener {
    public static final DeleteActiveLayerAction INSTANCE = new DeleteActiveLayerAction();

    private DeleteActiveLayerAction() {
        super("Delete Layer", IconUtils.loadIcon("delete_layer.gif"));
        this.setEnabled(false);
        AppLogic.addImageChangeListener(this);
        AppLogic.addLayerChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Composition composition = AppLogic.getActiveComp();
        composition.removeActiveLayer();
    }

    @Override
    public void noOpenImageAnymore() {
        this.setEnabled(false);
    }

    @Override
    public void newImageOpened() {
        int n = AppLogic.getActiveComp().getNrLayers();
        if (n <= 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void activeCompositionHasChanged(Composition composition) {
        if (composition.getNrLayers() <= 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void activeCompLayerCountChanged(Composition composition, int n) {
        if (n <= 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void activeLayerChanged(Layer layer) {
    }

    @Override
    public void layerOrderChanged(Composition composition) {
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        assert (ConsistencyChecks.layerDeleteActionEnabledCheck());
    }
}

