/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.image.BufferedImage;
import pixelitor.Composition;
import pixelitor.layers.ImageLayer;
import pixelitor.tools.AbstractBrushTool;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.utils.BlendingModePanel;

public class BrushTool
extends AbstractBrushTool {
    private BlendingModePanel blendingModePanel;

    public BrushTool() {
        super('b', "Brush", "brush_tool_icon.gif", "click and drag to draw with the current brush, Shift-click to draw lines, right-click to draw with the background color");
    }

    @Override
    public void initSettingsPanel() {
        super.initSettingsPanel();
        this.toolSettingsPanel.addSeparator();
        this.blendingModePanel = new BlendingModePanel(true);
        this.toolSettingsPanel.add(this.blendingModePanel);
    }

    @Override
    protected void initDrawingGraphics(ImageLayer imageLayer) {
        this.g = imageLayer.createTmpDrawingLayer(this.blendingModePanel.getComposite(), this.respectSelection).getGraphics();
    }

    @Override
    public void setupGraphics(Graphics2D graphics2D, Paint paint) {
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setColor(FgBgColorSelector.getFG());
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    @Override
    void mergeTmpLayer(Composition composition) {
        if (this.g != null) {
            ImageLayer imageLayer = composition.getActiveImageLayer();
            imageLayer.mergeTmpDrawingImageDown();
        }
    }

    @Override
    public void drawBrushStrokeProgrammatically(Composition composition, Point point, Point point2) {
        super.drawBrushStrokeProgrammatically(composition, point, point2);
        composition.getActiveImageLayer().mergeTmpDrawingImageDown();
    }

    @Override
    BufferedImage getFullUntouchedImage(Composition composition) {
        BufferedImage bufferedImage = composition.getActiveImageLayer().getBufferedImage();
        if (bufferedImage == null) {
            throw new IllegalStateException();
        }
        return bufferedImage;
    }
}

