/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ImageComponent;
import pixelitor.layers.ImageLayer;
import pixelitor.tools.AbstractBrushTool;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.Utils;

public class EraseTool
extends AbstractBrushTool {
    private BufferedImage copyBeforeStart;

    public EraseTool() {
        super('e', "Erase", "erase_tool_icon.gif", "click and drag to erase pixels");
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        super.toolMouseReleased(mouseEvent, imageComponent);
        this.copyBeforeStart.flush();
        this.copyBeforeStart = null;
    }

    @Override
    void initDrawingGraphics(ImageLayer imageLayer) {
        BufferedImage bufferedImage = imageLayer.createCompositionSizedSubImage();
        this.g = bufferedImage.createGraphics();
        if (this.respectSelection) {
            imageLayer.getComposition().setSelectionClipping(this.g, null);
        }
    }

    @Override
    public void setupGraphics(Graphics2D graphics2D, Paint paint) {
        graphics2D.setComposite(AlphaComposite.getInstance(8, 1.0f));
        BufferedImage bufferedImage = AppLogic.getActiveComp().getActiveImageLayer().getBufferedImage();
        Utils.checkRasterMinimum(bufferedImage);
        this.copyBeforeStart = ImageUtils.copyImage(bufferedImage);
    }

    @Override
    BufferedImage getFullUntouchedImage(Composition composition) {
        if (this.copyBeforeStart == null) {
            throw new IllegalStateException("EraseTool: copyBeforeStart == null");
        }
        return this.copyBeforeStart;
    }

    @Override
    void mergeTmpLayer(Composition composition) {
    }
}

