/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JViewport;
import pixelitor.ImageComponent;
import pixelitor.tools.Tool;

public class HandTool
extends Tool {
    private int startX;
    private int startY;
    private int maxScrollPositionX;
    private int maxScrollPositionY;

    HandTool() {
        super('h', "Hand", "hand_tool_icon.gif", "drag to move the view (if scrollbars are present)", Cursor.getPredefinedCursor(12), false, false, false);
    }

    @Override
    void initSettingsPanel() {
    }

    @Override
    public void toolMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        this.startX = mouseEvent.getX();
        this.startY = mouseEvent.getY();
        JViewport jViewport = (JViewport)imageComponent.getParent();
        Dimension dimension = jViewport.getViewSize();
        Dimension dimension2 = jViewport.getExtentSize();
        this.maxScrollPositionX = dimension.width - dimension2.width;
        this.maxScrollPositionY = dimension.height - dimension2.height;
    }

    @Override
    public void toolMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        int n = mouseEvent.getX() - this.startX;
        int n2 = mouseEvent.getY() - this.startY;
        JViewport jViewport = (JViewport)imageComponent.getParent();
        Point point = jViewport.getViewPosition();
        point.x -= n;
        point.y -= n2;
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        if (point.x > this.maxScrollPositionX) {
            point.x = this.maxScrollPositionX;
        }
        if (point.y > this.maxScrollPositionY) {
            point.y = this.maxScrollPositionY;
        }
        jViewport.setViewPosition(point);
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
    }
}

