/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import pixelitor.Composition;
import pixelitor.ImageComponent;
import pixelitor.history.DeselectEdit;
import pixelitor.history.History;
import pixelitor.history.NewSelectionEdit;
import pixelitor.history.PixelitorEdit;
import pixelitor.history.SelectionChangeEdit;
import pixelitor.menus.SelectionActions;
import pixelitor.selection.Selection;
import pixelitor.selection.SelectionInteraction;
import pixelitor.selection.SelectionType;
import pixelitor.tools.Tool;

public class SelectionTool
extends Tool {
    private JComboBox typeCombo;
    private JComboBox interactionCombo;
    private boolean altMeansSubtract = false;
    private SelectionInteraction originalSelectionInteraction;
    private Shape backupShape = null;

    SelectionTool() {
        super('m', "Selection", "selection_tool_icon.gif", "click and drag to select an area", Cursor.getPredefinedCursor(0), false, true, false);
        this.spaceDragBehavior = true;
    }

    @Override
    void initSettingsPanel() {
        this.toolSettingsPanel.add(new JLabel("Type:"));
        this.typeCombo = new JComboBox<SelectionType>(SelectionType.values());
        this.toolSettingsPanel.add(this.typeCombo);
        this.toolSettingsPanel.addSeparator();
        this.toolSettingsPanel.add(new JLabel("New Selection:"));
        this.interactionCombo = new JComboBox<SelectionInteraction>(SelectionInteraction.values());
        this.toolSettingsPanel.add(this.interactionCombo);
        this.toolSettingsPanel.addSeparator();
        JButton jButton = new JButton(SelectionActions.getTraceWithBrush());
        this.toolSettingsPanel.add(jButton);
        JButton jButton2 = new JButton(SelectionActions.getTraceWithEraser());
        this.toolSettingsPanel.add(jButton2);
        JButton jButton3 = new JButton(SelectionActions.getCropAction());
        this.toolSettingsPanel.add(jButton3);
    }

    @Override
    public void toolMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        boolean bl;
        boolean bl2 = mouseEvent.isShiftDown();
        this.altMeansSubtract = bl = mouseEvent.isAltDown();
        if (bl2 || bl) {
            this.originalSelectionInteraction = (SelectionInteraction)((Object)this.interactionCombo.getSelectedItem());
            if (bl2) {
                if (bl) {
                    this.interactionCombo.setSelectedItem((Object)SelectionInteraction.INTERSECT);
                } else {
                    this.interactionCombo.setSelectedItem((Object)SelectionInteraction.ADD);
                }
            } else if (bl) {
                this.interactionCombo.setSelectedItem((Object)SelectionInteraction.SUBTRACT);
            }
        }
        SelectionType selectionType = (SelectionType)((Object)this.typeCombo.getSelectedItem());
        SelectionInteraction selectionInteraction = (SelectionInteraction)((Object)this.interactionCombo.getSelectedItem());
        Composition composition = imageComponent.getComp();
        Selection selection = composition.getSelection();
        if (selection == null) {
            this.backupShape = null;
            composition.startSelection(selectionType, selectionInteraction);
        } else {
            this.backupShape = selection.getShape();
            selection.startNewShape(selectionType, selectionInteraction);
        }
    }

    @Override
    public void toolMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        boolean bl;
        Composition composition = imageComponent.getComp();
        Selection selection = composition.getSelection();
        boolean bl2 = mouseEvent.isAltDown();
        boolean bl3 = bl = !this.altMeansSubtract && bl2;
        if (!bl2) {
            this.altMeansSubtract = false;
        }
        this.userDrag.setStartFromCenter(bl);
        selection.updateSelection(this.userDrag);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent, ImageComponent imageComponent) {
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        if (this.userDrag.isClick()) {
            return;
        }
        Composition composition = imageComponent.getComp();
        Selection selection = composition.getSelection();
        if (this.originalSelectionInteraction != null) {
            this.interactionCombo.setSelectedItem((Object)this.originalSelectionInteraction);
            this.originalSelectionInteraction = null;
        }
        boolean bl = !this.altMeansSubtract && mouseEvent.isAltDown();
        this.userDrag.setStartFromCenter(bl);
        selection.updateSelection(this.userDrag);
        boolean bl2 = selection.combineShapes();
        PixelitorEdit pixelitorEdit = null;
        if (bl2) {
            SelectionInteraction selectionInteraction = selection.getSelectionInteraction();
            boolean bl3 = selection.clipToCompSize(composition);
            if (bl3) {
                pixelitorEdit = this.newSelectionStarted() ? new NewSelectionEdit(composition, selection.getShape()) : new SelectionChangeEdit(composition, this.backupShape, selectionInteraction.getNameForUndo());
            } else {
                SelectionTool.deselect(imageComponent, false);
                if (!this.newSelectionStarted()) {
                    pixelitorEdit = new DeselectEdit(imageComponent.getComp(), this.backupShape, "SelectionTool.toolMouseReleased 1");
                    assert (!composition.hasSelection());
                }
            }
        } else {
            SelectionTool.deselect(imageComponent, false);
            if (!this.newSelectionStarted()) {
                pixelitorEdit = new DeselectEdit(imageComponent.getComp(), this.backupShape, "SelectionTool.toolMouseReleased 2");
                assert (!composition.hasSelection());
            }
        }
        if (pixelitorEdit != null) {
            History.addEdit(pixelitorEdit);
        }
        this.altMeansSubtract = false;
    }

    @Override
    public boolean mouseClicked(MouseEvent mouseEvent, ImageComponent imageComponent) {
        super.mouseClicked(mouseEvent, imageComponent);
        SelectionTool.deselect(imageComponent, true);
        this.altMeansSubtract = false;
        return false;
    }

    private void addPolygonalLassoPoint(ImageComponent imageComponent) {
        Composition composition = imageComponent.getComp();
        Selection selection = composition.getSelection();
        if (selection != null) {
            selection.addNewPolygonalLassoPoint(this.userDrag);
        }
    }

    private static void deselect(ImageComponent imageComponent, boolean bl) {
        Composition composition = imageComponent.getComp();
        if (composition.hasSelection()) {
            composition.deselect(bl);
        }
    }

    private boolean newSelectionStarted() {
        return this.backupShape == null;
    }
}

