/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools.brushes;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import pixelitor.tools.StrokeType;
import pixelitor.tools.brushes.StrokeBrush;

public class CalligraphyBrush
extends StrokeBrush {
    private static Stroke pointStroke = new BasicStroke(1.2f);

    public CalligraphyBrush() {
        super(StrokeType.CALLIGRAPHY);
    }

    @Override
    public void drawPoint(Graphics2D graphics2D, int n, int n2, float f) {
        float f2 = f / 1.4142f;
        float f3 = (f - f2) / 2.0f;
        float f4 = f3 + f2;
        int n3 = (int)((float)n + f3);
        int n4 = (int)((float)n2 + f4);
        int n5 = (int)((float)n + f4);
        int n6 = (int)((float)n2 + f3);
        graphics2D.setStroke(pointStroke);
        graphics2D.drawLine(n3 + 1, n4 - 1, n5 - 1, n6 + 1);
        if (this.lastStroke != null) {
            graphics2D.setStroke(this.lastStroke);
        }
    }

    @Override
    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f) {
        super.drawLine(graphics2D, n, n2, n3, n4, f);
        this.drawPoint(graphics2D, (int)((float)n - f / 2.0f), (int)((float)n2 - f / 2.0f), f);
    }
}

