/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.Resettable;
import pixelitor.utils.IconUtils;

public class DefaultButton
extends JButton {
    private static Icon defaultIcon = IconUtils.getWestArrowIcon();
    private Resettable resettable;

    public DefaultButton(final Resettable resettable) {
        this.resettable = resettable;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                resettable.reset(true);
            }
        });
        this.setToolTipText("Reset the Default Setting");
    }

    public void updateState() {
        this.setDefault(this.resettable.isSetToDefault());
    }

    private void setDefault(boolean bl) {
        if (bl) {
            this.setIcon(null);
        } else {
            this.setIcon(defaultIcon);
        }
    }

    public void setResettable(GUIParam gUIParam) {
        this.resettable = gUIParam;
    }
}

