/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pixelitor.utils.GUIUtils;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.OKCancelDialog;

public class FilterCreator
extends JPanel {
    private JTextField nameTextField;
    private JCheckBox guiCB;
    private JCheckBox parametrizedGuiCB;
    private JCheckBox copySrcCB;
    private ParamPanel[] paramPanels = new ParamPanel[10];
    private JCheckBox pixelLoopCB;
    private JCheckBox proxyCB;
    private JTextField proxyNameTF;
    private JCheckBox edgeActionCB;
    private JCheckBox interpolationCB;
    private JCheckBox centerSelectorCB;
    private JCheckBox colorCB;
    private JCheckBox gradientCB;
    private JCheckBox angleParamCB;

    private FilterCreator() {
        this.setLayout(new GridBagLayout());
        GridBagHelper.addLabel((Container)this, "Name:", 0, 0);
        this.nameTextField = new JTextField(20);
        GridBagHelper.addLastControl(this, this.nameTextField);
        GridBagHelper.addLabel((Container)this, "GUI:", 0, 1);
        this.guiCB = new JCheckBox();
        this.guiCB.setSelected(true);
        GridBagHelper.addControl(this, this.guiCB);
        GridBagHelper.addLabel((Container)this, "Parametrized GUI:", 2, 1);
        this.parametrizedGuiCB = new JCheckBox();
        this.parametrizedGuiCB.setSelected(true);
        this.parametrizedGuiCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (FilterCreator.this.parametrizedGuiCB.isSelected()) {
                    FilterCreator.this.guiCB.setSelected(true);
                }
            }
        });
        GridBagHelper.addControl(this, this.parametrizedGuiCB);
        GridBagHelper.addLabel((Container)this, "Copy Src -> Dest:", 4, 1);
        this.copySrcCB = new JCheckBox();
        GridBagHelper.addControl(this, this.copySrcCB);
        GridBagHelper.addLabel((Container)this, "Angle Param:", 6, 1);
        this.angleParamCB = new JCheckBox();
        GridBagHelper.addControl(this, this.angleParamCB);
        GridBagHelper.addLabel((Container)this, "Pixel Loop:", 0, 2);
        this.pixelLoopCB = new JCheckBox();
        GridBagHelper.addControl(this, this.pixelLoopCB);
        GridBagHelper.addLabel((Container)this, "Proxy Filter:", 2, 2);
        this.proxyCB = new JCheckBox();
        this.proxyCB.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FilterCreator.this.proxyNameTF.setEnabled(FilterCreator.this.proxyCB.isSelected());
            }
        });
        GridBagHelper.addControl(this, this.proxyCB);
        GridBagHelper.addLabel((Container)this, "Proxy Name:", 4, 2);
        this.proxyNameTF = new JTextField(10);
        this.proxyNameTF.setEnabled(this.proxyCB.isSelected());
        GridBagHelper.addControl(this, this.proxyNameTF);
        GridBagHelper.addLabel((Container)this, "Center Selector:", 0, 3);
        this.centerSelectorCB = new JCheckBox();
        GridBagHelper.addControl(this, this.centerSelectorCB);
        GridBagHelper.addLabel((Container)this, "Edge Action:", 2, 3);
        this.edgeActionCB = new JCheckBox();
        GridBagHelper.addControl(this, this.edgeActionCB);
        GridBagHelper.addLabel((Container)this, "Interpolation:", 4, 3);
        this.interpolationCB = new JCheckBox();
        GridBagHelper.addControl(this, this.interpolationCB);
        GridBagHelper.addLabel((Container)this, "Color:", 6, 3);
        this.colorCB = new JCheckBox();
        GridBagHelper.addControl(this, this.colorCB);
        GridBagHelper.addLabel((Container)this, "Gradient:", 8, 3);
        this.gradientCB = new JCheckBox();
        GridBagHelper.addControl(this, this.gradientCB);
        for (int i = 0; i < this.paramPanels.length; ++i) {
            ParamPanel paramPanel;
            GridBagHelper.addLabel((Container)this, "Param " + (i + 1) + ':', 0, i + 4);
            this.paramPanels[i] = paramPanel = new ParamPanel();
            GridBagHelper.addLastControl(this, paramPanel);
        }
    }

    private ParameterInfo[] getParameterInfoArray() {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        for (ParamPanel paramPanel : this.paramPanels) {
            ParameterInfo parameterInfo = paramPanel.getParameterInfo();
            if (parameterInfo == null) continue;
            arrayList.add(parameterInfo);
        }
        return arrayList.toArray(new ParameterInfo[arrayList.size()]);
    }

    public static void showInDialog(Frame frame) {
        final FilterCreator filterCreator = new FilterCreator();
        OKCancelDialog oKCancelDialog = new OKCancelDialog((JComponent)filterCreator, frame, "Filter Creator", "Show Source", "Close"){

            @Override
            protected void dialogAccepted() {
                super.dialogAccepted();
                String string = filterCreator.createFilterSource();
                JTextArea jTextArea = new JTextArea(string);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width + 50, 500));
                GUIUtils.showTextDialog(jScrollPane, "Source", string);
            }

            @Override
            protected void dialogCancelled() {
                super.dialogCancelled();
                this.dispose();
            }
        };
        oKCancelDialog.setVisible(true);
    }

    private String createFilterSource() {
        boolean bl = this.parametrizedGuiCB.isSelected();
        boolean bl2 = this.guiCB.isSelected();
        boolean bl3 = this.copySrcCB.isSelected();
        String string = this.nameTextField.getText();
        boolean bl4 = this.pixelLoopCB.isSelected();
        boolean bl5 = this.proxyCB.isSelected();
        String string2 = this.proxyNameTF.getText();
        boolean bl6 = this.angleParamCB.isSelected();
        boolean bl7 = this.centerSelectorCB.isSelected();
        boolean bl8 = this.edgeActionCB.isSelected();
        boolean bl9 = this.colorCB.isSelected();
        boolean bl10 = this.gradientCB.isSelected();
        boolean bl11 = this.interpolationCB.isSelected();
        ParameterInfo[] parameterInfoArray = this.getParameterInfoArray();
        StringBuilder stringBuilder = new StringBuilder();
        FilterCreator.addImports(stringBuilder, string, bl4, bl, bl5, string2);
        String string3 = string.replaceAll(" ", "");
        FilterCreator.addSuperClass(bl2, bl, stringBuilder, string3, bl5);
        if (bl2 && bl) {
            FilterCreator.addParamsDeclaration(stringBuilder, bl7, bl6, bl8, bl9, bl10, bl11, parameterInfoArray);
        }
        if (bl5) {
            stringBuilder.append("\n    private ").append(string2).append(" filter;\n");
        }
        FilterCreator.addConstructor(string, bl2, bl, stringBuilder, string3, bl3, bl5, parameterInfoArray);
        FilterCreator.addTransform(stringBuilder, bl4, bl5, string2, bl7, bl6, bl8, bl11, parameterInfoArray);
        FilterCreator.addGetAdjustPanel(bl2, bl, stringBuilder, string3);
        return stringBuilder.toString();
    }

    private static void addGetAdjustPanel(boolean bl, boolean bl2, StringBuilder stringBuilder, String string) {
        if (bl && !bl2) {
            stringBuilder.append("\n    @Override\n");
            stringBuilder.append("    public AdjustPanel getAdjustPanel() {\n");
            stringBuilder.append("        return new " + string + "Adjustments(this);\n");
            stringBuilder.append("    }\n");
        }
        stringBuilder.append('}');
    }

    private static void addTransform(StringBuilder stringBuilder, boolean bl, boolean bl2, String string, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ParameterInfo[] parameterInfoArray) {
        stringBuilder.append("\n    @Override\n");
        stringBuilder.append("    public BufferedImage transform(BufferedImage src, BufferedImage dest) {\n");
        for (ParameterInfo parameterInfo : parameterInfoArray) {
            String string2 = parameterInfo.getParamVariableName();
            String string3 = parameterInfo.getVariableName();
            stringBuilder.append("       int " + string3 + " =  " + string2 + ".getValue();\n");
        }
        if (bl) {
            stringBuilder.append("        int[] srcData = ImageUtils.getPixelsAsArray(src);\n");
            stringBuilder.append("        int[] destData = ImageUtils.getPixelsAsArray(dest);\n");
        }
        if (bl2) {
            stringBuilder.append("       if(filter == null) {\n");
            stringBuilder.append("           filter = new " + string + "();\n");
            stringBuilder.append("       }\n");
            stringBuilder.append('\n');
            if (bl3) {
                stringBuilder.append("        filter.setCentreX(center.getRelativeX());\n");
                stringBuilder.append("        filter.setCentreY(center.getRelativeY());\n");
            }
            if (bl5) {
                stringBuilder.append("        filter.setEdgeAction(edgeAction.getCurrentInt());\n");
            }
            if (bl6) {
                stringBuilder.append("        filter.setInterpolation(interpolation.getCurrentInt());\n");
            }
            stringBuilder.append('\n');
            if (bl4) {
                stringBuilder.append("        filter.setAngle(angleParam.getValueInRadians());\n");
            }
            stringBuilder.append("        dest = filter.filter(src, dest);\n");
        }
        stringBuilder.append("        return dest;\n");
        stringBuilder.append("    }\n");
    }

    private static void addSuperClass(boolean bl, boolean bl2, StringBuilder stringBuilder, String string, boolean bl3) {
        String string2 = bl ? (bl2 ? "FilterWithParametrizedGUI" : "FilterWithGUI") : "Filter";
        String string3 = string2;
        if (bl3) {
            string = "JH" + string;
        }
        stringBuilder.append("public class ").append(string);
        stringBuilder.append(" extends ").append(string3);
        stringBuilder.append(" {\n");
    }

    private static void addImports(StringBuilder stringBuilder, String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        if (bl) {
            stringBuilder.append("import pixelitor.utils.ImageUtils;\n");
        }
        stringBuilder.append("import pixelitor.filters.gui.ParamSet;\n");
        stringBuilder.append("import pixelitor.filters.gui.RangeParam;\n");
        if (bl2) {
            stringBuilder.append("import pixelitor.filters.FilterWithParametrizedGUI;\n");
        }
        stringBuilder.append("\nimport java.awt.image.BufferedImage;\n");
        stringBuilder.append("\n/**\n");
        if (bl3) {
            stringBuilder.append(" * " + string + " based on the JHLabs " + string2 + '\n');
        } else {
            stringBuilder.append(" * " + string + '\n');
        }
        stringBuilder.append(" */\n");
    }

    private static void addConstructor(String string, boolean bl, boolean bl2, StringBuilder stringBuilder, String string2, boolean bl3, boolean bl4, ParameterInfo ... parameterInfoArray) {
        if (bl4) {
            string2 = "JH" + string2;
        }
        stringBuilder.append("\n    public " + string2 + "() {\n");
        stringBuilder.append("        super(\"" + string + "\");\n");
        if (bl3) {
            stringBuilder.append("        copySrcToDstBeforeRunning = true;\n");
        }
        if (bl && bl2) {
            FilterCreator.addParamSetToConstructor(stringBuilder, parameterInfoArray);
        }
        stringBuilder.append("    }\n");
    }

    private static void addParamSetToConstructor(StringBuilder stringBuilder, ParameterInfo ... parameterInfoArray) {
        if (parameterInfoArray.length == 1) {
            stringBuilder.append("        paramSet = new ParamSet(" + parameterInfoArray[0].getParamVariableName() + ");\n");
        } else {
            stringBuilder.append("        paramSet = new ParamSet(\n");
            for (int i = 0; i < parameterInfoArray.length; ++i) {
                ParameterInfo parameterInfo = parameterInfoArray[i];
                String string = parameterInfo.getParamVariableName();
                stringBuilder.append("            " + string);
                if (i < parameterInfoArray.length - 1) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('\n');
            }
            stringBuilder.append("        );\n");
        }
    }

    private static void addParamsDeclaration(StringBuilder stringBuilder, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ParameterInfo ... parameterInfoArray) {
        for (ParameterInfo parameterInfo : parameterInfoArray) {
            String string = parameterInfo.getParamVariableName();
            stringBuilder.append("    private RangeParam " + string + " = new RangeParam(\"" + parameterInfo.getName() + "\", " + parameterInfo.getMin() + ", " + parameterInfo.getMax() + ", " + parameterInfo.getDefaultValue() + ");");
            stringBuilder.append('\n');
        }
        if (bl) {
            stringBuilder.append("    private ImagePositionParam centerParam = new ImagePositionParam(\"Center\");\n");
        }
        if (bl2) {
            stringBuilder.append("    private AngleParam angleParam = new AngleParam(\"Angle\", 0);\n");
        }
        if (bl3) {
            stringBuilder.append("    private IntChoiceParam edgeActionParam =  IntChoiceParam.getEdgeActionChoices();\n");
        }
        if (bl6) {
            stringBuilder.append("    private IntChoiceParam interpolationParam = IntChoiceParam.getInterpolationChoices();\n");
        }
        if (bl4) {
            stringBuilder.append("    private ColorParam colorParam = new ColorParam(\"Color:\", Color.WHITE, false, false);\n");
        }
        if (bl5) {
            stringBuilder.append("    private float[] defaultThumbPositions = new float[]{0f, 1f};\n");
            stringBuilder.append("    private Color[] defaultValues = new Color[]{Color.BLACK, Color.WHITE};\n");
            stringBuilder.append("    private GradientParam gradientParam = new GradientParam(\"Colors:\", defaultThumbPositions, defaultValues);\n");
        }
    }

    public static void main(String[] stringArray) {
        FilterCreator.showInDialog(null);
    }

    public static class ParameterInfo {
        String name;
        String paramVariableName;
        String variableName;
        int min;
        int max;
        int defaultValue;

        public ParameterInfo(String string, int n, int n2, int n3) {
            this.name = string;
            this.min = n;
            this.max = n2;
            this.defaultValue = n3;
            String string2 = string.replaceAll(" ", "");
            this.variableName = string2.substring(0, 1).toLowerCase() + string2.substring(1);
            this.paramVariableName = this.variableName + "Param";
        }

        private String getName() {
            return this.name;
        }

        private String getParamVariableName() {
            return this.paramVariableName;
        }

        private String getVariableName() {
            return this.variableName;
        }

        private int getMin() {
            return this.min;
        }

        private int getMax() {
            return this.max;
        }

        private int getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static class ParamPanel
    extends JPanel {
        private JTextField nameTextField;
        private JTextField minTextField;
        private JTextField maxTextField;
        private JTextField defaultTextField;

        private ParamPanel() {
            this.setLayout(new FlowLayout(0));
            this.add(new JLabel("Name:"));
            this.nameTextField = new JTextField(20);
            this.add(this.nameTextField);
            this.add(new JLabel("Min:"));
            this.minTextField = new JTextField("0", 5);
            this.add(this.minTextField);
            this.add(new JLabel("Max:"));
            this.maxTextField = new JTextField("100", 5);
            this.add(this.maxTextField);
            this.add(new JLabel("Default:"));
            this.defaultTextField = new JTextField("0", 5);
            this.add(this.defaultTextField);
        }

        private ParameterInfo getParameterInfo() {
            String string = this.nameTextField.getText().trim();
            if (string.length() > 0) {
                int n = Integer.parseInt(this.minTextField.getText());
                int n2 = Integer.parseInt(this.maxTextField.getText());
                int n3 = Integer.parseInt(this.defaultTextField.getText());
                return new ParameterInfo(string, n, n2, n3);
            }
            return null;
        }
    }
}

