/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import pixelitor.ChangeReason;
import pixelitor.filters.Filter;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.gui.FilterWithGUI;
import pixelitor.utils.GUIUtils;
import pixelitor.utils.IntTextField;

public class PerformanceTestingDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private JComboBox opSelector;
    private JProgressBar progressBar;
    private JButton startButton;
    private JButton stopButton;
    private JButton closeButton;
    private TestingTask task;
    private JTextField timesField;

    public PerformanceTestingDialog(Frame frame) {
        super(frame, "Performance testing");
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.opSelector = new JComboBox<Filter>(FilterUtils.getAllFiltersSorted());
        this.opSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Filter filter = (Filter)PerformanceTestingDialog.this.opSelector.getSelectedItem();
                if (filter instanceof FilterWithGUI) {
                    FilterWithGUI filterWithGUI = (FilterWithGUI)filter;
                    filterWithGUI.actionPerformed(null);
                }
            }
        });
        jPanel.add(new JLabel("Select op: "));
        jPanel.add(this.opSelector);
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(new JLabel("How many times: "));
        this.timesField = new IntTextField("100");
        this.timesField.setColumns(7);
        jPanel4.add(this.timesField);
        jPanel2.add((Component)jPanel4, "North");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        jPanel2.add((Component)this.progressBar, "South");
        this.startButton = new JButton("start");
        this.startButton.addActionListener(this);
        jPanel3.add(this.startButton);
        this.stopButton = new JButton("stop");
        this.stopButton.addActionListener(this);
        this.stopButton.setEnabled(false);
        jPanel3.add(this.stopButton);
        this.closeButton = new JButton("close");
        this.closeButton.addActionListener(this);
        jPanel3.add(this.closeButton);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        this.pack();
        GUIUtils.centerOnScreen(this);
        this.setVisible(true);
    }

    private void setEnabledWhileRunning() {
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.closeButton.setEnabled(false);
        this.opSelector.setEnabled(false);
        this.timesField.setEnabled(false);
    }

    private void setEnabledAfterRunning() {
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.closeButton.setEnabled(true);
        this.opSelector.setEnabled(true);
        this.timesField.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.startButton) {
            int n = 0;
            try {
                n = Integer.parseInt(this.timesField.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, '\"' + this.timesField.getText() + "\" is not an integer number.", "Error", 0);
            }
            if (n > 0) {
                this.setEnabledWhileRunning();
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.task = new TestingTask(n);
                this.task.addPropertyChangeListener(this);
                this.task.execute();
            }
        } else if (actionEvent.getSource() == this.stopButton) {
            if (this.task != null) {
                this.task.cancel(false);
            }
            this.setEnabledAfterRunning();
        } else if (actionEvent.getSource() == this.closeButton) {
            this.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("progress".equals(propertyChangeEvent.getPropertyName())) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.progressBar.setValue(n);
        }
    }

    public static void main(String[] stringArray) {
        GUIUtils.testJDialog(new PerformanceTestingDialog(null));
    }

    class TestingTask
    extends SwingWorker<Void, Void> {
        private int executions = 0;
        private Filter op;
        private long totalTime;

        private TestingTask(int n) {
            this.executions = n;
        }

        @Override
        public Void doInBackground() {
            int n = 0;
            this.setProgress(n);
            this.op = (Filter)PerformanceTestingDialog.this.opSelector.getSelectedItem();
            long l = System.nanoTime();
            long l2 = Long.MAX_VALUE;
            for (int i = 0; i < this.executions; ++i) {
                long l3 = System.nanoTime();
                this.op.execute(ChangeReason.PERFORMANCE_TEST);
                long l4 = (System.nanoTime() - l3) / 1000000L;
                if (l4 < l2) {
                    l2 = l4;
                }
                n = 100 * (i + 1) / this.executions;
                this.setProgress(n);
                if (!this.isCancelled()) continue;
                this.totalTime = (System.nanoTime() - l) / 1000000L;
                String string = this.getReport(this.op.getMenuName(), i + 1, this.totalTime, l2);
                this.showResults(string);
                return null;
            }
            this.totalTime = (System.nanoTime() - l) / 1000000L;
            String string = this.getReport(this.op.getMenuName(), this.executions, this.totalTime, l2);
            this.showResults(string);
            return null;
        }

        private void showResults(final String string) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(PerformanceTestingDialog.this, string, "Performance Testing Results", 1);
                }
            });
        }

        private String getReport(String string, int n, long l, long l2) {
            return "Executing \"" + string + "\" " + n + " times took " + l + " ms, average time = " + l / (long)n + " ms, shortest time = " + l2 + "ms.";
        }

        @Override
        public void done() {
            PerformanceTestingDialog.this.setCursor(null);
            PerformanceTestingDialog.this.setEnabledAfterRunning();
        }
    }
}

