/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.util;

import it.tidalwave.imageio.util.Logger;
import it.tidalwave.imageio.util.Lookup;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLookup
extends Lookup {
    private static final String CLASS = DefaultLookup.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private final Set<Object> contents = new HashSet<Object>();

    protected DefaultLookup(Object ... contents) {
        for (Object content : contents) {
            if (content == null) continue;
            this.contents.add(content);
        }
    }

    @Override
    @Nonnull
    public <T> T lookup(@Nonnull Class<T> type, @Nonnull T defaultValue) {
        try {
            return this.lookup(type);
        }
        catch (Lookup.NotFoundException e) {
            return defaultValue;
        }
    }

    @Override
    @Nonnull
    public <T> T lookup(@Nonnull Class<T> type) throws Lookup.NotFoundException {
        for (Object param : this.contents) {
            if (!type.isAssignableFrom(param.getClass())) continue;
            logger.finest("lookup(%s) returning %s", type, param);
            return (T)param;
        }
        logger.finest("lookup(%s) throwing NotFoundException", type);
        throw new Lookup.NotFoundException(type);
    }

    @Override
    public String toContentString() {
        return this.contents.toString();
    }

    @Nonnull
    public String toString() {
        return String.format("DefaultLookup%s", this.contents);
    }
}

