/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.util;

import it.tidalwave.imageio.util.DefaultLookup;
import it.tidalwave.imageio.util.Logger;
import it.tidalwave.imageio.util.Lookup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultingLookup
extends DefaultLookup {
    private static final String CLASS = DefaultingLookup.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    @Nonnull
    private final Lookup delegate;

    public DefaultingLookup(@Nonnull Lookup delegate) {
        super(new Object[0]);
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public <T> T lookup(@Nonnull Class<T> type) throws Lookup.NotFoundException {
        Object defaultValue = null;
        try {
            Method getDefault = type.getMethod("getDefault", new Class[0]);
            defaultValue = getDefault.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        T result = this.delegate.lookup(type, defaultValue);
        logger.finest("lookup(%s) returning %s", type, result);
        return result;
    }

    @Override
    public String toContentString() {
        return this.delegate.toContentString();
    }

    @Override
    @Nonnull
    public String toString() {
        return String.format("DefaultingLookup[%s]", this.delegate);
    }
}

