/*
 * Decompiled with CFR 0.152.
 */
package WatermarkHelper;

import GUI.CaptionGUI;
import GUI.ImageGUI;
import GUI.ShapeGUI;
import GUI.TextGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class WaterMarkHelper {
    private String imageOrImagesSelectBox = null;
    private File outputImageFolderPath = null;
    private File inputParentFolderPath = null;
    private ArrayList inputFiles = null;
    private ArrayList inputFilesCaption = null;
    private int completeImageList = 0;
    private double maxImageHeight = 0.0;
    private double maxImageWidth = 0.0;
    private double imageQuality = 1.0;
    private ArrayList waterMarkerList = new ArrayList();
    private JFrame mainFrame;
    private JPanel mainPanel;
    private JLabel mainStatus;
    private JPanel mainWaterMarksDetails;
    private JProgressBar mainProgressBar;
    private Thread Worker;
    private boolean pause;
    private boolean stop;
    private boolean losseless;
    private JTextField inPutImageTextField;
    private JTextField outPutImageTextField;
    private JTextField imageQualityTextField;
    private String outputFolderName;
    private String ReportFileName = "";
    String extensions;
    private String[] imageFormats;
    Properties prop;
    private static Logger logger = Logger.getLogger("WatermarkLogger");

    public void setExtensions() {
        this.extensions = this.getProperty("constants.supported.extensions");
    }

    public void setImageFormats() {
        this.imageFormats = this.extensions.split(this.getProperty("constants.supported.extensions.seperator"));
    }

    public boolean checkInteger(String s) {
        try {
            Integer.parseInt(s.trim());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean checkExtension(String FilePath) {
        String extension = FilePath.substring(FilePath.lastIndexOf(".") + 1).toUpperCase();
        ArrayList<String> ExtensionList = new ArrayList<String>(Arrays.asList(this.extensions.split(this.getProperty("constants.supported.extensions.seperator"))));
        return ExtensionList.contains(extension);
    }

    public TitledBorder panelBorder(String Title) {
        LineBorder b = new LineBorder(new Color(0, 153, 255), 1, true);
        return new TitledBorder(b, Title, 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255));
    }

    public void createReportFile() {
        try {
            this.MakeOutputDirectory();
            this.ReportFileName = this.getOutputImageFolderPath().getPath() + File.separator + this.getOutputFolderName() + File.separator + "Report_" + this.getDate() + ".txt";
            File f = new File(this.ReportFileName);
            BufferedWriter output = null;
            output = new BufferedWriter(new FileWriter(f));
            output.write("\t\t\t\t\tWatermarking Reort\n\nNumber of Files To Watermark:\t" + this.inputFiles.size() + "\n");
            ((Writer)output).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setLogParam() {
        try {
            logger.setUseParentHandlers(false);
            File F = new File("Log");
            if (!F.isDirectory()) {
                F.mkdir();
            }
            FileHandler fh = new FileHandler("Log" + File.separator + "Watermarker_" + this.getDate() + "%g.log", Integer.parseInt(this.getProperty("constants.log.limit")), Integer.parseInt(this.getProperty("constants.log.count")));
            ConsoleHandler ch = new ConsoleHandler();
            ch.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    return WaterMarkHelper.this.getDate() + "\t" + record.getLevel() + "     \t:\t" + record.getMessage() + "\n";
                }
            });
            fh.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    return WaterMarkHelper.this.getDate() + "\t" + record.getLevel() + "     \t:\t" + record.getMessage() + "\n";
                }
            });
            logger.addHandler(ch);
            logger.addHandler(fh);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Info(String log) {
        logger.info(log);
    }

    public void warning(String log) {
        logger.warning(log);
    }

    public void severe(String log) {
        logger.severe(log);
    }

    public void appendReport(String appendText) {
        File f = new File(this.ReportFileName);
        if (f.exists()) {
            try {
                long fileLength = f.length();
                RandomAccessFile raf = new RandomAccessFile(f, "rw");
                raf.seek(fileLength);
                raf.writeBytes(appendText);
                raf.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BufferedImage getPreview(File file) {
        String inputFileName = file.getPath();
        String extension = inputFileName.substring(inputFileName.lastIndexOf("."));
        BufferedImage image = null;
        if (extension.equalsIgnoreCase(".tiff") || extension.equalsIgnoreCase(".tif") || extension.equalsIgnoreCase(".dng") || extension.equalsIgnoreCase(".nef")) {
            RenderedOp images = JAI.create((String)"fileload", (Object)file.getPath());
            image = this.convertRenderedImage((RenderedImage)images);
        } else if (extension.equalsIgnoreCase(".jpg") || extension.equalsIgnoreCase(".jpeg") || extension.equalsIgnoreCase(".jpe") || extension.equalsIgnoreCase(".jfif") || extension.equalsIgnoreCase(".bmp") || extension.equalsIgnoreCase(".png") || extension.equalsIgnoreCase(".gif")) {
            try {
                image = ImageIO.read(new File(file.getPath()));
            }
            catch (IOException ex) {}
        } else {
            try {
                URL is = this.getClass().getResource("/image/blank.png");
                image = ImageIO.read(is);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return image;
    }

    public void readPropertyFile() {
        try {
            InputStream confFile = this.getClass().getResourceAsStream("/ApplicationResource/ApplicationResource.properties");
            this.prop = new Properties();
            this.prop.load(confFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProperty(String key) {
        return (String)this.prop.get(key);
    }

    public void checkNumber(JTextField textField) {
        String XVal = textField.getText();
        if (!this.checkInteger(XVal)) {
            textField.setText("0");
        }
    }

    public BufferedImage convertRenderedImage(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                properties.put(keys[i], img.getProperty(keys[i]));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }

    public String imageSize(double height, double width, double MaxHeight, double MaxWidth) {
        double x = 0.0;
        double y = 0.0;
        double widthreturn = 0.0;
        double hightreturn = 0.0;
        if (width > height) {
            x = MaxWidth / width;
            hightreturn = (int)Math.ceil(height *= x);
            widthreturn = MaxWidth;
            if (hightreturn > MaxHeight) {
                y = MaxHeight / height;
                width = MaxWidth * y;
                widthreturn = (int)Math.ceil(width);
                hightreturn = MaxHeight;
            }
        } else {
            y = MaxHeight / height;
            widthreturn = (int)Math.ceil(width *= y);
            hightreturn = MaxHeight;
            if (widthreturn > MaxWidth) {
                x = MaxWidth / width;
                height = MaxHeight * x;
                hightreturn = (int)Math.ceil(height);
                widthreturn = MaxWidth;
            }
        }
        return hightreturn + "##@@##" + widthreturn;
    }

    public String getDate() {
        Calendar currentDate = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat(this.getProperty("constants.dataFormat"));
        String dateNow = formatter.format(currentDate.getTime());
        return dateNow;
    }

    public void MakeOutputDirectory() {
        String outputPath = this.outputImageFolderPath.getPath() + File.separator + this.outputFolderName;
        File OutputFile = new File(outputPath);
        if (!OutputFile.isDirectory()) {
            OutputFile.mkdir();
        }
    }

    public void MakeFolderStructure(String path) {
        String outputPath = this.outputImageFolderPath.getPath() + File.separator + this.outputFolderName;
        File OutputFile = new File(outputPath);
        if (!OutputFile.isDirectory()) {
            OutputFile.mkdir();
        }
        String outPutPath = path.replace(File.separator, "@@##@");
        String[] folderNames = outPutPath.split("@@##@");
        String SplitOutput = outputPath.replace(File.separator, "@@##@");
        String outPutFolderName = outputPath;
        for (int i = SplitOutput.split("@@##@").length; i < folderNames.length - 1; ++i) {
            File file = new File(outPutFolderName = outPutFolderName + File.separator + folderNames[i]);
            if (file.isDirectory()) continue;
            file.mkdir();
        }
    }

    public void setEnable(JPanel panel) {
        Component[] com = panel.getComponents();
        for (int a = 0; a < com.length; ++a) {
            com[a].setEnabled(true);
        }
    }

    public void setDisable(JFrame f) {
        f.setEnabled(false);
    }

    public void setEnable(JFrame f) {
        f.setEnabled(true);
        f.show();
    }

    public void setWaterMarkDetails() {
        int i = 0;
        JTextArea[] WatermarkerTextArea = new JTextArea[this.waterMarkerList.size()];
        JButton[] Delete = new JButton[this.waterMarkerList.size()];
        JButton[] Edite = new JButton[this.waterMarkerList.size()];
        JPanel[] jChangePanel = new JPanel[this.waterMarkerList.size()];
        JPanel[] jpanel = new JPanel[this.waterMarkerList.size()];
        this.mainWaterMarksDetails.setLayout(new BoxLayout(this.mainWaterMarksDetails, 1));
        for (ArrayList list : this.waterMarkerList) {
            int count = i + 1;
            String waterMarkDetails = "";
            waterMarkDetails = waterMarkDetails + "\n" + count + "] \n";
            if (list.get(0).toString().equalsIgnoreCase("TEXT")) {
                waterMarkDetails = waterMarkDetails + "Type: " + list.get(0) + " \n";
                String[] WatermarkingText = (String[])list.get(1);
                String textString = "";
                for (int r = 0; r < WatermarkingText.length; ++r) {
                    textString = textString + WatermarkingText[r] + "\n";
                }
                waterMarkDetails = waterMarkDetails + "Text to Watermark: \n" + textString;
                Font font = (Font)list.get(7);
                waterMarkDetails = waterMarkDetails + "Font Name : " + font.getFontName() + " Font Style :" + font.getStyle() + " Font Size : " + font.getSize() + " \n";
                Color color = (Color)list.get(8);
                waterMarkDetails = waterMarkDetails + "Colour: Red : " + color.getRed() + " Green : " + color.getGreen() + " Blue : " + color.getBlue() + " \n";
            } else if (list.get(0).toString().equalsIgnoreCase("SHAPE")) {
                waterMarkDetails = waterMarkDetails + "Type: " + list.get(0) + " \n";
                waterMarkDetails = waterMarkDetails + "Shape: " + list.get(2) + " \n";
                waterMarkDetails = waterMarkDetails + "Shape Height: " + list.get(6) + " \n";
                waterMarkDetails = waterMarkDetails + "Shape Width: " + list.get(5) + " \n";
                Color color = (Color)list.get(8);
                waterMarkDetails = waterMarkDetails + "Colour: R " + color.getRed() + " G " + color.getGreen() + " B " + color.getBlue() + " \n";
            } else if (list.get(0).toString().equalsIgnoreCase("CAPTION")) {
                waterMarkDetails = waterMarkDetails + "Type: " + list.get(0) + " \n";
                Font font = (Font)list.get(7);
                waterMarkDetails = waterMarkDetails + "Font Name : " + font.getFontName() + " Font Style :" + font.getStyle() + " Font Size : " + font.getSize() + " \n";
                Color color = (Color)list.get(8);
                waterMarkDetails = waterMarkDetails + "Colour: Red : " + color.getRed() + " Green : " + color.getGreen() + " Blue : " + color.getBlue() + " \n";
            } else if (list.get(0).toString().equalsIgnoreCase("IMAGE")) {
                waterMarkDetails = waterMarkDetails + "Type: " + list.get(0) + " \n";
                waterMarkDetails = waterMarkDetails + "Image Path: " + list.get(3) + " \n";
                waterMarkDetails = waterMarkDetails + "Image Scale: " + list.get(4) + " \n";
            }
            waterMarkDetails = waterMarkDetails + "Fill: " + list.get(9) + " \n";
            waterMarkDetails = waterMarkDetails + "Position: " + list.get(10) + " \n";
            if (list.get(10).toString().equalsIgnoreCase("COUSTOME")) {
                waterMarkDetails = waterMarkDetails + "X position: " + list.get(11) + " \n";
                waterMarkDetails = waterMarkDetails + "Y position: " + list.get(12) + " \n";
            } else {
                if (Integer.parseInt(list.get(13).toString()) != 0) {
                    waterMarkDetails = waterMarkDetails + "H Spacing: " + list.get(13) + " \n";
                }
                if (Integer.parseInt(list.get(14).toString()) != 0) {
                    waterMarkDetails = waterMarkDetails + "V Spacing: " + list.get(14) + " \n";
                }
            }
            String[] lineCounter = waterMarkDetails.split("\n");
            Delete[i] = new JButton();
            Edite[i] = new JButton();
            WatermarkerTextArea[i] = new JTextArea();
            jChangePanel[i] = new JPanel();
            jChangePanel[i].setBackground(new Color(51, 51, 51));
            jChangePanel[i].setLayout(new BoxLayout(jChangePanel[i], 1));
            jpanel[i] = new JPanel();
            jpanel[i].setBackground(new Color(51, 51, 51));
            jpanel[i].setLayout(new BoxLayout(jpanel[i], 0));
            final int index = i;
            Delete[i].setText("Delete");
            Delete[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WaterMarkHelper.this.waterMarkerList.remove(index);
                    WaterMarkHelper.this.mainWaterMarksDetails.removeAll();
                    WaterMarkHelper.this.mainWaterMarksDetails.revalidate();
                    WaterMarkHelper.this.mainWaterMarksDetails.repaint();
                    WaterMarkHelper.this.setWaterMarkDetails();
                    WaterMarkHelper.this.Info("Watermarker at Index: " + index + " removed");
                }
            });
            Edite[i].setText(" Edite ");
            Edite[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Component[] compo = WaterMarkHelper.this.mainPanel.getComponents();
                    for (int a = 0; a < compo.length; ++a) {
                        compo[a].setEnabled(false);
                    }
                    ArrayList EditList = (ArrayList)WaterMarkHelper.this.waterMarkerList.get(index);
                    if (EditList.get(0).toString().equalsIgnoreCase("TEXT")) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                new TextGUI(WaterMarkHelper.this, true, index).setVisible(true);
                            }
                        });
                    } else if (EditList.get(0).toString().equalsIgnoreCase("IMAGE")) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                new ImageGUI(WaterMarkHelper.this, true, index).setVisible(true);
                            }
                        });
                    } else if (EditList.get(0).toString().equalsIgnoreCase("SHAPE")) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                new ShapeGUI(WaterMarkHelper.this, true, index).setVisible(true);
                            }
                        });
                    } else if (EditList.get(0).toString().equalsIgnoreCase("CAPTION")) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                new CaptionGUI(WaterMarkHelper.this, true, index).setVisible(true);
                            }
                        });
                    }
                }
            });
            WatermarkerTextArea[i].setForeground(new Color(255, 153, 0));
            WatermarkerTextArea[i].setBackground(new Color(51, 51, 51));
            WatermarkerTextArea[i].setDisabledTextColor(new Color(255, 153, 0));
            WatermarkerTextArea[i].setEnabled(false);
            WatermarkerTextArea[i].setRows(lineCounter.length);
            WatermarkerTextArea[i].setText(waterMarkDetails);
            JSeparator jSeparator1 = new JSeparator(1);
            jSeparator1.setForeground(new Color(51, 51, 51));
            JSeparator jSeparator3 = new JSeparator(0);
            jSeparator3.setForeground(new Color(51, 51, 51));
            jChangePanel[i].add(Edite[i]);
            jChangePanel[i].add(Box.createRigidArea(new Dimension(0, 10)));
            jChangePanel[i].add(Delete[i]);
            jpanel[i].add(Box.createRigidArea(new Dimension(10, 0)));
            jpanel[i].add(jChangePanel[i]);
            jpanel[i].add(Box.createRigidArea(new Dimension(10, 0)));
            jpanel[i].add(jSeparator1);
            jpanel[i].add(Box.createRigidArea(new Dimension(10, 0)));
            jpanel[i].add(WatermarkerTextArea[i]);
            jpanel[i].add(Box.createRigidArea(new Dimension(10, 0)));
            JSeparator jSeparator2 = new JSeparator(0);
            jSeparator2.setForeground(new Color(51, 51, 51));
            this.mainWaterMarksDetails.add(Box.createRigidArea(new Dimension(10, 0)));
            this.mainWaterMarksDetails.add(jpanel[i]);
            this.mainWaterMarksDetails.validate();
            this.mainWaterMarksDetails.add(jSeparator2);
            ++i;
        }
    }

    public void sliderChangeAction(JSlider jSlider, JTextField jTextField) {
        jSlider.setToolTipText(jSlider.getValue() + "%");
        jTextField.setText(String.valueOf(jSlider.getValue()) + "%");
    }

    public File getInputParentFolderPath() {
        return this.inputParentFolderPath;
    }

    public void setInputParentFolderPath(File inputParentFolderPath) {
        this.inputParentFolderPath = inputParentFolderPath;
    }

    public int getCompleteImageList() {
        return this.completeImageList;
    }

    public String[] getImageFormats() {
        return this.imageFormats;
    }

    public void setCompleteImageList(int completeImageList) {
        this.completeImageList = completeImageList;
    }

    public void setInputFiles(ArrayList inputFiles) {
        this.inputFiles = inputFiles;
    }

    public ArrayList getInputFiles() {
        return this.inputFiles;
    }

    public void setOutputFolderName(String outputFolderName) {
        this.outputFolderName = outputFolderName;
    }

    public String getOutputFolderName() {
        return this.outputFolderName;
    }

    public void setImageQualityTextField(JTextField imageQualityTextField) {
        this.imageQualityTextField = imageQualityTextField;
    }

    public void setInPutImageTextField(JTextField inPutImageTextField) {
        this.inPutImageTextField = inPutImageTextField;
    }

    public void setOutPutImageTextField(JTextField outPutImageTextField) {
        this.outPutImageTextField = outPutImageTextField;
    }

    public JTextField getImageQualityTextField() {
        return this.imageQualityTextField;
    }

    public JTextField getInPutImageTextField() {
        return this.inPutImageTextField;
    }

    public JTextField getOutPutImageTextField() {
        return this.outPutImageTextField;
    }

    public boolean isPause() {
        return this.pause;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public Thread getWorker() {
        return this.Worker;
    }

    public void setWorker(Thread Worker) {
        this.Worker = Worker;
    }

    public String getImageOrImagesSelectBox() {
        return this.imageOrImagesSelectBox;
    }

    public double getImageQuality() {
        return this.imageQuality;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JProgressBar getMainProgressBar() {
        return this.mainProgressBar;
    }

    public JLabel getMainStatus() {
        return this.mainStatus;
    }

    public JPanel getMainWaterMarksDetails() {
        return this.mainWaterMarksDetails;
    }

    public double getMaxImageHeight() {
        return this.maxImageHeight;
    }

    public double getMaxImageWidth() {
        return this.maxImageWidth;
    }

    public File getOutputImageFolderPath() {
        return this.outputImageFolderPath;
    }

    public ArrayList getWaterMarkerList() {
        return this.waterMarkerList;
    }

    public void setImageOrImagesSelectBox(String imageOrImagesSelectBox) {
        this.imageOrImagesSelectBox = imageOrImagesSelectBox;
    }

    public void setImageQuality(double imageQuality) {
        this.imageQuality = imageQuality;
    }

    public void setMainPanel(JPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    public void setMainProgressBar(JProgressBar mainProgressBar) {
        this.mainProgressBar = mainProgressBar;
    }

    public void setMainStatus(JLabel mainStatus) {
        this.mainStatus = mainStatus;
    }

    public void setMainWaterMarksDetails(JPanel mainWaterMarksDetails) {
        this.mainWaterMarksDetails = mainWaterMarksDetails;
    }

    public void setMaxImageHeight(double maxImageHeight) {
        this.maxImageHeight = maxImageHeight;
    }

    public void setMaxImageWidth(double maxImageWidth) {
        this.maxImageWidth = maxImageWidth;
    }

    public void setOutputImageFolderPath(File outputImageFolderPath) {
        this.outputImageFolderPath = outputImageFolderPath;
    }

    public void setWaterMarkerList(ArrayList waterMarkerList) {
        this.waterMarkerList = waterMarkerList;
    }

    public ArrayList getInputFilesCaption() {
        return this.inputFilesCaption;
    }

    public void setInputFilesCaption(ArrayList inputFilesCaption) {
        this.inputFilesCaption = inputFilesCaption;
    }

    public boolean isLosseless() {
        return this.losseless;
    }

    public void setLosseless(boolean losseless) {
        this.losseless = losseless;
    }

    public void setMainFrame(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }
}

