/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import javax.swing.KeyStroke;
import jdomain.jdraw.Settings;
import jdomain.jdraw.action.BlockingDrawAction;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.action.LoadAction;
import jdomain.jdraw.action.SaveAsAction;
import jdomain.jdraw.action.ViewAnimationAction;
import jdomain.jdraw.gio.GIFWriter;
import jdomain.jdraw.gio.IconWriter;
import jdomain.jdraw.gio.JPEGWriter;
import jdomain.jdraw.gio.PNGWriter;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.util.Log;
import jdomain.util.Util;
import jdomain.util.gui.GUIUtil;

public final class SaveAction
extends BlockingDrawAction {
    private static final long serialVersionUID = 1L;
    private String fileName;
    protected boolean success;
    static /* synthetic */ Class class$jdomain$jdraw$action$SaveAsAction;

    protected SaveAction() {
        super("Save", "save.png");
        this.setToolTipText("Saves the current image");
        this.setAccelerators(new KeyStroke[]{KeyStroke.getKeyStroke(new Character('S'), 2)});
    }

    public boolean successfullySaved() {
        return this.success;
    }

    public boolean prepareAction() {
        this.fileName = MainFrame.INSTANCE.getFileName();
        if (this.fileName == null) {
            DrawAction.getAction(class$jdomain$jdraw$action$SaveAsAction == null ? (class$jdomain$jdraw$action$SaveAsAction = SaveAction.class$("jdomain.jdraw.action.SaveAsAction")) : class$jdomain$jdraw$action$SaveAsAction).actionPerformed();
            return false;
        }
        if (Tool.getPicture().getFrameCount() > 1 && LoadAction.isPNG(this.fileName)) {
            boolean bl = GUIUtil.question(MainFrame.INSTANCE, "Single Frame Format", "The PNG format supports a single frame only. If you proceed, only the current frame will be saved. Do you realise this?", "Yeah, yeah", "Oops");
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveJDraw(String string) {
        boolean bl;
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(Tool.getPicture());
            bl = true;
        }
        catch (Exception exception) {
            boolean bl2;
            try {
                Log.exception(exception);
                bl2 = false;
            }
            catch (Throwable throwable) {
                Util.close(objectOutputStream);
                throw throwable;
            }
            Util.close(objectOutputStream);
            return bl2;
        }
        Util.close(objectOutputStream);
        return bl;
    }

    private boolean saveInterlaced() {
        SaveAsAction saveAsAction = (SaveAsAction)SaveAction.getAction(class$jdomain$jdraw$action$SaveAsAction == null ? (class$jdomain$jdraw$action$SaveAsAction = SaveAction.class$("jdomain.jdraw.action.SaveAsAction")) : class$jdomain$jdraw$action$SaveAsAction);
        return saveAsAction.saveInterlaced();
    }

    public void startAction() {
        if (LoadAction.isGIF(this.fileName)) {
            this.success = ViewAnimationAction.checkGIFColours() && GIFWriter.writeGIF(MainFrame.INSTANCE.getPicture(), this.fileName, this.saveInterlaced());
        } else if (LoadAction.isJDraw(this.fileName)) {
            this.success = this.saveJDraw(this.fileName);
        } else if (LoadAction.isICO(this.fileName)) {
            this.success = IconWriter.writeIcon(MainFrame.INSTANCE.getPicture(), this.fileName);
        } else if (LoadAction.isPNG(this.fileName)) {
            this.success = PNGWriter.writePNG(MainFrame.INSTANCE.getPicture(), this.fileName, this.saveInterlaced());
        } else if (LoadAction.isJPEG(this.fileName)) {
            this.success = JPEGWriter.writeJPEG(MainFrame.INSTANCE.getPicture(), this.fileName);
        } else {
            this.success = false;
            Log.warning("Image format not supported.");
        }
    }

    public void finishAction() {
        if (this.success) {
            Settings.INSTANCE.addLastFile(this.fileName);
            Settings.INSTANCE.save();
            UndoManager.INSTANCE.reset();
            Log.info("Saved to " + this.fileName);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

