/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gio;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.FrameSettings;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gio.GIFReader;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.SimpleLogListener;
import jdomain.util.Util;

public final class GIFWriter {
    private static final boolean DEBUG_WRITE = false;
    private static final int DEBUG_LEVEL = 1;
    private static final int MAX_CODE = 4095;
    private static final int[] LOOP_Y = new int[]{0, 4, 2, 1};
    private static final int[] LOOP_OFFSET = new int[]{8, 8, 4, 2};
    private static final int BIT_0 = 1;
    private static final int BIT_6 = 64;
    private static final int BIT_7 = 128;
    private final Picture picture;
    private final OutputStream out;
    private int paletteSize;
    private Frame frame;
    private int initialCodeSize;
    private int codeSize;
    private final HashMap codeMap = new HashMap(4096);
    private int clear;
    private int endLZW;
    private int freeCode;
    private int lastCode;
    private StringBuffer output;
    private int currentData;
    private int availableBits;
    private final boolean saveInterlaced;
    private int loop;
    private int x;
    private int y;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int w;
    private int h;

    private GIFWriter(Picture picture, OutputStream outputStream, boolean bl) {
        this.picture = picture;
        this.out = outputStream;
        this.saveInterlaced = bl;
    }

    private static void debug(int n, String string) {
        if (n >= 1) {
            Log.debug(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeGIF(Picture picture, String string, boolean bl) {
        boolean bl2;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            GIFWriter gIFWriter = new GIFWriter(picture, bufferedOutputStream, bl);
            gIFWriter.writeGIF();
            bl2 = true;
        }
        catch (Exception exception) {
            boolean bl3;
            try {
                Log.exception(exception);
                bl3 = false;
            }
            catch (Throwable throwable) {
                Util.close(bufferedOutputStream);
                throw throwable;
            }
            Util.close(bufferedOutputStream);
            return bl3;
        }
        Util.close(bufferedOutputStream);
        return bl2;
    }

    public static boolean writeGIF(Picture picture, String string) {
        return GIFWriter.writeGIF(picture, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeGIF(Picture picture, OutputStream outputStream, boolean bl) {
        try {
            GIFWriter gIFWriter = new GIFWriter(picture, outputStream, bl);
            gIFWriter.writeGIF();
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            Log.exception(exception);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            Util.close(outputStream);
        }
    }

    public static boolean writeGIF(Picture picture, OutputStream outputStream) {
        return GIFWriter.writeGIF(picture, outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGIF() throws Exception {
        try {
            int n;
            this.writeSignature();
            boolean bl = this.writeScreenDescriptor();
            if (bl) {
                this.writePalette(this.picture.getPalette());
            }
            if ((n = this.picture.getFrameCount()) > 1) {
                this.writeAnimationLoopExtension();
            }
            for (int i = 0; i < n; ++i) {
                this.writeFrame(this.picture.getFrame(i));
            }
            this.out.write(59);
        }
        finally {
            Util.close(this.out);
        }
    }

    private final void writeAnimationLoopExtension() throws Exception {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.out.write("NETSCAPE".getBytes());
        this.out.write("2.0".getBytes());
        this.out.write(3);
        this.out.write(1);
        this.writeInt(0);
        this.out.write(0);
    }

    private void writeFrame(Frame frame) throws Exception {
        boolean bl;
        if (frame.usesTransparency() || this.picture.getFrameCount() > 1) {
            this.writeGraphicControlExtension(frame);
        }
        if (bl = this.writeImageDescriptor(frame)) {
            this.writePalette(frame.getPalette());
        }
        this.writeImageData(frame);
    }

    private void addCode(int n, String string) {
        this.codeMap.put(string, new Integer(n));
    }

    private void addCode(String string) {
        this.addCode(this.freeCode, string);
        if (this.freeCode == 4095) {
            this.output(this.clear);
            this.initCodes();
        } else {
            if (this.freeCode > this.lastCode) {
                this.increaseCodeSize();
            }
            ++this.freeCode;
        }
    }

    private void initCodes() {
        this.codeSize = this.initialCodeSize + 1;
        int n = (int)Math.pow(2.0, this.initialCodeSize) - 1;
        this.clear = n + 1;
        this.endLZW = n + 2;
        this.freeCode = n + 3;
        this.lastCode = (int)(Math.pow(2.0, this.codeSize) - 1.0);
        this.codeMap.clear();
        for (int i = 0; i <= n; ++i) {
            String string = "" + (char)i;
            this.addCode(i, string);
        }
    }

    private boolean dataAvailable() {
        if (this.saveInterlaced) {
            return this.y != -1;
        }
        return this.y != this.maxY + 1 || this.x != this.minX;
    }

    private void compress(Frame frame) throws Exception {
        int n;
        this.frame = frame;
        this.initCodes();
        this.availableBits = 0;
        this.currentData = 0;
        this.loop = 0;
        this.x = this.minX;
        this.y = this.minY;
        this.output = new StringBuffer();
        String string = "";
        this.output(this.clear);
        do {
            char c = (char)this.getPixel();
            String string2 = string + c;
            n = this.findString(string2);
            if (n != -1) {
                string = string2;
                continue;
            }
            this.output(string);
            this.addCode(string2);
            string = "" + c;
        } while (this.dataAvailable());
        if (string.length() > 0) {
            this.output(this.findString(string));
        }
        this.output(this.endLZW);
        while (this.availableBits > 0) {
            n = 0xFF & this.currentData;
            this.output.append((char)n);
            this.currentData >>= 8;
            this.availableBits -= 8;
        }
        this.packData();
    }

    private void packData() throws Exception {
        int n;
        int n2 = 0;
        for (int i = this.output.length(); i > 0; i -= n) {
            n = Math.min(255, i);
            String string = this.output.substring(n2, n2 + n);
            this.out.write(n);
            for (int j = 0; j < n; ++j) {
                this.out.write(string.charAt(j));
            }
            n2 += n;
        }
    }

    private void increaseCodeSize() {
        ++this.codeSize;
        this.lastCode = (int)(Math.pow(2.0, this.codeSize) - 1.0);
    }

    private int findString(String string) {
        Integer n = (Integer)this.codeMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    private int getPixel() {
        int n = this.frame.getPixel(this.x, this.y);
        ++this.x;
        if (this.x > this.maxX) {
            this.x = this.minX;
            if (this.saveInterlaced) {
                this.y += LOOP_OFFSET[this.loop];
                while (this.y >= this.minY + this.h) {
                    ++this.loop;
                    if (this.loop < LOOP_Y.length) {
                        this.y = this.minY + LOOP_Y[this.loop];
                        continue;
                    }
                    this.y = -1;
                    break;
                }
            } else {
                ++this.y;
            }
        }
        return n;
    }

    private void output(String string) {
        int n = this.findString(string);
        Assert.isTrue(n != -1, "gio: internal error. code 0x" + Util.asBytes(string) + " not found.");
        this.output(n);
    }

    private void output(int n) {
        this.currentData |= (n <<= this.availableBits);
        this.availableBits += this.codeSize;
        while (this.availableBits >= 8) {
            int n2 = 0xFF & this.currentData;
            this.output.append((char)n2);
            this.currentData >>= 8;
            this.availableBits -= 8;
        }
    }

    private void writeImageData(Frame frame) throws Exception {
        this.initialCodeSize = this.paletteSize + 1;
        this.out.write(this.initialCodeSize);
        this.compress(frame);
        this.out.write(0);
    }

    private boolean writeImageDescriptor(Frame frame) throws Exception {
        boolean bl;
        boolean bl2;
        this.out.write(44);
        Frame.MinMax minMax = frame.getDimensions();
        this.minX = minMax.minX;
        this.minY = minMax.minY;
        this.w = minMax.width;
        this.h = minMax.height;
        this.maxX = minMax.minX + this.w - 1;
        this.maxY = minMax.minY + this.h - 1;
        this.writeInt(this.minX);
        this.writeInt(this.minY);
        this.writeInt(this.w);
        this.writeInt(this.h);
        int n = 0;
        boolean bl3 = bl2 = !frame.getPalette().equals(this.picture.getPalette());
        if (bl2) {
            n |= 0x80;
        }
        if (bl = this.saveInterlaced) {
            n |= 0x40;
        }
        if (bl2) {
            this.paletteSize = this.getPaletteSize(frame.getPalette());
            n += this.paletteSize;
        }
        this.out.write(n);
        return bl2;
    }

    private final int getPaletteSize(Palette palette) {
        int n = palette.size();
        int n2 = 1;
        while (Math.pow(2.0, n2) < (double)n) {
            ++n2;
        }
        return Math.max(1, n2 - 1);
    }

    private void writeGraphicControlExtension(Frame frame) throws Exception {
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        FrameSettings frameSettings = frame.getSettings();
        int n = 0;
        if (frame.usesTransparency()) {
            n |= 1;
        }
        this.out.write(n |= frameSettings.getDisposalMethod() << 2);
        this.writeInt(frameSettings.getDelay());
        n = 0;
        if (frame.usesTransparency()) {
            n = frame.getTransparentColour();
        }
        this.out.write(n);
        this.out.write(0);
    }

    private void writeSignature() throws Exception {
        this.out.write("GIF89a".getBytes());
    }

    private final void writePalette(Palette palette) throws Exception {
        int n;
        int n2 = palette.size();
        for (n = 0; n < n2; ++n) {
            Color color = palette.getColour(n).getColour();
            this.out.write(color.getRed());
            this.out.write(color.getGreen());
            this.out.write(color.getBlue());
        }
        n = (int)Math.pow(2.0, this.paletteSize + 1);
        int n3 = n - n2;
        if (n3 > 0) {
            byte[] byArray = new byte[3];
            byte by = 0;
            Arrays.fill(byArray, 0, 3, by);
            for (int i = 0; i < n3; ++i) {
                this.out.write(byArray);
            }
        }
    }

    private boolean writeScreenDescriptor() throws Exception {
        this.writeInt(this.picture.getWidth());
        this.writeInt(this.picture.getHeight());
        int n = 0;
        boolean bl = this.picture.usesGlobalPalette();
        if (bl) {
            n |= 0x80;
        }
        int n2 = this.paletteSize = this.getPaletteSize(this.picture.getPalette());
        n |= n2 << 4;
        this.out.write(n += this.paletteSize);
        this.out.write(this.picture.getPictureBackground());
        int n3 = 0;
        this.out.write(n3);
        return bl;
    }

    private void writeInt(int n) throws Exception {
        this.out.write(n);
        this.out.write(n >> 8);
    }

    public static void main(String[] stringArray) {
        SimpleLogListener simpleLogListener = new SimpleLogListener(System.out);
        Picture picture = GIFReader.readGIF("/home/michaela/tmp/test.gif");
        Log.addLogListener(simpleLogListener);
        if (picture != null) {
            GIFWriter.writeGIF(picture, "/home/michaela/tmp/out.gif");
        }
    }
}

