/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gio;

import java.awt.Color;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.SimpleLogListener;
import jdomain.util.Util;

public final class IconReader {
    private final InputStream in;
    private Picture picture;
    private int bytesRead = 0;
    private int iconCount;
    private final ArrayList icons = new ArrayList();

    private IconReader(InputStream inputStream) {
        this.in = inputStream;
    }

    public static Picture readIcon(String string) {
        try {
            IconReader iconReader;
            Picture picture;
            if (Log.DEBUG) {
                Log.debug("-- reading icon " + string);
            }
            if ((picture = (iconReader = new IconReader(new FileInputStream(string))).readIcon()) != null) {
                Palette palette = picture.getPalette();
                while (palette.size() < 2) {
                    palette.addColour(Color.white);
                }
                picture.setTransparent(0);
                picture.show();
            }
            return picture;
        }
        catch (Exception exception) {
            Log.exception(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Picture readIcon() throws Exception {
        try {
            this.readHeader();
            this.readIconEntries();
            this.readIconData();
            Dimension dimension = this.getMaxDimension();
            this.picture = new Picture(dimension.width, dimension.height);
            Iterator iterator = this.icons.iterator();
            while (iterator.hasNext()) {
                IconEntry iconEntry = (IconEntry)iterator.next();
                try {
                    Frame frame = iconEntry.createFrame();
                    this.picture.addFrame(frame);
                    if (this.picture.getPalette() != null) continue;
                    this.picture.setCurrentFrame(0);
                    this.picture.setPalette(frame.getPalette());
                }
                catch (Exception exception) {
                    Log.exception(exception);
                }
            }
            if (Log.DEBUG && this.readByte() != -1) {
                Log.debug("Ignoring extra data...");
            }
            Picture picture = this.picture;
            return picture;
        }
        finally {
            Util.close(this.in);
        }
    }

    private Dimension getMaxDimension() {
        Iterator iterator = this.icons.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            IconEntry iconEntry = (IconEntry)iterator.next();
            if (iconEntry.width > n) {
                n = iconEntry.width;
            }
            if (iconEntry.height <= n2) continue;
            n2 = iconEntry.height;
        }
        return new Dimension(n, n2);
    }

    private void readIconData() throws Exception {
        for (int i = 0; i < this.iconCount; ++i) {
            IconEntry iconEntry = (IconEntry)this.icons.get(i);
            iconEntry.readData();
        }
    }

    private void readIconEntries() throws Exception {
        for (int i = 0; i < this.iconCount; ++i) {
            this.icons.add(new IconEntry());
        }
    }

    private void readHeader() throws Exception {
        int n = 0;
        n = this.readInt();
        Assert.isTrue(n == 0, "gio: expected 0, got " + n);
        n = this.readInt();
        Assert.isTrue(n == 1, "gio: expected id 1, got " + n);
        this.iconCount = this.readInt();
        if (Log.DEBUG) {
            Log.debug("-- stored icons: " + this.iconCount);
        }
    }

    private int[] getPixels1(byte[] byArray, boolean[] blArray) {
        int n = byArray.length;
        int[] nArray = new int[n * 8];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            for (int j = 0; j < 8; ++j) {
                nArray[n2] = blArray[n2] ? (by >> 7 - j & 1) + 1 : 0;
                ++n2;
            }
        }
        return nArray;
    }

    private int[] getPixels4(byte[] byArray, boolean[] blArray) {
        int n = byArray.length;
        int[] nArray = new int[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            int n3 = 0xF & by >> 4;
            int n4 = 0xF & by;
            if (blArray[n2]) {
                nArray[n2] = n3 + 1;
            }
            if (blArray[++n2]) {
                nArray[n2] = n4 + 1;
            }
            ++n2;
        }
        return nArray;
    }

    private int[] getPixels8(byte[] byArray, boolean[] blArray) {
        int n = byArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[n2] = blArray[n2] ? (byArray[i] & 0xFF) + 1 : 0;
            ++n2;
        }
        return nArray;
    }

    private int[] getPixelsTrueColour(int[] nArray, boolean[] blArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray2[n2] = blArray[n2] ? nArray[i] + 1 : 0;
            ++n2;
        }
        return nArray2;
    }

    private boolean[] createBooleanField(byte[] byArray) {
        int n = byArray.length;
        boolean[] blArray = new boolean[n * 8];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            for (int j = 0; j < 8; ++j) {
                blArray[n2] = (by >> 7 - j & 1) == 0;
                ++n2;
            }
        }
        return blArray;
    }

    private int readInt() throws Exception {
        int n = this.readByte();
        int n2 = this.readByte();
        return n + (n2 <<= 8);
    }

    private int readByte() throws Exception {
        ++this.bytesRead;
        int n = this.in.read();
        return n;
    }

    private void readByte(byte[] byArray) throws Exception {
        this.bytesRead += byArray.length;
        this.in.read(byArray);
    }

    private int readDWord() throws Exception {
        int n = this.readInt();
        int n2 = this.readInt();
        return n + (n2 <<= 16);
    }

    public static void main(String[] stringArray) {
        SimpleLogListener simpleLogListener = new SimpleLogListener(System.out);
        Log.addLogListener(simpleLogListener);
        IconReader.readIcon("C:/Temp/test.ico");
    }

    private final class IconEntry {
        public int width;
        public int height;
        public int numColours;
        public int reserved;
        public int numPlanes;
        public int bitsPerPixel;
        public int dataSize;
        public int dataOffset;
        public byte[] bitMap;
        public int[] trueColourBitMap = null;
        public byte[] andMap;
        public final ArrayList colours = new ArrayList();

        public IconEntry() throws Exception {
            this.width = IconReader.this.readByte();
            this.height = IconReader.this.readByte();
            this.numColours = IconReader.this.readByte();
            this.reserved = IconReader.this.readByte();
            this.numPlanes = IconReader.this.readInt();
            this.bitsPerPixel = IconReader.this.readInt();
            this.dataSize = IconReader.this.readDWord();
            this.dataOffset = IconReader.this.readDWord();
            if (Log.DEBUG) {
                Log.debug("IconEntry");
                Log.debug("   width:   " + this.width);
                Log.debug("   height:  " + this.height);
                Log.debug("   colours: " + this.numColours);
                Log.debug("   size:    " + this.dataSize);
                Log.debug("   offset:  " + this.dataOffset);
            }
        }

        public void readData() throws Exception {
            while (IconReader.this.bytesRead < this.dataOffset) {
                Log.debug("swallowing a byte...");
                IconReader.this.readByte();
            }
            int n = 0;
            n = IconReader.this.readDWord();
            int n2 = IconReader.this.readDWord();
            int n3 = IconReader.this.readDWord();
            n = IconReader.this.readInt();
            this.bitsPerPixel = IconReader.this.readInt();
            n = IconReader.this.readDWord();
            int n4 = IconReader.this.readDWord();
            n = IconReader.this.readDWord();
            n = IconReader.this.readDWord();
            int n5 = IconReader.this.readDWord();
            if (n5 == 0) {
                n5 = 1 << this.bitsPerPixel;
            }
            n = IconReader.this.readDWord();
            if (Log.DEBUG) {
                Log.debug("\nIcon Data");
                Log.debug("   bitsPerPixel: " + this.bitsPerPixel);
                Log.debug("   width:        " + n2);
                Log.debug("   height:       " + n3);
                Log.debug("   bitmapSize:   " + n4);
                Log.debug("   colourCount:  " + n5);
            }
            boolean bl = this.bitsPerPixel > 8;
            int n6 = this.width * this.height;
            if (!bl) {
                for (n = 0; n < n5; ++n) {
                    int n7 = IconReader.this.readByte();
                    int n8 = IconReader.this.readByte();
                    int n9 = IconReader.this.readByte();
                    IconReader.this.readByte();
                    this.colours.add(new Color(n9, n8, n7));
                }
                int n10 = n6;
                if (this.bitsPerPixel == 1) {
                    n10 /= 8;
                    if (n6 % 8 > 0) {
                        ++n10;
                    }
                } else if (this.bitsPerPixel == 4) {
                    n10 /= 2;
                    if (n6 % 2 > 0) {
                        ++n10;
                    }
                }
                this.bitMap = new byte[n10];
                IconReader.this.readByte(this.bitMap);
                int n11 = n6 / 8;
                if (n6 % 8 > 0) {
                    ++n11;
                }
                this.andMap = new byte[n11];
                IconReader.this.readByte(this.andMap);
            } else {
                int n12;
                int n13 = n6;
                this.trueColourBitMap = new int[n13];
                boolean bl2 = this.bitsPerPixel == 32;
                int n14 = 255;
                for (n12 = 0; n12 < this.height; ++n12) {
                    for (int i = 0; i < this.width; ++i) {
                        Color color;
                        int n15;
                        int n16 = IconReader.this.readByte();
                        int n17 = IconReader.this.readByte();
                        int n18 = IconReader.this.readByte();
                        if (bl2) {
                            n14 = IconReader.this.readByte();
                        }
                        if ((n15 = this.colours.indexOf(color = new Color(n18, n17, n16, n14))) == -1) {
                            n15 = this.colours.size();
                            this.colours.add(color);
                        }
                        this.trueColourBitMap[n12 * this.width + i] = n15;
                    }
                }
                n12 = n6 / 8;
                if (n6 % 8 > 0) {
                    ++n12;
                }
                this.andMap = new byte[n12];
                IconReader.this.readByte(this.andMap);
            }
        }

        public int[] getPixels() {
            boolean[] blArray = IconReader.this.createBooleanField(this.andMap);
            switch (this.bitsPerPixel) {
                case 1: {
                    return IconReader.this.getPixels1(this.bitMap, blArray);
                }
                case 4: {
                    return IconReader.this.getPixels4(this.bitMap, blArray);
                }
                case 8: {
                    return IconReader.this.getPixels8(this.bitMap, blArray);
                }
            }
            Assert.notNull(this.trueColourBitMap, "gio: cannot handle icons with bitsPerPixel=" + this.bitsPerPixel);
            return IconReader.this.getPixelsTrueColour(this.trueColourBitMap, blArray);
        }

        public Frame createFrame() {
            Frame frame = new Frame(IconReader.this.picture);
            frame.getSettings().setIconWidth(this.width);
            frame.getSettings().setIconHeight(this.height);
            Palette palette = new Palette(IconReader.this.picture);
            Iterator iterator = this.colours.iterator();
            palette.addColour(Color.black);
            frame.setTransparent(0);
            while (iterator.hasNext()) {
                palette.addColour((Color)iterator.next());
            }
            frame.setPalette(palette);
            int[] nArray = this.getPixels();
            int n = 0;
            for (int i = this.height - 1; i >= 0; --i) {
                for (int j = 0; j < this.width; ++j) {
                    frame.setPixelQuiet(j, i, nArray[n]);
                    ++n;
                }
            }
            this.colours.clear();
            nArray = null;
            this.bitMap = null;
            this.andMap = null;
            return frame;
        }
    }
}

