/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.data.ColourEntry;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.jdraw.data.event.EventConstants;
import jdomain.jdraw.gui.DrawPanel;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.PalettePanel;
import jdomain.jdraw.gui.PreviewPanel;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Assert;
import jdomain.util.Log;

public final class Dispatcher
implements EventConstants {
    static /* synthetic */ Class class$jdomain$jdraw$action$SwapColoursAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$RemoveColourAction;

    private Dispatcher() {
    }

    private static void fail(ChangeEvent changeEvent) {
        Assert.fail("gui: cannot handle " + changeEvent.toString());
    }

    private static Picture getPicture() {
        return Tool.getPicture();
    }

    public static void dispatch(ChangeEvent changeEvent) {
        if (Log.DEBUG) {
            Log.debug("-- dispatch " + changeEvent.toString());
        }
        switch (changeEvent.changeType) {
            case 0: 
            case 1: {
                Dispatcher.dispatchClipEvent(changeEvent);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                Dispatcher.dispatchFrameEvent(changeEvent);
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                Dispatcher.dispatchPaletteEvent(changeEvent);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                Dispatcher.dispatchPictureEvent(changeEvent);
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                Dispatcher.dispatchColourEntryEvent(changeEvent);
                break;
            }
            default: {
                Dispatcher.fail(changeEvent);
            }
        }
    }

    private static void dispatchPictureEvent(ChangeEvent changeEvent) {
        switch (changeEvent.changeType) {
            case 37: 
            case 38: {
                PalettePanel.INSTANCE.changeColour(changeEvent);
                DrawAction.getAction(class$jdomain$jdraw$action$SwapColoursAction == null ? (class$jdomain$jdraw$action$SwapColoursAction = Dispatcher.class$("jdomain.jdraw.action.SwapColoursAction")) : class$jdomain$jdraw$action$SwapColoursAction).setEnabled(Dispatcher.getPicture().getForeground() != Dispatcher.getPicture().getBackground());
                break;
            }
            case 36: {
                PalettePanel.INSTANCE.changeColour(changeEvent);
                Tool.getCurrentFramePanel().changeMainBackground(changeEvent);
                break;
            }
            case 30: {
                Frame frame = Tool.getCurrentFrame();
                frame.addDataChangeListener(MainFrame.INSTANCE);
                FolderPanel.INSTANCE.changeFrameAdded(changeEvent);
                break;
            }
            case 32: {
                FolderPanel.INSTANCE.changeFrameSet(changeEvent);
                break;
            }
            case 31: {
                FolderPanel.INSTANCE.changeFrameRemoved(changeEvent);
                break;
            }
            case 35: {
                MainFrame.INSTANCE.setPicture(Tool.getPicture());
                break;
            }
            case 34: {
                MainFrame.INSTANCE.updateTitle();
                DrawPanel drawPanel = Tool.getDrawPanel();
                drawPanel.setPreferredSize(drawPanel.getPreferredSize());
                PreviewPanel.INSTANCE.setPreferredSize(PreviewPanel.INSTANCE.getPreferredSize());
                break;
            }
            default: {
                Dispatcher.fail(changeEvent);
            }
        }
    }

    private static void dispatchPaletteEvent(ChangeEvent changeEvent) {
        switch (changeEvent.changeType) {
            case 22: {
                PalettePanel.INSTANCE.colourAdded((ColourEntry)changeEvent.getNewValue());
                MainFrame.INSTANCE.updateTitle();
                break;
            }
            case 21: {
                PalettePanel.INSTANCE.changeColour(changeEvent);
                break;
            }
            case 20: {
                PalettePanel.INSTANCE.setPalette((Palette)changeEvent.source);
                DrawAction.getAction(class$jdomain$jdraw$action$RemoveColourAction == null ? (class$jdomain$jdraw$action$RemoveColourAction = Dispatcher.class$("jdomain.jdraw.action.RemoveColourAction")) : class$jdomain$jdraw$action$RemoveColourAction).setEnabled(Dispatcher.getPicture().getCurrentPalette().size() > 2);
                break;
            }
            default: {
                Dispatcher.fail(changeEvent);
            }
        }
    }

    private static void dispatchClipEvent(ChangeEvent changeEvent) {
        switch (changeEvent.changeType) {
            case 1: {
                Tool.getCurrentFramePanel().changePixel(changeEvent);
                break;
            }
            case 0: {
                Tool.getCurrentFramePanel().changeClipData(changeEvent);
                break;
            }
            default: {
                Dispatcher.fail(changeEvent);
            }
        }
    }

    private static void dispatchFrameEvent(ChangeEvent changeEvent) {
        switch (changeEvent.changeType) {
            case 10: {
                Tool.getCurrentFramePanel().changeNeedsRepaint(changeEvent);
                break;
            }
            case 12: {
                PalettePanel.INSTANCE.changeColour(changeEvent);
                Tool.getCurrentFramePanel().changeNeedsRepaint(changeEvent);
                break;
            }
            case 11: {
                Palette palette = Tool.getCurrentPalette();
                Tool.getCurrentFramePanel().changeNeedsRepaint(changeEvent);
                PalettePanel.INSTANCE.setPalette(palette);
                palette.addDataChangeListener(MainFrame.INSTANCE);
                break;
            }
            default: {
                Dispatcher.fail(changeEvent);
            }
        }
    }

    private static void dispatchColourEntryEvent(ChangeEvent changeEvent) {
        switch (changeEvent.changeType) {
            default: 
        }
        Dispatcher.fail(changeEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

