/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jdomain.jdraw.gui.DrawLayers;
import jdomain.jdraw.gui.FloatingClip;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.Tool;

public final class InfoClip
extends FloatingClip {
    private static final long serialVersionUID = 1L;
    public static final InfoClip INSTANCE = new InfoClip();
    private static final int X_OFFSET = 15;
    private static final int Y_OFFSET = -10;
    private final JLabel info = new JLabel();
    private MouseEvent lastEvent;
    private Point lastViewPoint;

    private InfoClip() {
        super(DrawLayers.INFO_CLIP_LAYER);
        this.info.setFont(MainFrame.DEFAULT_FONT);
        this.info.setForeground(Color.white);
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.info);
    }

    public String getName() {
        return "Info";
    }

    private Point translate(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint(Tool.getDrawPanel(), mouseEvent.getX(), mouseEvent.getY(), MainFrame.INSTANCE.getGlassPane());
        return point;
    }

    private String getInfo(MouseEvent mouseEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        Point point = Tool.getRealPixel(mouseEvent);
        if (point == null) {
            return "";
        }
        stringBuffer.append(point.x);
        stringBuffer.append(",");
        stringBuffer.append(point.y);
        return stringBuffer.toString();
    }

    private void updateInfo(MouseEvent mouseEvent) {
        this.info.setText(this.getInfo(mouseEvent));
        Dimension dimension = this.getPreferredSize();
        Point point = this.translate(mouseEvent);
        int n = point.x + 15;
        int n2 = point.y + -10;
        this.defineClip(n, n2, dimension.width, dimension.height);
    }

    public Integer getLayer() {
        return super.getLayer();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.deactivate();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateInfo(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.deactivate();
        this.lastEvent = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateInfo(mouseEvent);
        this.lastEvent = mouseEvent;
        this.lastViewPoint = Tool.getViewPoint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.deactivate();
    }

    public final void paint(Graphics graphics) {
        if (this.isActive()) {
            graphics.setXORMode(Color.black);
            super.paint(graphics);
            graphics.setPaintMode();
        }
    }

    protected void repeat() {
        if (this.lastEvent != null) {
            Point point = Tool.getViewPoint();
            int n = point.x - this.lastViewPoint.x;
            int n2 = point.y - this.lastViewPoint.y;
            this.lastEvent.translatePoint(n, n2);
            this.mouseMoved(this.lastEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateInfo(mouseEvent);
    }
}

