/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import jdomain.jdraw.gui.Tool;

public abstract class RectangularSelectionTool
extends Tool {
    protected static final int INVALID = 0;
    protected static final int DRAGGED = 1;
    protected static final int PRESSED = 2;
    protected int lastAction = -1;
    protected Point start;
    protected Point current;
    protected Point upperLeft;
    protected int width;
    protected int height;
    private boolean ignore = false;

    protected abstract void processSelection(int var1);

    public void pressed(int n, Point point, int n2) {
        this.setSwallowKeys(true);
        if (this.isDragged()) {
            this.lastAction = 1;
            if (!this.ignore && point != null) {
                this.drawRubberBand();
                this.current = point;
                this.drawRubberBand();
            }
        } else if (point != null) {
            this.lastAction = 2;
            this.start = point;
            this.current = null;
        }
    }

    private void calculateRectangleBounds() {
        int n = Math.min(this.start.x, this.current.x);
        int n2 = Math.min(this.start.y, this.current.y);
        this.upperLeft = new Point(n, n2);
        int n3 = Math.max(this.start.x, this.current.x);
        int n4 = Math.max(this.start.y, this.current.y);
        this.width = n3 - n + 1;
        this.height = n4 - n2 + 1;
    }

    public final void released(int n, Point point) {
        if (this.lastAction == 1) {
            this.drawRubberBand();
            this.setSwallowKeys(false);
            this.processSelection(n);
        }
    }

    public static final boolean isValidSelection(Rectangle rectangle) {
        return Tool.getCurrentFrame().getBounds().contains(rectangle);
    }

    public static final boolean isValidSelection(int n, int n2, int n3, int n4) {
        return RectangularSelectionTool.isValidSelection(new Rectangle(n, n2, n3, n4));
    }

    protected final boolean isValidSelection() {
        return RectangularSelectionTool.isValidSelection(this.upperLeft.x, this.upperLeft.y, this.width, this.height);
    }

    protected void drawRubberBand() {
        if (this.current == null) {
            return;
        }
        this.calculateRectangleBounds();
        if (this.isValidSelection()) {
            Graphics2D graphics2D = (Graphics2D)Tool.getDrawPanel().getGraphics();
            graphics2D.setXORMode(Color.white);
            graphics2D.setColor(Color.darkGray);
            int n = RectangularSelectionTool.getGrid();
            graphics2D.drawRect(this.upperLeft.x * n, this.upperLeft.y * n, this.width * n, this.height * n);
            graphics2D.setPaintMode();
        }
    }

    protected void entered(int n, Point point) {
        this.ignore = false;
    }

    protected void exited(int n, Point point) {
        this.ignore = true;
    }
}

