/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Assert;
import jdomain.util.Util;
import jdomain.util.gui.WidgetFactory;

public final class ScaleDialog
extends DrawDialog
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private final JTextField widthField = new JTextField(6);
    private final JTextField heightField = new JTextField(6);
    private final JCheckBox keepRatioBox = new JCheckBox("Keep ratio");
    private boolean settingRatio = false;
    private final JComboBox styleBox = new JComboBox<String>(new String[]{"Scale smoothly", "Scale average", "Scale fast"});

    public ScaleDialog() {
        super("Scaling Dialog");
        this.setModal(true);
        this.setUndecorated(true);
        this.widthField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.widthField.setText(String.valueOf(Tool.getPictureWidth()));
        this.widthField.getDocument().addDocumentListener(this);
        this.heightField.setText(String.valueOf(Tool.getPictureHeight()));
        this.heightField.getDocument().addDocumentListener(this);
        this.keepRatioBox.setSelected(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        JLabel jLabel = new JLabel("<html><b>Please enter scaled image size:</b></html>");
        jLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Scaled image width:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.widthField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Scaled image height:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.heightField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.keepRatioBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.styleBox, gridBagConstraints);
        this.main.add((Component)jPanel, "Center");
        this.setDefaultBorder();
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
    }

    public int getScalingStyle() {
        int n = this.styleBox.getSelectedIndex();
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 2;
            }
        }
        Assert.fail("gui: unknown style " + n);
        return -1;
    }

    public Dimension getScalingDimension() {
        return new Dimension(Util.asInt(this.widthField.getText().trim()), Util.asInt(this.heightField.getText().trim()));
    }

    private void checkInput() {
        String string = this.widthField.getText().trim();
        String string2 = this.heightField.getText().trim();
        if (Util.isNumber(string, 1, Integer.MAX_VALUE) && Util.isNumber(string2, 1, Integer.MAX_VALUE)) {
            this.getApproveButton().setEnabled(true);
        } else {
            this.getApproveButton().setEnabled(false);
        }
    }

    private void update(Document document) {
        if (this.settingRatio) {
            return;
        }
        if (document == this.widthField.getDocument()) {
            String string = this.widthField.getText().trim();
            if (Util.isNumber(string, 1, Integer.MAX_VALUE)) {
                double d = Util.asInt(string);
                if (this.keepRatioBox.isSelected()) {
                    this.settingRatio = true;
                    double d2 = d / (double)Tool.getPictureWidth();
                    int n = (int)Math.round(d2 * (double)Tool.getPictureHeight());
                    this.heightField.setText(String.valueOf(n));
                }
            }
        } else {
            String string = this.heightField.getText().trim();
            if (Util.isNumber(string) && Util.isNumber(string, 1, Integer.MAX_VALUE)) {
                double d = Util.asInt(string);
                if (this.keepRatioBox.isSelected()) {
                    this.settingRatio = true;
                    double d3 = d / (double)Tool.getPictureHeight();
                    int n = (int)Math.round(d3 * (double)Tool.getPictureWidth());
                    this.widthField.setText(String.valueOf(n));
                }
            }
        }
        this.checkInput();
        this.settingRatio = false;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent.getDocument());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent.getDocument());
    }
}

