/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui.undo;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import jdomain.jdraw.data.ColourEntry;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.data.Pixel;
import jdomain.jdraw.gui.FillTool;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawPixel;
import jdomain.jdraw.gui.undo.Undoable;

public final class DrawFill
extends Undoable {
    private final ArrayList pixels = new ArrayList();
    private final int oldCol;
    private final int newCol;
    private final int width = this.frame.getWidth();
    private final int height = this.frame.getHeight();
    private final DrawPixel drawPixel;

    public DrawFill(int n, int n2, int n3, boolean bl) {
        this.oldCol = this.frame.getPixel(n2, n3);
        Picture picture = Tool.getPicture();
        this.newCol = n == 0 ? picture.getForeground() : picture.getBackground();
        if (this.newCol != this.oldCol) {
            if (bl) {
                this.drawPixel = this.saveComplete();
            } else {
                this.savePixels(n2, n3);
                this.drawPixel = null;
            }
        } else {
            this.drawPixel = null;
        }
    }

    public boolean isValid() {
        return this.drawPixel != null && this.drawPixel.isValid() || this.pixels.size() > 0;
    }

    private boolean isValid(int n, int n2) {
        return n >= 0 && n < this.width && n2 >= 0 && n2 < this.height;
    }

    private boolean hasColour(Point point, int n) {
        return this.hasColour(point.x, point.y, n);
    }

    private boolean hasColour(int n, int n2, int n3) {
        FillTool.Tolerance tolerance = FillTool.INSTANCE.getTolerance();
        Palette palette = Tool.getCurrentPalette();
        ColourEntry colourEntry = palette.getColour(n3);
        ColourEntry colourEntry2 = palette.getColour(this.frame.getPixel(n, n2));
        int n4 = Math.abs(colourEntry.getRed() - colourEntry2.getRed());
        int n5 = Math.abs(colourEntry.getGreen() - colourEntry2.getGreen());
        int n6 = Math.abs(colourEntry.getBlue() - colourEntry2.getBlue());
        int n7 = Math.abs(colourEntry.getAlpha() - colourEntry2.getAlpha());
        return n4 <= tolerance.redDiff && n5 <= tolerance.greenDiff && n6 <= tolerance.blueDiff && n7 <= tolerance.alphaDiff;
    }

    private DrawPixel saveComplete() {
        ArrayList<Pixel> arrayList = new ArrayList<Pixel>();
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n = this.frame.getPixel(j, i);
                if (!this.hasColour(j, i, this.oldCol)) continue;
                arrayList.add(new Pixel(j, i, n, this.newCol));
            }
        }
        Pixel[] pixelArray = new Pixel[arrayList.size()];
        arrayList.toArray(pixelArray);
        return new DrawPixel(pixelArray);
    }

    private void savePixels(int n, int n2) {
        int[][] nArray = new int[this.height][this.width];
        for (int i = 0; i < this.height; ++i) {
            Arrays.fill(nArray[i], -1);
        }
        ArrayList<Point> arrayList = new ArrayList<Point>(this.width * this.height);
        arrayList.add(new Point(n, n2));
        do {
            int n3;
            Point point = (Point)arrayList.remove(arrayList.size() - 1);
            if (nArray[point.y][point.x] != -1) continue;
            nArray[point.y][point.x] = n3 = this.hasColour(point, this.oldCol) ? 1 : 0;
            if (n3 != 1) continue;
            if (this.isValid(point.x, point.y - 1) && nArray[point.y - 1][point.x] == -1) {
                arrayList.add(new Point(point.x, point.y - 1));
            }
            if (this.isValid(point.x + 1, point.y) && nArray[point.y][point.x + 1] == -1) {
                arrayList.add(new Point(point.x + 1, point.y));
            }
            if (this.isValid(point.x, point.y + 1) && nArray[point.y + 1][point.x] == -1) {
                arrayList.add(new Point(point.x, point.y + 1));
            }
            if (!this.isValid(point.x - 1, point.y) || nArray[point.y][point.x - 1] != -1) continue;
            arrayList.add(new Point(point.x - 1, point.y));
        } while (arrayList.size() != 0);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (nArray[i][j] != 1) continue;
                this.pixels.add(new Point(j, i));
            }
        }
    }

    private void setPixel(int n) {
        Iterator iterator = this.pixels.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            this.frame.setPixelQuiet(point.x, point.y, n);
        }
        Tool.getCurrentFramePanel().changeNeedsRepaint(null);
    }

    public void redo() {
        if (this.drawPixel != null) {
            this.drawPixel.redo();
        } else {
            this.setPixel(this.newCol);
        }
    }

    public void undo() {
        if (this.drawPixel != null) {
            this.drawPixel.undo();
        } else {
            this.setPixel(this.oldCol);
        }
    }
}

