/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui.undo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawPixel;
import jdomain.jdraw.gui.undo.Undoable;

public final class DrawLine
extends Undoable {
    private final DrawPixel draw;

    public DrawLine(int n, Point point, Point point2) {
        Picture picture = Tool.getPicture();
        Palette palette = Tool.getCurrentPalette();
        Color color = n == 0 ? palette.getColour(picture.getForeground()).getColour() : palette.getColour(picture.getBackground()).getColour();
        this.draw = this.savePixels(color, point, point2);
    }

    public boolean isValid() {
        return this.draw != null;
    }

    private DrawPixel savePixels(Color color, Point point, Point point2) {
        Graphics graphics;
        Image image;
        int n = Math.min(point.x, point2.x);
        int n2 = Math.max(point.x, point2.x);
        int n3 = Math.min(point.y, point2.y);
        int n4 = Math.max(point.y, point2.y);
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        if (Tool.isAntialiasOn()) {
            image = FolderPanel.INSTANCE.createOffScreenImage();
            graphics = image.getGraphics();
            this.prepareGraphics(graphics);
        } else {
            image = FolderPanel.INSTANCE.createOffScreenImage(n, n3, n5, n6);
            graphics = image.getGraphics();
            graphics.translate(-n, -n3);
        }
        graphics.setColor(color);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        if (Tool.isAntialiasOn()) {
            return DrawLine.calculateDifference(this.frame, image, 0, 0, this.frame.getWidth(), this.frame.getHeight());
        }
        return DrawLine.calculateDifference(this.frame, image, n, n3, n5, n6);
    }

    public void redo() {
        this.draw.redo();
    }

    public void undo() {
        this.draw.undo();
    }
}

