/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util;

import java.io.FileOutputStream;
import java.io.PrintStream;
import jdomain.util.Assert;
import jdomain.util.LogListener;

public final class SimpleLogListener
implements LogListener {
    private PrintStream out;

    public SimpleLogListener(PrintStream printStream) {
        this.out = printStream;
    }

    public SimpleLogListener(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.out = new PrintStream(fileOutputStream);
        }
        catch (Exception exception) {
            Assert.fail("Logging error! " + exception.getMessage());
        }
    }

    private void print(String string) {
        this.out.println(string);
    }

    public void debug(String string) {
        this.print(string);
    }

    public void info(String string) {
        this.print(string);
    }

    public void warning(String string) {
        this.print("[warning] " + string);
    }

    public void warning(String string, Object object) {
        this.print("[warning] " + string);
        this.print("[" + object.toString() + "]");
    }

    public void error(String string) {
        this.print("[error] " + string);
    }

    public void exception(Throwable throwable) {
        this.print("[exception] " + throwable.getMessage());
        throwable.printStackTrace(this.out);
    }

    public void close() {
        this.out.flush();
        this.out.close();
    }
}

