/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jdomain.util.gui.StandardMainFrame;

public class StandardWindow
extends JFrame
implements KeyEventDispatcher {
    private static final long serialVersionUID = 1L;
    public static final int CANCEL = 0;
    public static final int APPROVE = 1;
    private JComponent firstFocusComponent = null;
    private JButton approveButton = null;
    private JButton cancelButton = null;
    private int result = 0;
    private boolean disposeOnClose = true;
    public final JPanel main = new JPanel(new BorderLayout(0, 0));
    private final JPanel buttons = new JPanel(new BorderLayout(0, 0));
    private final JPanel leftButtons = new JPanel(new FlowLayout(0, 0, 0));
    private final JPanel rightButtons = new JPanel(new FlowLayout(2, 0, 0));
    private final boolean ignoreEscapeKey;
    private final ArrayList buttonList = new ArrayList();
    private final StandardMainFrame mainFrame;

    public StandardWindow(StandardMainFrame standardMainFrame, String string, boolean bl) {
        super(string);
        this.mainFrame = standardMainFrame;
        this.ignoreEscapeKey = bl;
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setContentPane(this.main);
        this.buttons.add((Component)this.leftButtons, "West");
        this.buttons.add((Component)this.rightButtons, "East");
        this.buttons.setBorder(new EmptyBorder(15, 0, 0, 0));
        this.addWindowListener(new WindowAdapter(){

            public final void windowOpened(WindowEvent windowEvent) {
                if (StandardWindow.this.firstFocusComponent != null) {
                    StandardWindow.this.firstFocusComponent.grabFocus();
                }
                FocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(StandardWindow.this);
            }

            public final void windowClosed(WindowEvent windowEvent) {
                FocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(StandardWindow.this);
            }
        });
    }

    public final boolean isIconfied() {
        return (this.getExtendedState() & 1) != 0;
    }

    public StandardWindow(StandardMainFrame standardMainFrame, String string) {
        this(standardMainFrame, string, false);
    }

    public void setDisposeOnClose(boolean bl) {
        this.disposeOnClose = bl;
    }

    public final int getResult() {
        return this.result;
    }

    protected final void setFirstFocusComponent(JComponent jComponent) {
        this.firstFocusComponent = jComponent;
    }

    public final void setDefaultBorder() {
        this.main.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10)));
    }

    public final void addLeftButton(JButton jButton) {
        this.buttonList.add(jButton);
        this.leftButtons.add(jButton);
        this.leftButtons.add(Box.createHorizontalStrut(4));
    }

    public final void addRightButton(JButton jButton) {
        this.buttonList.add(jButton);
        this.rightButtons.add(Box.createHorizontalStrut(4));
        this.rightButtons.add(jButton);
    }

    public final void addButtonPanel() {
        this.main.add((Component)this.buttons, "South");
    }

    protected void approve() {
        this.result = 1;
        this.close();
    }

    protected void cancel() {
        this.result = 0;
        this.close();
    }

    private void resizeButtons() {
        int n = 0;
        Iterator iterator = this.buttonList.iterator();
        while (iterator.hasNext()) {
            int n2 = ((JButton)iterator.next()).getPreferredSize().height;
            if (n2 <= n) continue;
            n = n2;
        }
        iterator = this.buttonList.iterator();
        while (iterator.hasNext()) {
            JButton jButton = (JButton)iterator.next();
            Dimension dimension = jButton.getPreferredSize();
            dimension.height = n;
            jButton.setPreferredSize(dimension);
        }
    }

    public JButton getApproveButton() {
        if (this.approveButton == null) {
            this.approveButton = new JButton("OK");
            this.approveButton.setMnemonic('o');
            this.approveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StandardWindow.this.approve();
                }
            });
        }
        return this.approveButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setMnemonic('c');
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StandardWindow.this.cancel();
                }
            });
        }
        return this.cancelButton;
    }

    public final void open() {
        if (this.buttonList.size() > 0) {
            this.resizeButtons();
            this.buttons.add(Box.createHorizontalStrut(20), "Center");
        }
        this.pack();
        this.center();
        this.setVisible(true);
    }

    public final void close() {
        this.setVisible(false);
        if (this.disposeOnClose) {
            this.dispose();
        }
    }

    public final void center() {
        Dimension dimension = this.mainFrame == null || !this.mainFrame.isVisible() || this.mainFrame.isIconfied() ? Toolkit.getDefaultToolkit().getScreenSize() : this.mainFrame.getSize();
        Dimension dimension2 = this.getPreferredSize();
        Point point = new Point();
        point.x = Math.max(0, dimension.width / 2 - dimension2.width / 2);
        point.y = Math.max(0, dimension.height / 2 - dimension2.height / 2);
        this.setLocation(point.x, point.y);
    }

    protected boolean handleKey(KeyEvent keyEvent) {
        return false;
    }

    public final boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (!this.isActive()) {
            return false;
        }
        if (keyEvent.getID() == 400 && keyEvent.getKeyChar() == '\u001b' && keyEvent.getModifiers() == 0 && !this.ignoreEscapeKey) {
            this.cancel();
            return true;
        }
        return this.handleKey(keyEvent);
    }
}

