/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class ArrayLayout
implements LayoutManager,
Serializable {
    static final int LEFT = 0;
    static final int CENTER = 1;
    static final int RIGHT = 2;
    int xpad;
    int ypad;
    int nc;
    int nrow;
    int ncol;
    int row;
    int col;
    int[] wa;
    int[] ha;
    int align;
    final int pwr2;
    boolean fixedWidth;
    boolean fixedHeight;

    public void layoutContainer(Container container) {
        int n = 1;
        int n2 = 1;
        Insets insets = container.getInsets();
        int n3 = insets.top;
        int n4 = insets.bottom;
        int n5 = insets.left;
        int n6 = insets.right;
        this.findMaximumRowColDimensions(container);
        Dimension dimension = container.getSize();
        Dimension dimension2 = container.getPreferredSize();
        n = dimension.width > dimension2.width ? (dimension.width << 10) / dimension2.width : 1024;
        n2 = dimension.height > dimension2.height ? (dimension.height << 10) / dimension2.height : 1024;
        int n7 = n5 + this.xpad;
        int n8 = n3 + this.ypad;
        int n9 = 0;
        while (n9 < this.nc) {
            int n10;
            this.row = n9 / this.ncol;
            this.col = n9 - this.ncol * this.row;
            Component component = container.getComponent(n9);
            Dimension dimension3 = this.getSize(component);
            int n11 = this.fixedWidth ? this.wa[this.col] : dimension3.width;
            int n12 = this.fixedHeight ? this.ha[this.row] : dimension3.height;
            int n13 = this.rmult(n2, n8 + this.ha[this.row] / 2) - n12 / 2;
            switch (this.align) {
                case 0: {
                    n10 = this.rmult(n, n7);
                    break;
                }
                case 2: {
                    n10 = this.rmult(n, n7 + this.wa[this.col]) - n11;
                    break;
                }
                default: {
                    n10 = this.rmult(n, n7 + this.wa[this.col] / 2) - n11 / 2;
                }
            }
            component.setBounds(n10, n13, n11, n12);
            if (this.col < this.ncol - 1) {
                n7 += this.xpad + this.wa[this.col];
            } else {
                n7 = n5 + this.xpad;
                n8 += this.ypad + this.ha[this.row];
            }
            ++n9;
        }
    }

    private Dimension getSize(Component component) {
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component.getMaximumSize();
        Dimension dimension3 = component.getMinimumSize();
        dimension.width = dimension.width > dimension2.width ? dimension2.width : dimension.width;
        dimension.height = dimension.height > dimension2.height ? dimension2.height : dimension.height;
        dimension.width = dimension.width < dimension3.width ? dimension3.width : dimension.width;
        dimension.height = dimension.height < dimension3.height ? dimension3.height : dimension.height;
        return dimension;
    }

    private int rmult(int n, int n2) {
        return n * n2 >> 10;
    }

    private void findMaximumRowColDimensions(Container container) {
        this.nc = container.getComponentCount();
        this.nrow = (this.nc - 1) / this.ncol + 1;
        this.wa = new int[this.ncol];
        this.ha = new int[this.nrow];
        int n = 0;
        while (n < this.ncol) {
            this.wa[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.nrow) {
            this.ha[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.nc) {
            this.row = n / this.ncol;
            this.col = n - this.ncol * this.row;
            Component component = container.getComponent(n);
            Dimension dimension = this.getSize(component);
            if (dimension.width > this.wa[this.col]) {
                this.wa[this.col] = dimension.width;
            }
            if (dimension.height > this.ha[this.row]) {
                this.ha[this.row] = dimension.height;
            }
            ++n;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.layoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.layoutSize(container);
    }

    private Dimension layoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        this.findMaximumRowColDimensions(container);
        int n5 = n3 + n4;
        int n6 = n + n2;
        int n7 = 0;
        while (n7 < this.ncol) {
            n5 += this.xpad + this.wa[n7];
            ++n7;
        }
        n7 = 0;
        while (n7 < this.nrow) {
            n6 += this.ypad + this.ha[n7];
            ++n7;
        }
        return new Dimension(n5 += this.xpad, n6 += this.ypad);
    }

    public void addLayoutComponent(String string, Component component) {
        System.out.println("comp: " + component);
    }

    public void removeLayoutComponent(Component component) {
    }

    ArrayLayout(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.pwr2 = 10;
        this.ncol = n <= 0 ? 1 : n;
        this.xpad = n2;
        this.ypad = n3;
        this.align = n4;
        this.fixedWidth = bl;
        this.fixedHeight = bl2;
    }

    ArrayLayout(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, false, false);
    }

    ArrayLayout(int n) {
        this(n, 0, 0);
    }

    ArrayLayout(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }
}

