/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.obsolete;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class DialogModality {
    private final Dialog dialog;
    private final Component mouseBlocker = new JPanel(){
        {
            this.setOpaque(false);
            this.enableEvents(16L);
        }

        protected void processMouseEvent(MouseEvent event) {
            event.consume();
        }
    };
    private final ComponentListener mouseBlockerSynchronizer = new ComponentAdapter(){

        public void componentResized(ComponentEvent event) {
            DialogModality.this.mouseBlocker.setSize(event.getComponent().getSize());
        }
    };
    private final VetoableChangeListener windowFocusPreventer = new VetoableChangeListener(){
        private final Runnable refocuser = new Runnable(){

            public void run() {
                DialogModality.this.dialog.requestFocus();
            }
        };

        public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            Window owner;
            String property = event.getPropertyName();
            if (property.equals("focusedWindow") && (owner = DialogModality.this.dialog.getOwner()) != null && event.getNewValue() == owner) {
                EventQueue.invokeLater(this.refocuser);
                throw new PropertyVetoException("Window may not take focus while it has a modal dialog showing", event);
            }
        }
    };

    public DialogModality(JDialog d) {
        this.dialog = d;
    }

    public void install() {
        Window owner = this.dialog.getOwner();
        if (owner != null) {
            owner.addComponentListener(this.mouseBlockerSynchronizer);
        }
        KeyboardFocusManager k = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        k.addVetoableChangeListener("focusedWindow", this.windowFocusPreventer);
        Window parent = this.dialog.getOwner();
        if (parent instanceof RootPaneContainer) {
            JLayeredPane l = ((RootPaneContainer)((Object)parent)).getLayeredPane();
            this.mouseBlocker.setSize(l.getSize());
            l.add(this.mouseBlocker, new Integer(Integer.MAX_VALUE));
        } else {
            parent.setEnabled(false);
        }
    }

    public void uninstall() {
        Window owner = this.dialog.getOwner();
        if (owner != null) {
            owner.removeComponentListener(this.mouseBlockerSynchronizer);
        }
        KeyboardFocusManager k = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        k.removeVetoableChangeListener("focusedWindow", this.windowFocusPreventer);
        Window parent = this.dialog.getOwner();
        if (parent instanceof RootPaneContainer) {
            JLayeredPane l = ((RootPaneContainer)((Object)parent)).getLayeredPane();
            l.remove(this.mouseBlocker);
        } else {
            parent.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("DialogModality Test");
        frame.setDefaultCloseOperation(3);
        final JDialog dialog = new JDialog(frame, "Modal Dialog", false);
        dialog.setSize(200, 200);
        dialog.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)new JButton(new AbstractAction("Show Dialog"){

            public void actionPerformed(ActionEvent event) {
                dialog.getToolkit().beep();
                dialog.setVisible(true);
            }
        }), "First");
        frame.setSize(300, 300);
        frame.setLocationRelativeTo(frame.getOwner());
        dialog.setLocationRelativeTo(dialog.getOwner());
        new DialogModality(dialog).install();
        frame.setVisible(true);
    }
}

