/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.optimizer;

import com.saic.isd.printscreen.Util;
import com.saic.isd.util.report.Report;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.optimizer.Optimizer;
import org.gerhardb.jibs.optimizer.OptimizerPreferences;
import org.gerhardb.jibs.optimizer.WorkerDownload;
import org.gerhardb.jibs.util.FileLoopHelper;
import org.gerhardb.lib.io.DirectoriesOnlyFileFilter;
import org.gerhardb.lib.swing.JPanelRows;

public class DownloadPanel
extends JPanelRows {
    Optimizer myOptimizer;
    JProgressBar myProgressBar = new JProgressBar();
    JCheckBox myDedupCheckBox = new JCheckBox(Jibs.getString("DownloadPanel.0"));
    JCheckBox myAcrossCheckBox = new JCheckBox(Jibs.getString("DownloadPanel.1"));
    JCheckBox myRenameUniqueCheckBox = new JCheckBox(Jibs.getString("DownloadPanel.2"));
    JCheckBox myEnforceWindows = new JCheckBox(Jibs.getString("DownloadPanel.3"));
    JCheckBox myCleanUpEnding = new JCheckBox(Jibs.getString("DownloadPanel.4"));
    JRadioButton myDeleteRadioBtn = new JRadioButton(Jibs.getString("DownloadPanel.5"));
    JRadioButton myMoveRadioBtn;
    JRadioButton myDoNothingBtn = new JRadioButton(Jibs.getString("DownloadPanel.7"));
    JCheckBox myResizeCheckBox = new JCheckBox(Jibs.getString("DownloadPanel.8"));
    JLabel myCurrentAction = new JLabel(Jibs.getString("DownloadPanel.10"));
    JCheckBox myOptimizeCheckBox = new JCheckBox(Jibs.getString("DownloadPanel.9"));
    JCheckBox mySkipRecheckBox = new JCheckBox("Skip rechecking");
    JFormattedTextField myHeight = new JFormattedTextField(new Integer(0));
    JFormattedTextField myWidth = new JFormattedTextField(new Integer(0));
    JButton myStartBtn = new JButton(Jibs.getString("DownloadPanel.11"));
    JButton myStopBtn = new JButton(Jibs.getString("DownloadPanel.12"));
    File myLogFile;
    private static final int DIR_COL_WIDTH = 50;
    JFormattedTextField pictureNumberFld;
    JFormattedTextField logNumberFld;
    JTextField logFld;

    public DownloadPanel(Optimizer optimizer) {
        this.myOptimizer = optimizer;
        this.myMoveRadioBtn = new JRadioButton(Jibs.getString("DownloadPanel.6") + ":    " + this.myOptimizer.myRDPplugins.getPathManager().getDirectoryAbsolute(2));
        ButtonGroup moveOrStrainGroup = new ButtonGroup();
        moveOrStrainGroup.add(this.myDoNothingBtn);
        moveOrStrainGroup.add(this.myDeleteRadioBtn);
        moveOrStrainGroup.add(this.myMoveRadioBtn);
        this.pictureNumberFld = FileLoopHelper.makeRelabelFld();
        this.logNumberFld = FileLoopHelper.makeRelabelFld();
        this.pictureNumberFld.setValue(new Integer(OptimizerPreferences.getRelabelNumber()));
        this.pictureNumberFld.setColumns(10);
        this.logNumberFld.setValue(new Integer(OptimizerPreferences.getLogNumber()));
        this.logNumberFld.setColumns(10);
        this.logFld = new JTextField(OptimizerPreferences.getLogDirectory());
        this.logFld.setColumns(50);
        this.logFld.setToolTipText(Jibs.getString("DownloadPanel.16"));
        this.myDedupCheckBox.setSelected(OptimizerPreferences.getDedup());
        this.myAcrossCheckBox.setSelected(OptimizerPreferences.getDirectoryAcross());
        this.myRenameUniqueCheckBox.setSelected(OptimizerPreferences.getUniqueRenamingDownload());
        this.myEnforceWindows.setSelected(OptimizerPreferences.getWindowsFileConvention());
        this.myCleanUpEnding.setSelected(OptimizerPreferences.getFirstEndingConvention());
        switch (OptimizerPreferences.getStrain()) {
            case 0: {
                this.myDoNothingBtn.setSelected(true);
                break;
            }
            case 1: {
                this.myMoveRadioBtn.setSelected(true);
                break;
            }
            case 2: {
                this.myDeleteRadioBtn.setSelected(true);
            }
        }
        this.myResizeCheckBox.setSelected(OptimizerPreferences.getResize());
        this.myWidth.setText(Integer.toString(OptimizerPreferences.getResizeWidth()));
        this.myWidth.setPreferredSize(new Dimension(40, 21));
        this.myWidth.setMinimumSize(new Dimension(40, 21));
        this.myHeight.setText(Integer.toString(OptimizerPreferences.getResizeHeight()));
        this.myHeight.setPreferredSize(new Dimension(40, 21));
        this.myHeight.setMinimumSize(new Dimension(40, 21));
        this.myOptimizeCheckBox.setSelected(OptimizerPreferences.getRepack());
        this.mySkipRecheckBox.setSelected(OptimizerPreferences.getSkipRecheck());
        this.mySkipRecheckBox.setToolTipText("Skip the file if it has been processed before.\nOnly works if you checked \"Rename Unique\"\nThis check for \"-jibs\" in the name.\nDoes not affect removing duplicates.");
        this.adjustForPreferences();
        if (OptimizerPreferences.getUniqueRenamingDownload()) {
            this.myRenameUniqueCheckBox.setSelected(true);
            this.pictureNumberFld.setEditable(true);
        } else {
            this.myRenameUniqueCheckBox.setSelected(false);
            this.pictureNumberFld.setEditable(false);
        }
        this.myRenameUniqueCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DownloadPanel.this.pictureNumberFld.setEditable(DownloadPanel.this.myRenameUniqueCheckBox.isSelected());
            }
        });
        JButton btnLog = new JButton("...");
        btnLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dir = DownloadPanel.this.logFld.getText();
                if (dir == null) {
                    dir = System.getProperty("user.home");
                }
                dir = DirectoriesOnlyFileFilter.lookupDir(Jibs.getString("DownloadPanel.20"), dir, DownloadPanel.this);
                DownloadPanel.this.logFld.setText(dir);
                OptimizerPreferences.setLogDirectory(dir);
            }
        });
        JPanel dedupPanel = new JPanel();
        dedupPanel.add(this.myDedupCheckBox);
        dedupPanel.add(this.myAcrossCheckBox);
        dedupPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("DownloadPanel.21"), 1, 2));
        JPanelRows strainPanel = new JPanelRows();
        strainPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("DownloadPanel.22"), 1, 2));
        JPanel aRow = strainPanel.topRow();
        aRow.add(this.myDoNothingBtn);
        aRow = strainPanel.nextRow();
        aRow.add(this.myMoveRadioBtn);
        aRow = strainPanel.nextRow();
        aRow.add(this.myDeleteRadioBtn);
        JPanelRows renamePanel = new JPanelRows();
        aRow = renamePanel.topRow();
        renamePanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("DownloadPanel.24"), 1, 2));
        aRow.add(this.myRenameUniqueCheckBox);
        aRow.add(new JLabel(Jibs.getString("DownloadPanel.70") + ": "));
        aRow.add(this.pictureNumberFld);
        aRow = renamePanel.nextRow();
        aRow.add(this.myCleanUpEnding);
        aRow.add(this.myEnforceWindows);
        JPanelRows resizePanel = new JPanelRows();
        resizePanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("DownloadPanel.26"), 1, 2));
        aRow = resizePanel.topRow();
        aRow.add(this.myResizeCheckBox);
        aRow.add(new JLabel("    " + Jibs.getString("DownloadPanel.28") + ":  "));
        aRow.add(this.myWidth);
        aRow.add(new JLabel("  " + Jibs.getString("DownloadPanel.31") + ":  "));
        aRow.add(this.myHeight);
        aRow = resizePanel.nextRow();
        aRow.add(new JLabel(Jibs.getString("DownloadPanel.33") + Jibs.getString("colon") + " " + OptimizerPreferences.getFullScreenWidth() + Jibs.getString("DownloadPanel.34") + "   " + OptimizerPreferences.getFullScreenHeight() + Jibs.getString("DownloadPanel.35")));
        JPanel repackPanel = new JPanel();
        repackPanel.add(this.myOptimizeCheckBox);
        repackPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("DownloadPanel.37"), 1, 2));
        JPanel recheckPanel = new JPanel();
        recheckPanel.add(this.mySkipRecheckBox);
        recheckPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), "Recheck Options", 1, 2));
        JPanelRows logPanel = new JPanelRows();
        logPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("DownloadPanel.38"), 1, 2));
        aRow = logPanel.topRow();
        aRow.add(new JLabel(Jibs.getString("DownloadPanel.39") + ": "));
        aRow.add(this.logNumberFld);
        aRow = logPanel.nextRow();
        aRow.add(new JLabel(Jibs.getString("DownloadPanel.41") + ": "));
        aRow.add(this.logFld);
        aRow.add(btnLog);
        JPanel currentRow = this.topRow();
        currentRow.add(dedupPanel);
        currentRow.add(repackPanel);
        currentRow.add(recheckPanel);
        currentRow = this.nextRow();
        currentRow.add(strainPanel);
        currentRow = this.nextRow();
        currentRow.add(renamePanel);
        currentRow.add(resizePanel);
        currentRow = this.nextRow();
        currentRow.add(logPanel);
        currentRow = this.nextRow();
        currentRow.add(this.layoutAction());
    }

    private JPanel layoutAction() {
        final JButton btnReport = new JButton(Jibs.getString("report"));
        btnReport.setEnabled(false);
        JPanelRows rowMaker = new JPanelRows();
        JPanel currentRow = rowMaker.topRow();
        currentRow.add(this.myStartBtn);
        currentRow.add(this.myStopBtn);
        currentRow.add(btnReport);
        currentRow = rowMaker.nextRow();
        currentRow.add(new JLabel("  " + Jibs.getString("DownloadPanel.45") + ": "));
        currentRow.add(this.myCurrentAction);
        currentRow = rowMaker.nextRow();
        currentRow.add(this.myProgressBar);
        Dimension dim = this.myProgressBar.getPreferredSize();
        dim.width = 500;
        this.myProgressBar.setPreferredSize(dim);
        this.myStartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DownloadPanel.this.myOptimizer.myKiller.setButtons(DownloadPanel.this.myStartBtn, DownloadPanel.this.myStopBtn);
                DownloadPanel.this.workDownload();
                DownloadPanel.this.save();
                btnReport.setEnabled(true);
            }
        });
        this.myStopBtn.setEnabled(false);
        this.myStopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DownloadPanel.this.myOptimizer.myKiller.kill();
            }
        });
        btnReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    String text = Util.getTextFromFile(DownloadPanel.this.myLogFile);
                    Report.showReport(Jibs.getString("DownloadPanel.47"), text, false);
                }
                catch (Exception ex) {
                    Report.showReport(Jibs.getString("DownloadPanel.48"), ex.getMessage(), false);
                }
            }
        });
        JPanel rtnMe = new JPanel(new BorderLayout());
        rtnMe.add((Component)rowMaker, "North");
        return rtnMe;
    }

    void adjustForPreferences() {
        if (this.myOptimizer.myRDPplugins.getPathManager().getDirectoryAbsolute(2) == null) {
            this.myMoveRadioBtn.setEnabled(false);
            this.myMoveRadioBtn.setSelected(false);
            this.myMoveRadioBtn.setToolTipText(Jibs.getString("DownloadPanel.49"));
        } else {
            this.myMoveRadioBtn.setEnabled(true);
            this.myMoveRadioBtn.setToolTipText(Jibs.getString("DownloadPanel.50"));
        }
    }

    private void workDownload() {
        int logNumber = FileLoopHelper.getIntFromField(this.logNumberFld, 0);
        int nextLogNumber = logNumber + 1;
        this.logNumberFld.setValue(new Integer(Integer.toString(nextLogNumber)));
        String logFileName = OptimizerPreferences.getLogDirectory() + System.getProperty("file.separator") + "jibsLog_" + logNumber + ".txt";
        this.myLogFile = new File(logFileName);
        int height = 0;
        int width = 0;
        try {
            height = NumberFormat.getIntegerInstance().parse(this.myHeight.getText()).intValue();
            width = NumberFormat.getIntegerInstance().parse(this.myWidth.getText()).intValue();
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("DownloadPanel.55"), 0);
            return;
        }
        OptimizerPreferences.setDedup(this.myDedupCheckBox.isSelected());
        OptimizerPreferences.setDirectoryAcross(this.myAcrossCheckBox.isSelected());
        OptimizerPreferences.setUniqueRenamingDownload(this.myRenameUniqueCheckBox.isSelected());
        OptimizerPreferences.setWindowsFileConvention(this.myEnforceWindows.isSelected());
        OptimizerPreferences.setFirstEndingConvention(this.myCleanUpEnding.isSelected());
        OptimizerPreferences.setStrain(this.getStrain());
        OptimizerPreferences.setResize(this.myResizeCheckBox.isSelected());
        OptimizerPreferences.setResizeWidth(width);
        OptimizerPreferences.setResizeHeight(height);
        OptimizerPreferences.setRepack(this.myOptimizeCheckBox.isSelected());
        OptimizerPreferences.setSkipRecheck(this.mySkipRecheckBox.isSelected());
        this.myCurrentAction.setText("");
        try {
            FileLoopHelper helper = new FileLoopHelper(this.myOptimizer, "JIBS", this.pictureNumberFld, this.myCurrentAction, this.myProgressBar, this.myLogFile);
            WorkerDownload worker = new WorkerDownload(this.myOptimizer.myWorkingList.getDirArray(), this.myOptimizer.myStableList.getDirArray(), this.myDedupCheckBox.isSelected(), this.myAcrossCheckBox.isSelected(), this.myRenameUniqueCheckBox.isSelected(), this.myEnforceWindows.isSelected(), this.myCleanUpEnding.isSelected(), this.getStrain(), this.myResizeCheckBox.isSelected(), this.myOptimizeCheckBox.isSelected(), width, height, helper, this.myOptimizer.myKiller, this.myOptimizer.myRDPplugins, this.mySkipRecheckBox.isSelected());
            Thread t = new Thread(worker);
            t.start();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("DownloadPanel.58"), 0);
            ex.printStackTrace();
        }
    }

    int getStrain() {
        if (this.myMoveRadioBtn.isSelected()) {
            return 1;
        }
        if (this.myDeleteRadioBtn.isSelected()) {
            return 2;
        }
        return 0;
    }

    private void save() {
        String log = this.logFld.getText();
        if (log != null && log.length() > 0 && !FileLoopHelper.checkDirectory(log, this.myStartBtn)) {
            JOptionPane.showMessageDialog(this.myStartBtn, Jibs.getString("DownloadPanel.59"), Jibs.getString("save.failed"), 2);
            return;
        }
        OptimizerPreferences.setLogDirectory(this.logFld.getText());
        try {
            OptimizerPreferences.setRelabelNumber(FileLoopHelper.getIntFromField(this.pictureNumberFld, 0));
            OptimizerPreferences.setLogNumber(FileLoopHelper.getIntFromField(this.logNumberFld, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.myStartBtn, ex.getMessage(), Jibs.getString("save.failed"), 0);
        }
    }
}

