/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.producer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.producer.IPictureShow;
import org.gerhardb.jibs.producer.PicturePanel;
import org.gerhardb.jibs.producer.Play;
import org.gerhardb.jibs.producer.PlayFromPipedFormat;
import org.gerhardb.jibs.producer.PlayListPlayer;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Icons;

public class JibsPresenter
extends JFrame
implements IPictureShow {
    boolean iExitOnClose;
    PicturePanel myPicturePanel = new PicturePanel();
    PlayListPlayer myListPlayer = new PlayListPlayer(this);
    JLabel myPictureLabel = new JLabel(" ");

    public JibsPresenter(boolean exitOnClose) {
        super("JIBS Presenter");
        this.iExitOnClose = exitOnClose;
        if (this.iExitOnClose) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        this.setIconImage(Icons.icon(26).getImage());
        this.layoutComponents();
        this.setVisible(true);
        SwingUtils.centerOnScreen(this);
    }

    public void showPicture(BufferedImage image) {
        this.myPicturePanel.showPicture(image);
    }

    public void showCaption(String caption) {
        this.myPictureLabel.setText(caption);
    }

    void setPlayList(Play[] playList) {
        this.myListPlayer.setPlayList(playList);
    }

    private void layoutComponents() {
        this.setSize(new Dimension(600, 600));
        JButton nextBtn = new JButton("Next");
        nextBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JibsPresenter.this.myListPlayer.next();
            }
        });
        JButton autoBtn = new JButton("Auto");
        autoBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JibsPresenter.this.myListPlayer.auto();
            }
        });
        JButton stopBtn = new JButton("Stop");
        stopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JibsPresenter.this.myListPlayer.stop();
            }
        });
        JMenu fileMenu = new JMenu(Jibs.getString("MissingTile.21"));
        fileMenu.setMnemonic('F');
        class CloseAction
        extends AbstractAction {
            CloseAction() {
                if (JibsPresenter.this.iExitOnClose) {
                    super.putValue("Name", Jibs.getString("MissingTile.19"));
                    super.putValue("MnemonicKey", ActionHelpers.getKeyCodeAsInteger("X"));
                } else {
                    super.putValue("Name", Jibs.getString("MissingTile.20"));
                    super.putValue("MnemonicKey", ActionHelpers.getKeyCodeAsInteger("C"));
                }
            }

            public void actionPerformed(ActionEvent e) {
                if (JibsPresenter.this.iExitOnClose) {
                    System.exit(0);
                } else {
                    JibsPresenter.this.dispose();
                }
            }
        }
        fileMenu.add(new JMenuItem(new CloseAction()));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        JPanelRows bottomPanel = new JPanelRows(1);
        JPanel row = bottomPanel.topRow();
        row.add(this.myPictureLabel);
        row = bottomPanel.nextRow();
        row.add(autoBtn);
        row.add(nextBtn);
        row.add(stopBtn);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.myPicturePanel, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
    }

    public static void main(String[] args) {
        PlayFromPipedFormat factory;
        File playFile = new File("D:/dev/workspaces/JIBS/src/test/java/org/gerhardb/jibs/producer/playList-01.xml");
        File picDir = new File("D:/Kids/");
        try {
            factory = new PlayFromPipedFormat(playFile, picDir);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        Play[] list = factory.getPlayList();
        JibsPresenter playerWindow = new JibsPresenter(true);
        playerWindow.setPlayList(list);
    }
}

