/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.producer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.gerhardb.jibs.producer.Audio;
import org.gerhardb.jibs.producer.Play;

public class PlayFromPipedFormat {
    File myFile = null;
    String myDirectory = null;

    public PlayFromPipedFormat(File file) throws Exception {
        if (file == null) {
            throw new Exception("BasicPageFactory requires non-null file.");
        }
        if (file.isDirectory()) {
            throw new Exception("BasicPageFactory requires a file, not a directory.");
        }
        this.myFile = file;
        this.myDirectory = this.myFile.getParentFile().getAbsolutePath() + "/";
    }

    public PlayFromPipedFormat(File file, File pictureRootDir) throws Exception {
        if (file == null) {
            throw new Exception("BasicPageFactory requires non-null file.");
        }
        if (!pictureRootDir.isDirectory()) {
            throw new Exception("BasicPageFactory pictureRootDir requires a directory, not a file.");
        }
        this.myFile = file;
        this.myDirectory = pictureRootDir.getAbsolutePath() + "/";
    }

    public Play[] getPlayList() {
        ArrayList<Play> pages = new ArrayList<Play>();
        try {
            RandomAccessFile readFile = new RandomAccessFile(this.myFile, "r");
            String sLine = readFile.readLine();
            while (sLine != null) {
                Play aPage = this.extractPlayFromLine(sLine);
                if (aPage != null) {
                    pages.add(aPage);
                }
                sLine = readFile.readLine();
            }
            readFile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (pages.isEmpty()) {
            return null;
        }
        Play[] rtnMe = new Play[pages.size()];
        for (int i = 0; i < rtnMe.length; ++i) {
            rtnMe[i] = (Play)pages.get(i);
        }
        return rtnMe;
    }

    private Play extractPlayFromLine(String line) {
        String token;
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        int time = 0;
        String caption = null;
        String pic = null;
        StringTokenizer tokens = new StringTokenizer(line, "|");
        if (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            caption = this.noTilde(token);
        }
        if (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            try {
                time = Integer.parseInt(token);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        if (tokens.hasMoreTokens() && (pic = this.noTilde(token = tokens.nextToken())) != null) {
            pic = this.myDirectory + pic;
        }
        Play play = new Play();
        play.setImageFile(pic);
        play.setMinSeconds(time);
        play.setCaption(caption);
        while (tokens.hasMoreTokens()) {
            String sound = this.noTilde(tokens.nextToken());
            if (sound == null) continue;
            play.addAudio(new Audio(this.myDirectory + sound));
        }
        return play;
    }

    private String noTilde(String input) {
        if (input.equals("~")) {
            return null;
        }
        return input;
    }

    public static void main(String[] args) {
        System.out.println("BasicPageFactory TEST PROGRAM starting!\n");
        PlayFromPipedFormat factory = null;
        File playFile = new File("/dev/workspaces/JIBS/src/test/java/org/gerhardb/jibs6/producer/PipedPlayList.txt");
        try {
            factory = new PlayFromPipedFormat(playFile);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        Play aPage = factory.extractPlayFromLine("aTitle|100|BasicPageFactory.java|Page.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine(" ");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("~|~|BasicPageFactory.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("~|~|BasicPageFactory.java|Page.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("aTitle|~|BasicPageFactory.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("aTitle|0|BasicPageFactory.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("aTitle|0|BasicPageFactory.java|Page.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("aTitle|0|BasicPageFactory.java|Page.java|BasicPage.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("aTitle|0|BasicPageFactory.java|Page.java|BasicPage.java|FilePage.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("aTitle|0|BasicPageFactory.java|Page.java|BasicPage.java|FilePage.java|Scroll.java");
        System.out.println(aPage);
        aPage = factory.extractPlayFromLine("aTitle|0|BasicPageFactory.java|Page.java|BasicPage.java|FilePage.java|Scroll.java");
        System.out.println(aPage);
        System.out.println("###################################################################");
        PlayFromPipedFormat factory2 = null;
        try {
            factory2 = new PlayFromPipedFormat(new File("/Kids/a.play"));
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        Play[] list = factory2.getPlayList();
        for (int i = 0; i < list.length; ++i) {
            System.out.println(list[i]);
        }
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        PlayFromPipedFormat factory3 = null;
        try {
            factory3 = new PlayFromPipedFormat(new File("/dev/workspaces/JIBS/src/test/java/org/gerhardb/jibs6/producer/PipedPlayList.txt"), new File("/Kids/"));
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        list = factory3.getPlayList();
        for (int i = 0; i < list.length; ++i) {
            System.out.println(list[i]);
        }
        System.out.println("BasicPageFactory TEST PROGRAM EXITING NORMALLY!");
    }
}

