/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.io.DirectoriesOnlyFileFilter;
import org.gerhardb.lib.io.EndingFileFilter;
import org.gerhardb.lib.io.EzLogger;
import org.gerhardb.lib.io.FileNameComparatorInsensative;
import org.gerhardb.lib.io.FileRename;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.io.FilesOnlyFileFilter;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.StopCheck;

public class FileRenameWithDirName
extends JFrame
implements StopCheck,
Runnable {
    private static final int BUFFER = 2048;
    private static final String ZIP_FILE = "ZipFile";
    private static final String SUB_DIR = "SubFile";
    private static final String MOVE_FILES = "MoveFile";
    private static final String LAST_ROOT = "LastRoot";
    private static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/util/FileRenameWithDirName");
    JTextField myRootDir = new JTextField(60);
    JProgressBar myProgressBar = new JProgressBar();
    boolean iStop = false;
    JButton myStopBtn = new JButton("Stop");
    String myRootString;
    JCheckBox myZipFiles = new JCheckBox("Unzip Zip Files (might not always process zipped directories)");
    JCheckBox mySubDirectories = new JCheckBox("Rename files in subdirectories");
    JCheckBox myMoveFilesToRootDirectory = new JCheckBox("Move renamed files to root directory");
    boolean iExitOnClose;
    EzLogger myLogger;

    public FileRenameWithDirName(boolean exitOnClose) {
        super("Rename Files with Directory Name");
        this.iExitOnClose = exitOnClose;
        if (this.iExitOnClose) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        this.layoutComponents();
        this.myRootDir.setText(clsPrefs.get(LAST_ROOT, null));
        this.setIconImage(Icons.icon(26).getImage());
        this.myZipFiles.setSelected(clsPrefs.getBoolean(ZIP_FILE, false));
        this.mySubDirectories.setSelected(clsPrefs.getBoolean(SUB_DIR, true));
        this.myMoveFilesToRootDirectory.setSelected(clsPrefs.getBoolean(MOVE_FILES, true));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FileRenameWithDirName.this.pack();
                SwingUtils.centerOnScreen(FileRenameWithDirName.this);
                FileRenameWithDirName.this.setVisible(true);
            }
        });
    }

    public boolean isStopped() {
        return this.iStop;
    }

    private void layoutComponents() {
        this.setSize(new Dimension(600, 600));
        this.myProgressBar.setStringPainted(true);
        JButton goBtn = new JButton("Rename");
        goBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Thread t = new Thread(FileRenameWithDirName.this);
                t.start();
            }
        });
        this.myStopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileRenameWithDirName.this.iStop = true;
            }
        });
        JButton rootBtn = new JButton("...");
        rootBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileRenameWithDirName.this.selectRoot();
            }
        });
        JPanelRows topPanel = new JPanelRows();
        JPanel aRow = topPanel.topRow(1);
        aRow.add(new JLabel("Root Directory: "));
        aRow.add(this.myRootDir);
        aRow.add(rootBtn);
        aRow = topPanel.nextRow();
        aRow.add(this.myZipFiles);
        aRow = topPanel.nextRow();
        aRow.add(this.mySubDirectories);
        aRow = topPanel.nextRow();
        aRow.add(this.myMoveFilesToRootDirectory);
        aRow = topPanel.nextRow();
        aRow.add(goBtn);
        aRow.add(this.myStopBtn);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)topPanel, "Center");
        content.add((Component)this.myProgressBar, "South");
        this.setContentPane(content);
    }

    void selectRoot() {
        File picked;
        JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_ROOT, null));
        chooser.setSaveName("FileRenameWithDirName", "Select Root Directory");
        chooser.setApproveButtonText("Select Root Directory");
        chooser.setDialogTitle("Root");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (picked = chooser.getSelectedFile()) != null) {
            this.myRootDir.setText(picked.toString());
            try {
                clsPrefs.put(LAST_ROOT, picked.toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void run() {
        clsPrefs.putBoolean(ZIP_FILE, this.myZipFiles.isSelected());
        clsPrefs.putBoolean(SUB_DIR, this.mySubDirectories.isSelected());
        clsPrefs.putBoolean(MOVE_FILES, this.myMoveFilesToRootDirectory.isSelected());
        this.myRootString = this.myRootDir.getText();
        File rootFile = new File(this.myRootString);
        if (!rootFile.exists() || !rootFile.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Root directory must be a directory", "Problem", 0);
            return;
        }
        try {
            this.myLogger = EzLogger.makeEzLogger(rootFile);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Could not open log file in:\n " + rootFile, "Problem", 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int i;
            File[] dirs;
            if (this.myZipFiles.isSelected()) {
                dirs = rootFile.listFiles(new EndingFileFilter("zip"));
                this.myProgressBar.setValue(0);
                this.myProgressBar.setMaximum(dirs.length);
                this.myProgressBar.setIndeterminate(false);
                Arrays.sort(dirs, new FileNameComparatorInsensative());
                for (i = 0; i < dirs.length; ++i) {
                    System.out.println("Subdirectory: " + dirs[i] + "    " + dirs[i].getName());
                    this.myLogger.logLine(EzLogger.NEW_LINE + "Unzipping: " + dirs[i] + EzLogger.NEW_LINE);
                    this.myProgressBar.setString("Processing subdirectory: " + dirs[i].getName());
                    this.myProgressBar.setValue(i);
                    try {
                        ArrayList<String> nameList = new ArrayList<String>(100);
                        ZipFile zipFile = new ZipFile(dirs[i]);
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            if (entry.isDirectory()) continue;
                            nameList.add(entry.getName());
                        }
                        String[] names = new String[nameList.size()];
                        names = nameList.toArray(names);
                        Arrays.sort(names, new FileNameComparatorInsensative());
                        for (int j = 0; j < names.length; ++j) {
                            int count;
                            ZipEntry entry = zipFile.getEntry(names[j]);
                            BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                            byte[] data = new byte[2048];
                            String nameWithRoot = this.myRootString + "/" + entry.getName();
                            File entryFile = new File(nameWithRoot);
                            File parent = entryFile.getParentFile();
                            if (!parent.exists()) {
                                parent.mkdirs();
                            }
                            this.myLogger.logLine("    Inflating: " + nameWithRoot);
                            FileOutputStream fos = new FileOutputStream(nameWithRoot);
                            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                            while ((count = is.read(data, 0, 2048)) != -1) {
                                dest.write(data, 0, count);
                            }
                            dest.flush();
                            dest.close();
                            is.close();
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                        ex.printStackTrace();
                        this.myLogger.logLine(ex.getMessage());
                    }
                }
                this.myProgressBar.setValue(dirs.length);
            }
            if (this.mySubDirectories.isSelected()) {
                dirs = rootFile.listFiles(DirectoriesOnlyFileFilter.DIRECTORIES_ONLY);
                this.myProgressBar.setValue(0);
                this.myProgressBar.setMaximum(dirs.length);
                this.myProgressBar.setIndeterminate(false);
                Arrays.sort(dirs, new FileNameComparatorInsensative());
                for (i = 0; i < dirs.length; ++i) {
                    this.myLogger.logLine(EzLogger.NEW_LINE + EzLogger.NEW_LINE + "Processing Directory: " + dirs[i].getName() + EzLogger.NEW_LINE);
                    this.myProgressBar.setString("Processing subdirectory: " + dirs[i].getName());
                    this.myProgressBar.setValue(i);
                    File[] changedFiles = this.doNameChange(dirs[i]);
                    if (changedFiles == null || !this.myMoveFilesToRootDirectory.isSelected()) continue;
                    for (int j = 0; j < changedFiles.length; ++j) {
                        if (changedFiles[j] == null) continue;
                        FileUtil.moveFile(rootFile, changedFiles[j], this);
                        this.myLogger.logLine("     Moving: " + changedFiles[j].getName() + " to " + rootFile);
                    }
                    if (dirs[i].listFiles().length != 0) continue;
                    this.myLogger.logLine(EzLogger.NEW_LINE + EzLogger.NEW_LINE + "Removing directory: " + dirs[i] + EzLogger.NEW_LINE + EzLogger.NEW_LINE);
                    dirs[i].delete();
                }
                this.myProgressBar.setValue(dirs.length);
            }
            this.myLogger.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Problem Encountered", 0);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.myProgressBar.setString("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File[] doNameChange(File renameDir) {
        String newBase = renameDir.getName();
        Object[] inputFileList = renameDir.listFiles(FilesOnlyFileFilter.FILES_ONLY);
        File[] outputFileList = new File[inputFileList.length];
        String failureMsg = "Could not rename";
        boolean failures = false;
        this.setCursor(Cursor.getPredefinedCursor(3));
        Arrays.sort(inputFileList);
        try {
            int i2;
            for (i2 = 0; i2 < inputFileList.length; ++i2) {
                if (inputFileList[i2] == null) continue;
                try {
                    DecimalFormat formatter = FileRename.getDecimalFormat(inputFileList.length);
                    String dir = ((File)inputFileList[i2]).getParentFile().getCanonicalPath();
                    String newName = dir + "/" + this.getNewName(((File)inputFileList[i2]).getName(), i2 + 1, newBase, formatter);
                    outputFileList[i2] = new File(newName);
                    if (!outputFileList[i2].exists()) continue;
                    failures = true;
                    failureMsg = "There is already a file named:\n" + outputFileList[i2];
                    break;
                }
                catch (Exception ex) {
                    System.out.println("FileRenameWithDirName A: " + ex.getMessage());
                    failures = true;
                }
            }
            if (failures) {
                File[] i2 = null;
                return i2;
            }
            for (i2 = 0; i2 < inputFileList.length; ++i2) {
                if (inputFileList[i2] == null) continue;
                try {
                    String entry = "Renaming: " + inputFileList[i2] + EzLogger.NEW_LINE + "to: " + outputFileList[i2] + EzLogger.NEW_LINE;
                    this.myLogger.logLine(entry);
                    ((File)inputFileList[i2]).renameTo(outputFileList[i2]);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("FileRenameWithDirName B: " + ex.getMessage());
                    failures = true;
                }
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (failures) {
            JOptionPane.showMessageDialog(this, failureMsg, Jibs.getString("FileList.11"), 2);
        }
        return outputFileList;
    }

    public String getNewName(String oldName, int i, String newBase, DecimalFormat formatter) {
        String baseName = newBase + "-" + formatter.format(i);
        if (oldName == null) {
            return baseName;
        }
        int lastPeriod = oldName.lastIndexOf(46);
        if (lastPeriod < 0 || oldName.length() == 1) {
            return baseName;
        }
        String oldEnding = oldName.substring(lastPeriod + 1).toLowerCase();
        return baseName + "." + oldEnding;
    }

    public static void main(String[] args) {
        new FileRenameWithDirName(true);
    }
}

