/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IRevert;
import org.gerhardb.jibs.viewer.PicInfoDialogBase;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.util.Icons;

public class PicInfoDialog
extends PicInfoDialogBase {
    IRevert myRevert;
    boolean iAmOnFullScreen;
    JButton myDeleteBtn;
    JButton myParkBtn;

    public PicInfoDialog(File file, Frame owner, JComponent picturePanel, IRevert revert, JButton deleteBtn, JButton parkBtn, boolean fullScreen, int displayInfoWidth, int displayInfoHeight, boolean showDisplayInfo, Scroller scroller) {
        super(owner, scroller);
        this.myRevert = revert;
        this.iAmOnFullScreen = fullScreen;
        this.myDeleteBtn = deleteBtn;
        this.myParkBtn = parkBtn;
        super.display(file, picturePanel, displayInfoWidth, displayInfoHeight, showDisplayInfo);
        if (this.iAmOnFullScreen) {
            try {
                Dimension screenSize = this.getToolkit().getScreenSize();
                int x = screenSize.width / 2;
                int y = screenSize.height / 2;
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = ge.getDefaultScreenDevice();
                Robot rob = new Robot(gd);
                rob.mouseMove(x, y);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected JButton[] getToolBarButtons() {
        JButton slideShowBtn = new JButton();
        if (this.isSlideShowRunning) {
            slideShowBtn.setIcon(Icons.icon(20));
            slideShowBtn.setToolTipText(Jibs.getString("PicInfoDialog.6"));
        } else {
            slideShowBtn.setIcon(Icons.icon(19));
            slideShowBtn.setToolTipText(Jibs.getString("PicInfoDialog.7"));
        }
        slideShowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PicInfoDialog.this.isSlideShowRunning = !PicInfoDialog.this.isSlideShowRunning;
                PicInfoDialog.this.close();
            }
        });
        JButton revertBtn = new JButton();
        if (this.myRevert.isFullScreen()) {
            revertBtn.setIcon(Icons.icon(18));
            revertBtn.setToolTipText(Jibs.getString("PicInfoDialog.8"));
        } else {
            revertBtn.setIcon(Icons.icon(10));
            revertBtn.setToolTipText(Jibs.getString("PicInfoDialog.9"));
        }
        revertBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PicInfoDialog.this.isSlideShowRunning = false;
                PicInfoDialog.this.close();
                PicInfoDialog.this.myRevert.revert();
            }
        });
        this.myDeleteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PicInfoDialog.this.close();
            }
        });
        this.myParkBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PicInfoDialog.this.close();
            }
        });
        JButton[] rtnMe = new JButton[]{revertBtn, this.myDeleteBtn, this.myParkBtn, slideShowBtn};
        return rtnMe;
    }
}

