/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.image.ImageUtilDrew;
import org.gerhardb.lib.util.Conversions;

public class PicInfoScrollPane
extends JScrollPane {
    static SimpleDateFormat dateFormat = new SimpleDateFormat();
    boolean iShowDisplayInfo = false;
    JComponent myPicturePanel;

    public PicInfoScrollPane(boolean showDisplayInfo) {
        this.iShowDisplayInfo = showDisplayInfo;
    }

    public void setPicturePanel(JComponent picturePanel) {
        this.myPicturePanel = picturePanel;
    }

    public void update(File picFile, int displayInfoWidth, int displayInfoHeight) {
        if (picFile == null) {
            JEditorPane showMe = new JEditorPane("text", "");
            showMe.setEditable(false);
            showMe.setDisabledTextColor(Color.black);
            showMe.setCaretPosition(0);
            this.setViewportView(showMe);
            return;
        }
        StringBuffer buff = new StringBuffer(3000);
        buff.append("<html>");
        buff.append("<center><strong>");
        buff.append("Picture File Data");
        buff.append("</strong></center>");
        buff.append("Name: ");
        buff.append(picFile.getName());
        buff.append("<br>");
        buff.append("Size: ");
        buff.append(Conversions.formattedMetricBytes(picFile.length()));
        buff.append("<br>");
        buff.append("Last Modified: ");
        buff.append(dateFormat.format(new Date(picFile.lastModified())));
        buff.append("<br>");
        buff.append("<hr>");
        buff.append("<center><strong>");
        buff.append(Jibs.getString("PicInfoDialog.25"));
        buff.append("</strong></center>");
        ImageUtilDrew drew = new ImageUtilDrew(picFile);
        ArrayList exifTags = drew.getExifTags();
        if (exifTags.size() == 0) {
            buff.append(Jibs.getString("PicInfoDialog.27"));
            buff.append("<br>");
        } else {
            Iterator tags = exifTags.iterator();
            while (tags.hasNext()) {
                buff.append(tags.next());
                buff.append("<br>");
            }
        }
        buff.append("<hr>");
        buff.append("<center><strong>");
        buff.append(Jibs.getString("PicInfoDialog.32"));
        buff.append("</strong></center>");
        try {
            IOImage ioi = ImageFactory.getImageFactory().makeImage(picFile);
            BufferedImage actualImage = ioi.getImage();
            buff.append(Jibs.getString("PicInfoDialog.34") + Jibs.getString("colon") + " ");
            buff.append(actualImage.getWidth());
            buff.append(" " + Jibs.getString("PicInfoDialog.35") + Jibs.getString("colon") + " ");
            buff.append(actualImage.getHeight());
            buff.append("<br>");
        }
        catch (Exception ex) {
            buff.append(Jibs.getString("PicInfoDialog.37"));
        }
        if (this.iShowDisplayInfo) {
            if (displayInfoWidth > 0 && displayInfoHeight > 0) {
                buff.append(Jibs.getString("PicInfoDialog.38") + Jibs.getString("colon") + " ");
                buff.append(displayInfoWidth);
                buff.append(" " + Jibs.getString("PicInfoDialog.39") + Jibs.getString("colon") + Jibs.getString("PicInfoScrollPane.9"));
                buff.append(displayInfoHeight);
                buff.append("<br>");
            }
            if (this.myPicturePanel != null) {
                Dimension prefPanel = this.myPicturePanel.getPreferredSize();
                buff.append(Jibs.getString("PicInfoDialog.41") + Jibs.getString(Jibs.getString("PicInfoScrollPane.10")) + " ");
                buff.append(prefPanel.getWidth());
                buff.append(" " + Jibs.getString("PicInfoDialog.42") + Jibs.getString("colon") + " ");
                buff.append(prefPanel.getHeight());
                buff.append("<br>");
                buff.append(Jibs.getString("PicInfoDialog.44") + Jibs.getString("colon") + " ");
                buff.append(this.myPicturePanel.getWidth());
                buff.append(" " + Jibs.getString("PicInfoDialog.45") + Jibs.getString("colon") + " ");
                buff.append(this.myPicturePanel.getHeight());
            }
        }
        buff.append("</html>");
        String showString = buff.toString();
        JEditorPane showMe = new JEditorPane("text/html", showString);
        showMe.setEditable(false);
        showMe.setDisabledTextColor(Color.black);
        showMe.setCaretPosition(0);
        try {
            this.setViewportView(showMe);
        }
        catch (Exception ex) {
            System.out.println("RANDOM CAUGHT EXCEPTION IN PicInfoScrollPane");
            System.out.println("KNOWN PROBLEM -->  DON'T WORRY...");
            ex.printStackTrace();
        }
    }
}

