/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.lib.dirtree.rdp.BasicOptionsManager;
import org.gerhardb.lib.swing.JPanelRows;

public class VPDMainPanel {
    JFormattedTextField delayFld = new JFormattedTextField(new Integer(3000));
    JCheckBox startFullScreenChkBox = new JCheckBox(Jibs.getString("VPDMainPanel.4") + "      ");
    JCheckBox startShowImmediatelyChkBox = new JCheckBox(Jibs.getString("VPDMainPanel.6"));
    JCheckBox gdFullScreenChkBox = new JCheckBox(Jibs.getString("VPDMainPanel.7"));
    JCheckBox continuousLoopChkBox = new JCheckBox(Jibs.getString("VPDMainPanel.94"));
    JCheckBox blowUpChkBox = new JCheckBox(Jibs.getString("VPDMainPanel.11"));
    JFormattedTextField maxBlowFld = new JFormattedTextField(new Integer(2));
    SortScreen mySortScreen;
    JPanel basicPanel = new JPanel(false);

    public VPDMainPanel(SortScreen owner) {
        this.mySortScreen = owner;
    }

    JComponent setUpScreen() {
        this.delayFld.setColumns(10);
        this.maxBlowFld.setColumns(3);
        JPanelRows basicPanelRows = new JPanelRows();
        JPanel nextRow = basicPanelRows.topRow();
        nextRow.add(this.showStartup());
        nextRow = basicPanelRows.nextRow();
        nextRow.add(this.showComponent());
        nextRow.add(this.mySortScreen.getLST().getBasicOptionsManager().getSortComponent());
        this.basicPanel.add(basicPanelRows);
        this.delayFld.setValue(new Integer(ViewerPreferences.getSlideFlipDelay()));
        this.adjustView();
        return new JScrollPane(this.basicPanel);
    }

    private Component showStartup() {
        this.startFullScreenChkBox.setSelected(ViewerPreferences.startFullScreen());
        this.startFullScreenChkBox.setToolTipText(Jibs.getString("VPDMainPanel.45"));
        return this.mySortScreen.getLST().getBasicOptionsManager().getStartupComponent(this.startFullScreenChkBox);
    }

    private Component showComponent() {
        this.startShowImmediatelyChkBox.setSelected(ViewerPreferences.immediateShow());
        this.gdFullScreenChkBox.setSelected(ViewerPreferences.getGDFullScreen());
        this.continuousLoopChkBox.setSelected(ViewerPreferences.continuousShow());
        this.blowUpChkBox.setSelected(ViewerPreferences.blowUp());
        this.maxBlowFld.setValue(new Integer(ViewerPreferences.getMaxBlow()));
        this.blowUpChkBox.setToolTipText(Jibs.getString("VPDMainPanel.57"));
        this.maxBlowFld.setToolTipText("<html>" + Jibs.getString("VPDMainPanel.59") + "<br>" + Jibs.getString("VPDMainPanel.61") + "</html>");
        JPanelRows rtnMe = new JPanelRows();
        rtnMe.setToolTipText(Jibs.getString("VPDMainPanel.63"));
        rtnMe.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("VPDMainPanel.64"), 1, 2));
        JPanel row = rtnMe.topRow();
        row.add(this.blowUpChkBox);
        row.add(new JLabel(" " + Jibs.getString("VPDMainPanel.66")));
        row.add(this.maxBlowFld);
        row.add(this.gdFullScreenChkBox);
        row = rtnMe.nextRow();
        row.add(this.startShowImmediatelyChkBox);
        row = rtnMe.nextRow();
        row.add(this.continuousLoopChkBox);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("VPDMainPanel.67") + ": "));
        row.add(this.delayFld);
        row.add(new JLabel(Jibs.getString("VPDMainPanel.69")));
        return rtnMe;
    }

    private void adjustView() {
        BasicOptionsManager bom = this.mySortScreen.getLST().getBasicOptionsManager();
        bom.adjustView();
        if (bom.getStartNothing()) {
            this.startFullScreenChkBox.setEnabled(false);
            this.startFullScreenChkBox.setSelected(false);
        } else {
            this.startFullScreenChkBox.setEnabled(true);
        }
    }

    void save() {
        try {
            this.mySortScreen.getPathManager().save();
            this.mySortScreen.getLST().getBasicOptionsManager().save();
            ViewerPreferences.setGDFullScreen(this.gdFullScreenChkBox.isSelected());
            ViewerPreferences.setImmediateShow(this.startShowImmediatelyChkBox.isSelected());
            ViewerPreferences.setStartFullScreen(this.startFullScreenChkBox.isSelected());
            ViewerPreferences.setContinuousShow(this.continuousLoopChkBox.isSelected());
            ViewerPreferences.setBlowUp(this.blowUpChkBox.isSelected());
            int delay = 3000;
            try {
                Object newTime = this.delayFld.getValue();
                if (newTime instanceof Long) {
                    delay = ((Long)newTime).intValue();
                } else if (newTime instanceof Integer) {
                    delay = (Integer)newTime;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ViewerPreferences.setSlideFlipDelay(delay, this.mySortScreen.getScroller());
            int blow = 1;
            try {
                Object newBlow = this.maxBlowFld.getValue();
                if (newBlow instanceof Long) {
                    blow = ((Long)newBlow).intValue();
                } else if (newBlow instanceof Integer) {
                    blow = (Integer)newBlow;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ViewerPreferences.setMaxBlow(blow);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.basicPanel, ex.getMessage(), Jibs.getString("save.failed"), 0);
            return;
        }
    }
}

