/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.shows.classic.SingleNoResizeKeyControl;
import org.gerhardb.jibs.viewer.shows.classic.SingleNoResizeScrollControl;
import org.gerhardb.jibs.viewer.shows.classic.SingleResize;
import org.gerhardb.jibs.viewer.shows.thumbs.Thumbnails;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.util.startup.AppStarter;

public class ViewerPreferences {
    public static final long serialVersionUID = 0L;
    public static String JIBS_DIR_NAME = "/JIBS";
    private static final String PREF_PATH = "/org/gerhardb/jibs/viewer/ViewerPreferences";
    private static Preferences clsPrefs;
    private static Action[] clsViewActions;
    private static final String JIBS_CONFIG_DIR = "jibsConfigDir";
    private static final String GD_FULL_SCREEN = "gdFullScreen";
    private static final String FILE_PANEL_SIZE = "ListPicturePanelDividerLocation";
    private static final String TREE_PANEL_SIZE = "TreePanelSize";
    private static final String EXIF_PANEL_SIZE = "ExifDividerLocation";
    private static final String SHOW_EXIF_MESSAGE = "showEXIFmessage";
    private static final String COUNT_IMAGE_FILES_IN_NODES = "countOnlyImageFilesInNodes";
    private static final String FULL_SCREEN_START = "fullScreenStart";
    private static final String FULL_SCREEN_AUTO = "fullScreenAuto";
    private static final String FULL_SCREEN_TIME = "fullScreenTime";
    private static final String CONTINUOUS_SHOW = "continuousShow";
    private static final String BLOW_UP_SHOW = "blowUpShow";
    private static final String MAX_BLOW = "maxBlowUpMax";
    private static final String SORTER_TILE_SIZE = "sorterTileSize";
    public static final int VIEW_RESIZE = 0;
    public static final int VIEW_NO_RESIZE_KEY = 1;
    public static final int VIEW_THUMBS = 2;
    public static final int VIEW_NO_RESIZE_SCROLL = 3;
    private static final String SHOW_VIEW = "showView";
    private static final String SHOW_SORTER = "showSorter";
    private static final String EXIF_PANEL_SHOWING = "exifPanelShowing";

    private ViewerPreferences() {
    }

    public static void init() {
        if (clsPrefs != null) {
            return;
        }
        clsPrefs = Preferences.userRoot().node(PREF_PATH);
    }

    public static Preferences getPrefs() {
        return clsPrefs;
    }

    public static File getKeyChangerFile() {
        return new File(ViewerPreferences.getConfigDirThumbed().getAbsoluteFile() + "/JibsMenu.xml");
    }

    public static File getConfigDirThumbed() {
        if (AppStarter.isThumbdrive()) {
            return AppStarter.getStartupDirectory();
        }
        return ViewerPreferences.getConfigDir();
    }

    public static File getConfigDir() {
        String fileName = System.getProperty("jibs.props");
        if (fileName != null) {
            File propFile = new File(fileName);
            try {
                return propFile.getParentFile();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        File rtnMe = null;
        String path = clsPrefs.get(JIBS_CONFIG_DIR, null);
        if (path != null && (rtnMe = new File(path)).exists() && rtnMe.isDirectory()) {
            return rtnMe;
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            File appData = new File(System.getenv("APPDATA"));
            if (appData.exists() && appData.isDirectory()) {
                rtnMe = new File(appData.getAbsolutePath() + JIBS_DIR_NAME);
            }
        } else {
            rtnMe = new File(AppStarter.getMyPicturesDir().getAbsolutePath() + JIBS_DIR_NAME);
        }
        if (!rtnMe.exists()) {
            try {
                rtnMe.mkdir();
            }
            catch (Exception ex) {
                rtnMe = AppStarter.getMyPicturesDir();
                ex.printStackTrace();
            }
        }
        try {
            ViewerPreferences.setConfigDir(rtnMe);
            ViewerPreferences.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rtnMe;
    }

    public static void setConfigDir(File dir) throws Exception {
        if (!dir.exists() && !dir.isDirectory()) {
            throw new Exception(Jibs.getString("ViewerPreferences.18") + dir.getAbsolutePath());
        }
        clsPrefs.put(JIBS_CONFIG_DIR, dir.getAbsolutePath());
        ViewerPreferences.flush();
    }

    public static boolean getGDFullScreen() {
        return clsPrefs.getBoolean(GD_FULL_SCREEN, true);
    }

    public static void setGDFullScreen(boolean gdfs) {
        clsPrefs.putBoolean(GD_FULL_SCREEN, gdfs);
    }

    public static int getListPicturePanelDividerLocation() {
        return clsPrefs.getInt(FILE_PANEL_SIZE, 100);
    }

    public static void setListPicturePanelDividerLocation(int size) {
        clsPrefs.putInt(FILE_PANEL_SIZE, size);
    }

    public static int getTreePanelSize() {
        return clsPrefs.getInt(TREE_PANEL_SIZE, 100);
    }

    public static void setExifPanleSize(int size) {
        clsPrefs.putInt(EXIF_PANEL_SIZE, size);
    }

    public static int getExifPanelSize() {
        return clsPrefs.getInt(EXIF_PANEL_SIZE, 0);
    }

    public static void setTreePanleSize(int size) {
        clsPrefs.putInt(TREE_PANEL_SIZE, size);
    }

    public static boolean showExifWarning() {
        return clsPrefs.getBoolean(SHOW_EXIF_MESSAGE, true);
    }

    public static void setShowExifWarning(boolean showExifEnabled) {
        clsPrefs.putBoolean(SHOW_EXIF_MESSAGE, showExifEnabled);
    }

    public static boolean countImageFilesInNodes() {
        return clsPrefs.getBoolean(COUNT_IMAGE_FILES_IN_NODES, false);
    }

    public static void setCountImageFilesInNodes(boolean enabled) {
        clsPrefs.putBoolean(COUNT_IMAGE_FILES_IN_NODES, enabled);
    }

    public static boolean startFullScreen() {
        return clsPrefs.getBoolean(FULL_SCREEN_START, false);
    }

    public static boolean immediateShow() {
        return clsPrefs.getBoolean(FULL_SCREEN_AUTO, false);
    }

    public static boolean continuousShow() {
        return clsPrefs.getBoolean(CONTINUOUS_SHOW, false);
    }

    public static boolean blowUp() {
        return clsPrefs.getBoolean(BLOW_UP_SHOW, true);
    }

    public static int getMaxBlow() {
        return clsPrefs.getInt(MAX_BLOW, 3);
    }

    public static int getSlideFlipDelay() {
        return clsPrefs.getInt(FULL_SCREEN_TIME, 3000);
    }

    public static void setStartFullScreen(boolean startFullScreen) {
        clsPrefs.putBoolean(FULL_SCREEN_START, startFullScreen);
    }

    public static void setImmediateShow(boolean startShow) {
        clsPrefs.putBoolean(FULL_SCREEN_AUTO, startShow);
    }

    public static void setContinuousShow(boolean continuousShow) {
        clsPrefs.putBoolean(CONTINUOUS_SHOW, continuousShow);
    }

    public static void setBlowUp(boolean blowUp) {
        clsPrefs.putBoolean(BLOW_UP_SHOW, blowUp);
    }

    public static void setMaxBlow(int times) {
        if (times > 1) {
            clsPrefs.putInt(MAX_BLOW, times);
        }
    }

    public static void setSlideFlipDelay(int milliseconds, Scroller scroller) {
        if (milliseconds > 100) {
            clsPrefs.putInt(FULL_SCREEN_TIME, milliseconds);
            scroller.setSlideFlipDelay(milliseconds);
        }
    }

    public static int getSorterTileSize() {
        return clsPrefs.getInt(SORTER_TILE_SIZE, 100);
    }

    public static void setSorterTileSize(int size) {
        clsPrefs.putInt(SORTER_TILE_SIZE, size);
    }

    public static int getView() {
        return clsPrefs.getInt(SHOW_VIEW, 0);
    }

    public static void setView(int view) {
        clsPrefs.putInt(SHOW_VIEW, view);
    }

    public static boolean isShowSorterShowing() {
        return clsPrefs.getBoolean(SHOW_SORTER, false);
    }

    public static void setShowSorterShowing(boolean view) {
        clsPrefs.putBoolean(SHOW_SORTER, view);
    }

    public static void setViewFrame(IFrame frame) {
        frame.setWaitCursor(true);
        switch (ViewerPreferences.getView()) {
            case 0: {
                frame.setViewer(new SingleResize(frame));
                break;
            }
            case 1: {
                frame.setViewer(new SingleNoResizeKeyControl(frame));
                break;
            }
            case 2: {
                frame.setViewer(new Thumbnails(frame, frame.getScroller().getValueZeroBased()));
                break;
            }
            case 3: {
                frame.setViewer(new SingleNoResizeScrollControl(frame));
            }
        }
        frame.setWaitCursor(false);
    }

    private static void setViewLater(final IFrame frame) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ViewerPreferences.setViewFrame(frame);
            }
        });
    }

    public static Action[] getViewActions(IFrame frame) {
        if (clsViewActions == null) {
            class ResizeAction
            extends AbstractAction {
                IFrame myFrame;

                ResizeAction(IFrame aFrame) {
                    super(Jibs.getString("ViewerPreferences.26"));
                    this.myFrame = aFrame;
                }

                public void actionPerformed(ActionEvent event) {
                    ViewerPreferences.setView(0);
                    ViewerPreferences.setViewLater(this.myFrame);
                }
            }
            class NoResizeScrollAction
            extends AbstractAction {
                IFrame myFrame;

                NoResizeScrollAction(IFrame aFrame) {
                    super(Jibs.getString("ViewerPreferences.29"));
                    this.myFrame = aFrame;
                }

                public void actionPerformed(ActionEvent event) {
                    ViewerPreferences.setView(3);
                    ViewerPreferences.setViewLater(this.myFrame);
                }
            }
            class NoResizeKeyAction
            extends AbstractAction {
                IFrame myFrame;

                NoResizeKeyAction(IFrame aFrame) {
                    super(Jibs.getString("ViewerPreferences.27"));
                    this.myFrame = aFrame;
                }

                public void actionPerformed(ActionEvent event) {
                    ViewerPreferences.setView(1);
                    ViewerPreferences.setViewLater(this.myFrame);
                }
            }
            class ThumbnailsAction
            extends AbstractAction {
                IFrame myFrame;

                ThumbnailsAction(IFrame aFrame) {
                    super(Jibs.getString("ViewerPreferences.28"));
                    this.myFrame = aFrame;
                }

                public void actionPerformed(ActionEvent event) {
                    ViewerPreferences.setView(2);
                    ViewerPreferences.setViewLater(this.myFrame);
                }
            }
            Action[] x = new Action[]{new ResizeAction(frame), new NoResizeScrollAction(frame), new NoResizeKeyAction(frame), new ThumbnailsAction(frame)};
            clsViewActions = x;
        }
        return clsViewActions;
    }

    public static void makeViewMenu(IFrame frame, JMenu viewMenu) {
        Action[] viewActions = ViewerPreferences.getViewActions(frame);
        final JRadioButtonMenuItem[] menuItems = new JRadioButtonMenuItem[viewActions.length];
        viewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                switch (ViewerPreferences.getView()) {
                    case 0: {
                        menuItems[0].setSelected(true);
                        break;
                    }
                    case 3: {
                        menuItems[1].setSelected(true);
                        break;
                    }
                    case 1: {
                        menuItems[2].setSelected(true);
                        break;
                    }
                    case 2: {
                        menuItems[3].setSelected(true);
                    }
                }
            }
        });
        ButtonGroup viewGroup = new ButtonGroup();
        for (int i = 0; i < viewActions.length; ++i) {
            menuItems[i] = new JRadioButtonMenuItem(viewActions[i]);
            viewMenu.add(menuItems[i]);
            viewGroup.add(menuItems[i]);
        }
    }

    public static boolean isExifPanelShowing() {
        return clsPrefs.getBoolean(EXIF_PANEL_SHOWING, true);
    }

    public static void setExifPanelShowing(boolean enabled) {
        clsPrefs.putBoolean(EXIF_PANEL_SHOWING, enabled);
    }

    public static void flush() {
        try {
            clsPrefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(System.getProperty("user.home"));
            System.out.println(AppStarter.getMyDocumentsDir());
            System.out.println(AppStarter.getMyPicturesDir());
            System.out.println(System.getenv("APPDATA"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

