/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.thumbs;

import com.saic.isd.printscreen.ImageSelection;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.ISave;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.contact.ContactSheetOptions;
import org.gerhardb.jibs.viewer.frame.SaverActions;
import org.gerhardb.jibs.viewer.shows.thumbs.ThumbnailCache;
import org.gerhardb.jibs.viewer.shows.thumbs.Thumbnails;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.image.ImageUtilDrew;
import org.gerhardb.lib.util.ICancel;
import org.gerhardb.lib.util.ModalProgress;

public class ThumbnailSaver
implements ISave,
ListSelectionListener,
ListDataListener,
ICancel {
    boolean iCancel = false;
    SaverActions mySaverActions;
    IFrame myViewerFrame;
    JFrame myJFrame;
    FileList myFileList;
    Thumbnails myThumbnails;
    ThumbnailCache myCache;

    ThumbnailSaver(IFrame vf, Thumbnails t, ThumbnailCache c) {
        this.myViewerFrame = vf;
        this.myThumbnails = t;
        this.myCache = c;
        this.mySaverActions = this.myViewerFrame.getActions().getSaverActions();
        this.myJFrame = this.myViewerFrame.getFrame();
        this.myFileList = this.myViewerFrame.getFileList();
        this.myFileList.addListSelectionListener(this);
        this.myFileList.getModel().addListDataListener(this);
        this.resetToolbar();
    }

    public void cancel() {
        this.iCancel = true;
    }

    public void shrink() {
    }

    public void grow() {
    }

    public void rotateRight() {
        this.adjustImage(90);
    }

    public void rotateLeft() {
        this.adjustImage(-90);
    }

    public void resetToolbar() {
        this.mySaverActions.enableSave(false);
        this.mySaverActions.enableSaveAs(false);
        this.mySaverActions.enableRotation(false);
        this.mySaverActions.enableShrinkGrow(false);
        this.myThumbnails.showPageFromScroller();
    }

    public void save(boolean saveAs) {
        if (saveAs) {
            return;
        }
        DefaultBoundedRangeModel range = new DefaultBoundedRangeModel();
        ModalProgress mp = new ModalProgress((Frame)this.myJFrame, Jibs.getString("ThumbnailSaver.0"), range);
        mp.setMessage(Jibs.getString("ThumbnailSaver.1"));
        mp.setCancel(this);
        DoIt doIt = new DoIt(range, mp);
        mp.start(doIt);
    }

    public void copy() {
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(3));
        BufferedImage image = this.getCurrentImage();
        ImageSelection clip = new ImageSelection(image);
        Clipboard clipboard = this.myJFrame.getToolkit().getSystemClipboard();
        clipboard.setContents(clip, clip);
        this.myJFrame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void preview() {
        this.printOrPreview(1);
    }

    public void print() {
        this.printOrPreview(2);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.mySaverActions.enableRotation(!this.myFileList.isSelectionEmpty());
    }

    public void intervalAdded(ListDataEvent e) {
        this.resetToolbar();
    }

    public void intervalRemoved(ListDataEvent e) {
        this.resetToolbar();
    }

    public void contentsChanged(ListDataEvent e) {
        this.resetToolbar();
    }

    private void printOrPreview(int type) {
        System.out.println("--->printOrPreview");
        new ContactSheetOptions(this.myJFrame, this.myFileList.getSelectedFiles(), type, this.myViewerFrame.getScroller());
    }

    private void adjustImage(int rotation) {
        this.mySaverActions.enableSave(true);
        int[] picked = this.myFileList.getSelectedIndices();
        for (int i = 0; i < picked.length; ++i) {
            int index = picked[i];
            this.myCache.addRotation(index, rotation);
        }
    }

    private BufferedImage getCurrentImage() {
        int scrollerIndex = this.myViewerFrame.getScroller().getValueZeroBased();
        try {
            BufferedImage image = this.myViewerFrame.getScroller().getCurrentImage();
            return this.myCache.getRotatedImage(scrollerIndex, image);
        }
        catch (Exception ex) {
            System.out.println("Scroller.getCurrentImage FAILED");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    private boolean hasExifData(File file) {
        ArrayList exifTags = ImageUtilDrew.getExifTags(file);
        return exifTags.size() > 0;
    }

    private class DoIt
    implements Runnable {
        BoundedRangeModel myRange;
        ModalProgress myMP;

        private DoIt(BoundedRangeModel range, ModalProgress mp) {
            this.myRange = range;
            this.myMP = mp;
        }

        public void run() {
            boolean exifWarning = ViewerPreferences.showExifWarning();
            boolean askExifWarning = true;
            boolean keepExifData = false;
            boolean saveThisFile = true;
            int rotationCount = 0;
            for (int i = 0; i < ThumbnailSaver.this.myCache.myRotations.length; ++i) {
                if (ThumbnailSaver.this.myCache.myRotations[i] == 0) continue;
                ++rotationCount;
            }
            this.myRange.setMaximum(rotationCount - 1);
            this.myRange.setMinimum(0);
            this.myRange.setExtent(1);
            int count = 0;
            for (int i = 0; i < ThumbnailSaver.this.myCache.myRotations.length; ++i) {
                if (ThumbnailSaver.this.myCache.myRotations[i] == 0) continue;
                this.myRange.setValue(count++);
                File file = ThumbnailSaver.this.myViewerFrame.getScroller().getFile(i);
                if (file == null) continue;
                if (exifWarning) {
                    if (askExifWarning && ThumbnailSaver.this.hasExifData(file)) {
                        keepExifData = ThumbnailSaver.this.mySaverActions.cancelSaveForExifDialog(file);
                        askExifWarning = false;
                    }
                    saveThisFile = true;
                    if (keepExifData && ThumbnailSaver.this.hasExifData(file)) {
                        saveThisFile = false;
                    }
                }
                if (!saveThisFile) continue;
                try {
                    IOImage io = ImageFactory.getImageFactory().makeImage(file);
                    BufferedImage image = ThumbnailSaver.this.myCache.getRotatedImage(i, io.getImage());
                    io.save(image);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                }
            }
            this.myRange.setValue(rotationCount);
            this.myMP.dispose();
            ThumbnailSaver.this.myThumbnails.setWaitCursor(true);
            ThumbnailSaver.this.myThumbnails.redisplayClearCache();
            ThumbnailSaver.this.myThumbnails.setWaitCursor(true);
            ThumbnailSaver.this.myThumbnails.showPageFromScroller();
            ThumbnailSaver.this.myThumbnails.setWaitCursor(false);
        }
    }
}

