/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree;

import java.awt.Window;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.gerhardb.lib.dirtree.DTNFile;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.rdp.RDPmanager;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.io.FileUtilDeleteException;
import org.gerhardb.lib.util.startup.AppStarter;

public class UndoableMovingFiles
implements UndoableEdit {
    private ArrayList myMovingFileList = new ArrayList(500);
    private ArrayList myFailedFileList = new ArrayList(500);
    private DirectoryTreeNode myToDirNode;
    private String myToDirPath;
    private File myToDir;
    private RDPmanager myPlugins;
    private boolean iMoveNotCopy = true;
    private boolean iNeedToBeAdded = true;
    private boolean iAmReadyToUndo = false;
    private boolean MOVE = true;
    private boolean COPY = false;
    private boolean DOING = true;
    private boolean UNDOING = false;

    public UndoableMovingFiles(DirectoryTreeNode toDirNode, RDPmanager plugins, boolean updateRepeatButton) throws Exception {
        this.myToDirNode = toDirNode;
        this.myPlugins = plugins;
        if (this.myToDirNode == null) {
            throw new Exception("UndoableMovingFiles requires toDirNode");
        }
        if (this.myPlugins == null) {
            throw new Exception("UndoableMovingFiles requires IFrame");
        }
        this.myToDirPath = this.myToDirNode.getAbsolutePath();
        this.myToDir = new File(this.myToDirPath);
        if (this.myToDir.isFile()) {
            throw new Exception("Can't move onto a file!");
        }
        this.myToDirPath = this.myToDirPath + File.separator;
        if (updateRepeatButton) {
            this.myPlugins.setRepeatDir(this.myToDirNode);
        }
    }

    public UndoableMovingFiles(File toFile, RDPmanager plugins) throws Exception {
        this.myPlugins = plugins;
        if (this.myPlugins == null) {
            throw new Exception("UndoableMovingFiles requires IFrame");
        }
        this.myToDirPath = toFile.getAbsolutePath();
        this.myToDir = new File(this.myToDirPath);
        if (this.myToDir.isFile()) {
            throw new Exception("Can't move onto a file!");
        }
        this.myToDirPath = this.myToDirPath + File.separator;
    }

    public File[] getFailedFilesShowingMessage(final Window ss) {
        File[] failedFiles = new File[this.myFailedFileList.size()];
        this.myFailedFileList.toArray(failedFiles);
        if (failedFiles.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(ss, AppStarter.getString("ExtendedFileTree.3") + "\n" + AppStarter.getString("ExtendedFileTree.4") + "\n", AppStarter.getString("ExtendedFileTree.5"), 0);
                }
            });
        }
        return failedFiles;
    }

    public void setMoveNotCopy(boolean move) {
        this.iMoveNotCopy = move;
    }

    public void add(Object[] filesPicked, BoundedRangeModel range) throws Exception {
        for (int i = 0; i < filesPicked.length; ++i) {
            this.addAFile((File)filesPicked[i], false);
            range.setValue(i);
            if (!Thread.currentThread().isInterrupted()) continue;
            System.out.println("THREAD WAS INTERRUPTED");
            break;
        }
        this.myPlugins.getIUndo().addUndoable(this);
    }

    public void add(File file) throws Exception {
        this.addAFile(file, true);
    }

    private void addAFile(File file, boolean addUndoable) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Must move a file - null received");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(AppStarter.getString("UndoableMovingFiles.0") + AppStarter.getString("colon") + " " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(AppStarter.getString("UndoableMovingFiles.3") + AppStarter.getString("colon") + " " + file.getAbsolutePath());
        }
        try {
            this.moveIt(file, this.myToDir);
            this.myMovingFileList.add(file);
            if (this.iNeedToBeAdded) {
                this.iNeedToBeAdded = false;
                if (addUndoable) {
                    this.myPlugins.getIUndo().addUndoable(this);
                }
            }
        }
        catch (Exception ex) {
            this.myFailedFileList.add(file);
        }
    }

    public void undo() throws CannotUndoException {
        if (this.iAmReadyToUndo) {
            File firstFile = null;
            Exception foundException = null;
            Iterator loop = this.myMovingFileList.iterator();
            while (loop.hasNext()) {
                Object obj = loop.next();
                if (obj == null || !(obj instanceof File)) continue;
                try {
                    if (firstFile == null) {
                        firstFile = (File)obj;
                    }
                    this.unmoveIt((File)obj);
                }
                catch (Exception ex) {
                    foundException = ex;
                    ex.printStackTrace();
                }
            }
            if (foundException != null) {
                CannotUndoException newEx = new CannotUndoException();
                newEx.initCause(foundException);
                throw newEx;
            }
            if (this.myPlugins != null) {
                this.myPlugins.getIUndo().undid(firstFile);
            }
        }
    }

    public void redo() throws CannotRedoException {
        if (!this.iAmReadyToUndo) {
            File firstFile = null;
            Exception foundException = null;
            Iterator loop = this.myMovingFileList.iterator();
            while (loop.hasNext()) {
                Object obj = loop.next();
                if (obj == null || !(obj instanceof File)) continue;
                try {
                    File aFile = (File)obj;
                    if (firstFile == null) {
                        firstFile = aFile;
                    }
                    this.moveIt(aFile, this.myToDir);
                }
                catch (Exception ex) {
                    foundException = ex;
                    ex.printStackTrace();
                }
            }
            if (this.myPlugins != null) {
                this.myPlugins.getIUndo().redid();
            }
            if (foundException != null) {
                CannotUndoException newEx = new CannotUndoException();
                newEx.initCause(foundException);
                throw newEx;
            }
        }
    }

    public boolean canRedo() {
        return !this.iAmReadyToUndo;
    }

    public boolean canUndo() {
        return this.iAmReadyToUndo;
    }

    public void die() {
    }

    public String getPresentationName() {
        String retrived = AppStarter.getString("UndoableMovingFiles.move");
        MessageFormat form = new MessageFormat(retrived);
        Object[] args = new Object[]{new Integer(this.myMovingFileList.size()), this.myToDir.toString()};
        String msg = form.format(args);
        return msg;
    }

    public String getRedoPresentationName() {
        String retrived = AppStarter.getString("UndoableMovingFiles.redo");
        MessageFormat form = new MessageFormat(retrived);
        Object[] args = new Object[]{new Integer(this.myMovingFileList.size()), this.myToDir.toString()};
        String msg = form.format(args);
        return msg;
    }

    public String getUndoPresentationName() {
        String retrived = AppStarter.getString("UndoableMovingFiles.undo");
        MessageFormat form = new MessageFormat(retrived);
        Object[] args = new Object[]{new Integer(this.myMovingFileList.size()), this.myToDir.toString()};
        String msg = form.format(args);
        return msg;
    }

    public boolean isSignificant() {
        return true;
    }

    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    private void moveIt(File from, File toDir) throws Exception {
        File bugFixFile = new File(from.getCanonicalPath());
        if (this.iMoveNotCopy) {
            FileUtil.moveFile(this.myToDirPath, bugFixFile);
            this.updateCountForOneFile(from, this.DOING, this.MOVE);
            this.iAmReadyToUndo = true;
        } else {
            FileUtil.copyFileToDir(toDir, bugFixFile);
            this.updateCountForOneFile(from, this.DOING, this.COPY);
            this.iAmReadyToUndo = true;
        }
    }

    private void unmoveIt(File originalLocation) throws Exception {
        String returnToDir = originalLocation.getParentFile().getAbsolutePath() + File.separator;
        String moveBackName = this.myToDir.getAbsolutePath() + File.separator + originalLocation.getName();
        File moveBackFile = new File(moveBackName);
        if (this.iMoveNotCopy) {
            try {
                FileUtil.moveFile(returnToDir, moveBackFile);
                this.updateCountForOneFile(originalLocation, this.UNDOING, this.MOVE);
                this.iAmReadyToUndo = false;
            }
            catch (FileUtilDeleteException ex) {}
        } else {
            String delName = this.myToDir.getAbsolutePath() + File.separator + moveBackFile.getName();
            File delFile = new File(delName);
            try {
                delFile.delete();
                this.updateCountForOneFile(originalLocation, this.UNDOING, this.COPY);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.iAmReadyToUndo = false;
        }
    }

    private void updateCountForOneFile(File file, boolean doing, boolean move) {
        DirectoryTreeNode fromNode;
        if (this.myToDirNode != null) {
            if (doing) {
                this.myToDirNode.incrementFileCount(file.length());
            } else {
                this.myToDirNode.decrementFileCount(file.length());
            }
        }
        if (move && file instanceof DTNFile && (fromNode = ((DTNFile)file).getDirectoryTreeNode()) != null) {
            if (doing) {
                fromNode.decrementFileCount(file.length());
            } else {
                fromNode.incrementFileCount(file.length());
            }
        }
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.myToDirNode.getName().hashCode();
    }
}

