/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.text.DecimalFormat;
import org.gerhardb.lib.io.FileRename;

public class FileName {
    DecimalFormat myDecimalFormat;
    String myBeforeNumber;
    String myAfterNumber;

    public FileName(int listLength) {
        this.myDecimalFormat = FileRename.getDecimalFormat(listLength);
    }

    public void setTemplate(String template) {
        this.myBeforeNumber = null;
        this.myAfterNumber = null;
        if (template != null && template.length() != 0) {
            if (template.indexOf("#") > -1) {
                StringBuffer beforeBuff = new StringBuffer(100);
                StringBuffer afterBuff = new StringBuffer(100);
                boolean before = true;
                for (int i = 0; i < template.length(); ++i) {
                    char aChar = template.charAt(i);
                    if (aChar == '#') {
                        before = false;
                        continue;
                    }
                    if (before) {
                        beforeBuff.append(aChar);
                        continue;
                    }
                    afterBuff.append(aChar);
                }
                this.myBeforeNumber = beforeBuff.toString();
                this.myAfterNumber = afterBuff.toString();
            } else {
                this.myBeforeNumber = template + "-";
            }
        }
    }

    public String getDecimal(int i, boolean html) {
        if (html) {
            return "<big><b color=\"red\">" + this.myDecimalFormat.format(i) + "</b></big>";
        }
        return this.myDecimalFormat.format(i);
    }

    public String getNewName(int i, String oldName) {
        return this.getNewName(i, oldName, false, null);
    }

    public String getNewNameHTML(int i, String oldName) {
        return this.getNewName(i, oldName, true, null);
    }

    public String getNewName(int i, String oldName, boolean html, String ending) {
        if (html) {
            return "<html>" + this.getUnwrappedNewName(i, oldName, true, ending) + "</html>";
        }
        return this.getUnwrappedNewName(i, oldName, false, ending);
    }

    public String getUnwrappedNewName(int i, String oldName, boolean html, String newEnding) {
        String baseName = null;
        baseName = this.myBeforeNumber == null && this.myAfterNumber == null ? this.getDecimal(i, html) : (this.myBeforeNumber == null && this.myAfterNumber != null ? this.getDecimal(i, html) + this.myAfterNumber : (this.myBeforeNumber != null && this.myAfterNumber == null ? this.myBeforeNumber + this.getDecimal(i, html) : this.myBeforeNumber + this.getDecimal(i, html) + this.myAfterNumber));
        if (newEnding != null) {
            if (newEnding.lastIndexOf(46) > -1) {
                return baseName + newEnding;
            }
            return baseName + "." + newEnding;
        }
        if (oldName == null) {
            return baseName;
        }
        int lastPeriod = oldName.lastIndexOf(46);
        if (lastPeriod < 0 || oldName.length() == 1) {
            return baseName;
        }
        String oldEnding = oldName.substring(lastPeriod + 1).toLowerCase();
        return baseName + "." + oldEnding;
    }

    public static void main(String[] args) {
        FileName fn = new FileName(Integer.MAX_VALUE);
        FileName.testSet(fn, null);
        System.out.println("######################################################");
        FileName.testSet(fn, ".mpg");
        System.out.println("######################################################");
        FileName.testSet(fn, "jpeg");
        System.out.println("######################################################");
        for (int i = 1; i < 1002; ++i) {
            System.out.println(fn.getNewName(i, "a.jpg"));
        }
    }

    static void testSet(FileName fn, String ending) {
        FileName.test(fn, null, ending);
        FileName.test(fn, "", ending);
        FileName.test(fn, "#", ending);
        FileName.test(fn, "###", ending);
        FileName.test(fn, "onlyFRONT", ending);
        FileName.test(fn, "front#back", ending);
        FileName.test(fn, "front##back", ending);
        FileName.test(fn, "front########back", ending);
        FileName.test(fn, "front#b#ack", ending);
        FileName.test(fn, "front#b#a#c#k#", ending);
    }

    static void test(FileName fn, String template, String ending) {
        System.out.println("==================================================");
        System.out.println("Template: " + template);
        fn.setTemplate(template);
        System.out.println(fn.getNewName(1, null, false, ending));
        System.out.println(fn.getNewName(1, "", false, ending));
        System.out.println(fn.getNewName(1, ".", false, ending));
        System.out.println(fn.getNewName(1, "aaa", false, ending));
        System.out.println(fn.getNewName(1, "a.jpg", false, ending));
        System.out.println(fn.getNewName(1, "a.JPG", false, ending));
        System.out.println(fn.getNewName(1, "a.b.c.jpg", false, ending));
        System.out.println(fn.getNewName(1, "a.cow", false, ending));
    }
}

