/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.dirtree.filelist.popup.FileNameChanger;
import org.gerhardb.lib.dirtree.rdp.DirectoryListPanel;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.startup.AppStarter;

abstract class FileNameChangeDialog
extends JDialog {
    static final int MOVE_FILES = 0;
    private static final String SAVED_HEIGHT = "SAVED_HEIGHT";
    private static final String SAVED_WIDTH = "SAVED_WIDTH";
    private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs.viewer/list/popup/FileNameChangeDialog");
    JTabbedPane myTabs = new JTabbedPane();
    DirectoryListPanel myMoveTab;
    boolean iShowAll;
    FileNameChanger myFileNameChanger;
    FileListPlugins myPlugins;

    FileNameChangeDialog(FileNameChanger fnc, FileListPlugins plugins, ExtendedDirectoryTree tree, boolean allTabs) {
        super(plugins.getTopFrame(), AppStarter.getString("FileNameChangeDialog.5"), true);
        this.myFileNameChanger = fnc;
        this.iShowAll = allTabs;
        this.myPlugins = plugins;
        this.myMoveTab = new DirectoryListPanel(this, this.myPlugins.getRDPmanager(), tree);
        this.layoutDialog();
    }

    abstract void layoutDialog();

    void finishLayout(JPanel thePanel) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FileNameChangeDialog.this.done();
            }
        });
        this.addAccelerators();
        this.getContentPane().add(thePanel);
        this.pack();
        Dimension saved = new Dimension(clsPrefs.getInt(SAVED_WIDTH, 500), clsPrefs.getInt(SAVED_HEIGHT, 600));
        Dimension packed = this.getSize();
        if (packed.width > saved.width) {
            saved.width = packed.width;
        }
        if (packed.height > saved.height) {
            saved.height = packed.height;
        }
        this.setSize(saved);
        SwingUtils.centerOnScreen(this);
    }

    void addAccelerators() {
        InputMap map = null;
        class Dismiss
        extends AbstractAction {
            Dismiss() {
                super("dismiss");
            }

            public void actionPerformed(ActionEvent e) {
                FileNameChangeDialog.this.done();
            }
        }
        Dismiss dismiss = new Dismiss();
        String cancelID = "dismiss";
        this.myTabs.getActionMap().put(cancelID, dismiss);
        map = this.myTabs.getInputMap(1);
        map.put(KeyStroke.getKeyStroke(27, 0), cancelID);
    }

    void done() {
        clsPrefs.putInt(SAVED_WIDTH, super.getWidth());
        clsPrefs.putInt(SAVED_HEIGHT, super.getHeight());
        this.setVisible(false);
        this.dispose();
    }

    void setWaitCursor(boolean wait) {
        if (wait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

