/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.Cursor;
import java.io.File;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.UndoableMovingFiles;
import org.gerhardb.lib.dirtree.rdp.RDPmanager;
import org.gerhardb.lib.io.TargetFileExistsException;
import org.gerhardb.lib.util.ModalProgressDialogFast;
import org.gerhardb.lib.util.startup.ActiveActions;
import org.gerhardb.lib.util.startup.AppStarter;

public class MoveManager {
    static final int MOVE_NONE = 0;
    static final int MOVE_ONE = 1;
    static final int MOVE_MANY = 2;
    private UndoManager myUndoManager = new UndoManager();
    private JButton myUndoBtn;
    private JButton myRedoBtn;
    RDPmanager myRDPmanager;

    public MoveManager(RDPmanager manager) {
        this.myRDPmanager = manager;
    }

    public void addActions(ActiveActions aa) {
        this.myUndoBtn = aa.getToolBarButton("edit", "undo");
        this.myRedoBtn = aa.getToolBarButton("edit", "redo");
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }

    public JButton getUndoButton() {
        return this.myUndoBtn;
    }

    public JButton getRedoButton() {
        return this.myRedoBtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveCurrentFile(DirectoryTreeNode toNode) {
        File moveThis = this.myRDPmanager.myPlugins.getCurrentFile();
        this.myRDPmanager.setWaitCursor(true);
        try {
            UndoableMovingFiles undo = new UndoableMovingFiles(toNode, this.myRDPmanager, false);
            undo.add(moveThis);
            File[] failedFiles = undo.getFailedFilesShowingMessage(this.myRDPmanager.myPlugins.getTopFrame());
            if (failedFiles.length == 0) {
                this.myRDPmanager.myPlugins.removeCurrentFile();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.myRDPmanager.myPlugins.getTopFrame(), AppStarter.getString("Single.0") + ex.getMessage(), AppStarter.getString("Single.1"), 0);
        }
        finally {
            this.myRDPmanager.setWaitCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveCurrentFile(File toDir) {
        File moveThis = this.myRDPmanager.myPlugins.getCurrentFile();
        this.myRDPmanager.setWaitCursor(true);
        try {
            UndoableMovingFiles undo = new UndoableMovingFiles(toDir, this.myRDPmanager);
            undo.add(moveThis);
            File[] failedFiles = undo.getFailedFilesShowingMessage(this.myRDPmanager.myPlugins.getTopFrame());
            if (failedFiles.length == 0) {
                this.myRDPmanager.myPlugins.removeCurrentFile();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.myRDPmanager.myPlugins.getTopFrame(), AppStarter.getString("Single.0") + ex.getMessage(), AppStarter.getString("Single.1"), 0);
        }
        finally {
            this.myRDPmanager.setWaitCursor(false);
        }
    }

    public void moveOrCopySeveral(boolean moveNotCopy, DirectoryTreeNode node, Object[] filesPicked) {
        this.moveOrCopySeveral(moveNotCopy, node, null, filesPicked, true);
    }

    void moveOrCopySeveral(boolean moveNotCopy, DirectoryTreeNode toNode, String toDir, Object[] filesPicked, boolean updateRepeatButton) {
        DefaultBoundedRangeModel range = new DefaultBoundedRangeModel();
        new MoveOrCopyIt(moveNotCopy, toNode, toDir, filesPicked, range, updateRepeatButton);
    }

    int confirmMove(String label, DirectoryTreeNode node, String dir, Object[] filesPicked) {
        if (filesPicked.length == 0) {
            return 1;
        }
        String location = "unknown";
        location = node != null ? node.getAbsolutePath() : dir;
        int answer = JOptionPane.showConfirmDialog(this.myRDPmanager.myPlugins.getTopFrame(), AppStarter.getString("MoveManager.1") + " " + filesPicked.length + " " + AppStarter.getString("MoveManager.2") + location + "?\n", AppStarter.getString("MoveManager.4") + " " + label, 0);
        if (answer == 1) {
            return 0;
        }
        return 2;
    }

    public void setUndoOff() {
        this.myUndoManager.discardAllEdits();
        this.updateUndoRedoButtons();
    }

    public void addUndoable(UndoableEdit edit) {
        this.myUndoManager.addEdit(edit);
        this.updateUndoRedoButtons();
    }

    public void updateUndoRedoButtons() {
        String retrieved;
        String resourseKey;
        Action action;
        if (this.myUndoManager.canUndo()) {
            action = this.myUndoBtn.getAction();
            action.setEnabled(true);
            action.putValue("ShortDescription", this.myUndoManager.getUndoPresentationName());
        } else {
            action = this.myUndoBtn.getAction();
            action.setEnabled(false);
            resourseKey = "SortScreen.menu.edit.undo.tip";
            retrieved = AppStarter.getString(resourseKey);
            action.putValue("ShortDescription", retrieved);
        }
        if (this.myUndoManager.canRedo()) {
            action = this.myRedoBtn.getAction();
            action.setEnabled(true);
            action.putValue("ShortDescription", this.myUndoManager.getRedoPresentationName());
        } else {
            action = this.myRedoBtn.getAction();
            action.setEnabled(false);
            resourseKey = "SortScreen.menu.edit.redo.tip";
            retrieved = AppStarter.getString(resourseKey);
            action.putValue("ShortDescription", retrieved);
        }
    }

    private class MoveOrCopyIt
    implements Runnable {
        boolean iMoveNotCopy;
        DirectoryTreeNode myToNode;
        String myToDir;
        Object[] myFilesPicked;
        BoundedRangeModel myRange;
        boolean iSetRepeatButtonToThisDirectory;
        ModalProgressDialogFast myDialog;
        JFrame myTopFrame;

        private MoveOrCopyIt(boolean moveNotCopy, DirectoryTreeNode toNode, String toDir, Object[] filesPicked, BoundedRangeModel range, boolean setRepeatButtonToThisDirectory) {
            this.myTopFrame = MoveManager.this.myRDPmanager.myPlugins.getTopFrame();
            this.iMoveNotCopy = moveNotCopy;
            this.myToNode = toNode;
            this.myToDir = toDir;
            this.myFilesPicked = filesPicked;
            this.myRange = range;
            this.iSetRepeatButtonToThisDirectory = setRepeatButtonToThisDirectory;
            if (this.myToNode == null && this.myToDir == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(MoveOrCopyIt.this.myTopFrame, AppStarter.getString("ExtendedFileTree.3") + "\n" + AppStarter.getString("ExtendedFileTree.4") + "\n", AppStarter.getString("ExtendedFileTree.5"), 0);
                    }
                });
                return;
            }
            this.myDialog = this.iMoveNotCopy ? new ModalProgressDialogFast(this.myTopFrame, AppStarter.getString("ExtendedFileTree.0"), filesPicked.length + " " + AppStarter.getString("ExtendedFileTree.1"), AppStarter.getString("ExtendedFileTree.2"), this.myRange, this) : new ModalProgressDialogFast(this.myTopFrame, AppStarter.getString("ExtendedFileTree.6"), filesPicked.length + " " + AppStarter.getString("ExtendedFileTree.7"), AppStarter.getString("ExtendedFileTree.8"), this.myRange, this);
            this.myDialog.start();
        }

        public void run() {
            UndoableMovingFiles undo;
            int returnToIndex;
            block15: {
                MoveManager.this.myRDPmanager.myPlugins.updateResetRecommendation();
                returnToIndex = MoveManager.this.myRDPmanager.getIScrollDirTree().getResetRecommendation();
                this.myRange.setMaximum(this.myFilesPicked.length - 1);
                undo = null;
                try {
                    if (this.myToNode != null) {
                        undo = new UndoableMovingFiles(this.myToNode, MoveManager.this.myRDPmanager, this.iSetRepeatButtonToThisDirectory);
                        undo.setMoveNotCopy(this.iMoveNotCopy);
                        try {
                            undo.add(this.myFilesPicked, this.myRange);
                        }
                        catch (TargetFileExistsException ex) {
                            System.out.println("TargetFileExistsException Issue in MoveManager MoveOrCopyIt NODE");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break block15;
                    }
                    if (this.myToDir != null) {
                        undo = new UndoableMovingFiles(new File(this.myToDir), MoveManager.this.myRDPmanager);
                        undo.setMoveNotCopy(this.iMoveNotCopy);
                        try {
                            undo.add(this.myFilesPicked, this.myRange);
                        }
                        catch (TargetFileExistsException ex) {
                            System.out.println("TargetFileExistsException Issue in MoveManager MoveOrCopyIt DIRECTORY");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break block15;
                    }
                    System.out.println("MoveOrCopyIt: Move Pressed with empty directory: THIS SHOULD NEVER HAPPEN");
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                this.myDialog.deactivateDialog();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            final File[] failedFiles = undo.getFailedFilesShowingMessage(this.myTopFrame);
            if (failedFiles.length > 0) {
                System.out.println("MoveOrCopyIt: Number of files that failed: " + failedFiles.length);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MoveOrCopyIt.this.myTopFrame.setCursor(Cursor.getPredefinedCursor(3));
                    ((MoveOrCopyIt)MoveOrCopyIt.this).MoveManager.this.myRDPmanager.myPlugins.reloadScroller(returnToIndex);
                    if (MoveOrCopyIt.this.iMoveNotCopy) {
                        ((MoveOrCopyIt)MoveOrCopyIt.this).MoveManager.this.myRDPmanager.myPlugins.clearSelection();
                        ((MoveOrCopyIt)MoveOrCopyIt.this).MoveManager.this.myRDPmanager.getIScrollDirTree().selectFiles(failedFiles);
                    }
                    MoveOrCopyIt.this.myTopFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            try {
                this.myDialog.uninstallGlassPane();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

