/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.gerhardb.lib.dirtree.rdp.RDPplugins;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Misc;
import org.gerhardb.lib.util.startup.AppStarter;

public class PathManager {
    public static final int DIR_TREE = 0;
    public static final int DIR_DELETE = 1;
    public static final int DIR_PARK = 2;
    public static final int DIR_START = 3;
    public static final int DIR_LAST_VIEWED = 4;
    public static final String[] DIR_LOOKUPS = new String[]{"treeDirectory", "deleteDirectory", "parkDirectory", "viewDirectory", "lastDirectory"};
    public static final String VIEW_DIR_BTN_TEXT = AppStarter.getString("VPDMainPanel.0");
    private static final int DIR_COL_WIDTH = 50;
    private static final String RELATIVE_DIR = PathManager.getRelativeDirectoryBase();
    private static final String DOT = ".";
    private static final String RELATIVE_TOKEN = "./";
    private static String RECENT_TREE = "RECENT_TREE";
    private static String RECENT_VIEW = "RECENT_VIEW";
    private static int DEFAULT_MAX_COUNT = 9;
    private static String RECENT_TREE_COUNT = "RECENT_TREE_COUNT";
    private static String RECENT_VIEW_COUNT = "RECENT_VIEW_COUNT";
    private static int MAX_DIRECTORY_COUNT = 20;
    private static File clsClickedOnJibs = null;
    private static String overrideStartDir = null;
    private static String overrideTreeDir = null;
    private Preferences myPrefs;
    RelativePathTextField treeFld;
    RelativePathTextField deleteFld;
    RelativePathTextField parkFld;
    RelativePathTextField startFld;
    DirButton btnTree;
    DirButton btnDelete;
    DirButton btnPark;
    DirButton btnStartDir;
    JRadioButton pathRelative = new JRadioButton("Subdirectory of (for thumbdrives): ");
    JRadioButton pathAbsolute = new JRadioButton("Fixed path");
    JPanel basicPanel = new JPanel(false);
    private JMenu myRecentTreeMenu;
    private JMenu myRecentDirMenu;
    RDPplugins myPlugins;
    private static final String PATH_ABSOLUTE = "absolutePath";

    public PathManager(RDPplugins plugins, String appStartID) {
        this.myPlugins = plugins;
        this.myPrefs = Preferences.userRoot().node("/" + appStartID + "org/gerhardb/jibs/viewer/PathManager");
    }

    void init() {
        String INITIALIAZATION_NEEDED = "initializationNeeded";
        if (this.myPrefs.getBoolean("initializationNeeded", true)) {
            if (AppStarter.isThumbdrive()) {
                this.initializeThumbdrive();
            } else {
                this.doFirstTimeInitialization();
            }
            this.myPrefs.putBoolean("initializationNeeded", false);
        }
        this.treeFld = new RelativePathTextField(50, "pics", this.getDirectoryRelative(0));
        this.deleteFld = new RelativePathTextField(50, "delete", this.getDirectoryRelative(1));
        this.parkFld = new RelativePathTextField(50, "park", this.getDirectoryRelative(2));
        this.startFld = new RelativePathTextField(50, "pics", this.getDirectoryRelative(3));
        this.treeFld.setToolTipText(AppStarter.getString("VPDMainPanel.33"));
        this.deleteFld.setToolTipText(AppStarter.getString("VPDMainPanel.35"));
        this.parkFld.setToolTipText(AppStarter.getString("VPDMainPanel.37"));
        this.startFld.setToolTipText("<html>" + AppStarter.getString("VPDMainPanel.40") + " <i>" + VIEW_DIR_BTN_TEXT + "</i>" + AppStarter.getString("VPDMainPanel.43") + ".</html>");
        this.btnTree = new DirButton(this.treeFld, "Tree");
        this.btnDelete = new DirButton(this.deleteFld, "Delete");
        this.btnPark = new DirButton(this.parkFld, "Park");
        this.btnStartDir = new DirButton(this.startFld, "Start");
    }

    public static boolean overrideStartPassedIn() {
        return overrideStartDir != null;
    }

    public void setDirectory(int type, File dir) {
        this.setDirectory(type, dir.getAbsolutePath());
    }

    public void setDirectory(int type, String dir) {
        if (dir == null) {
            this.myPrefs.remove(DIR_LOOKUPS[type]);
            return;
        }
        String directory = null;
        if ((dir = PathManager.normalizePathSeparator(dir)).startsWith(DOT)) {
            directory = dir.equals(RELATIVE_TOKEN) ? DOT : dir;
            this.myPrefs.put(DIR_LOOKUPS[type], directory);
        } else {
            String validated = FileUtil.safeValidateDirectory(dir);
            if (validated != null) {
                directory = PathManager.normalizePathSeparator(validated);
                this.myPrefs.put(DIR_LOOKUPS[type], directory);
            } else {
                this.myPrefs.remove(DIR_LOOKUPS[type]);
            }
        }
        switch (type) {
            case 0: {
                overrideTreeDir = null;
                ArrayList theList = this.getDirectoryFromDisk(RECENT_TREE);
                int maxListSize = this.myPrefs.getInt(RECENT_TREE_COUNT, DEFAULT_MAX_COUNT);
                this.storeUniqueDirectories(RECENT_TREE, theList, directory, maxListSize);
                break;
            }
            case 3: {
                overrideStartDir = null;
                break;
            }
            case 1: 
            case 2: {
                this.myPlugins.loadParkAndDeleteNodes();
                break;
            }
            case 4: {
                ArrayList theList = this.getDirectoryFromDisk(RECENT_VIEW);
                int maxListSize = this.myPrefs.getInt(RECENT_VIEW_COUNT, DEFAULT_MAX_COUNT);
                this.storeUniqueDirectories(RECENT_VIEW, theList, directory, maxListSize);
                break;
            }
        }
    }

    public String getDirectoryAbsolute(int type) {
        return this.getDirectory(type, true);
    }

    public String getDirectoryRelative(int type) {
        return this.getDirectory(type, false);
    }

    public static File getStartingJibsFile() {
        return clsClickedOnJibs;
    }

    public static void setStartingJibsFile(File jibs) {
        clsClickedOnJibs = jibs;
    }

    public JMenu getRecentTreeMenu() {
        if (this.myRecentTreeMenu == null) {
            this.myRecentTreeMenu = ActionHelpers.makeMenu("recenttrees");
            this.myRecentTreeMenu.addMenuListener(new TreeMenuListener());
        }
        return this.myRecentTreeMenu;
    }

    public JMenu getRecentDirMenu() {
        if (this.myRecentDirMenu == null) {
            this.myRecentDirMenu = ActionHelpers.makeMenu("recentviews");
            this.myRecentDirMenu.addMenuListener(new ViewMenuListener());
        }
        return this.myRecentDirMenu;
    }

    private ArrayList getDirectoryFromDisk(String listKey) {
        ArrayList theList = new ArrayList(MAX_DIRECTORY_COUNT);
        try {
            byte[] byteArray = null;
            byteArray = this.myPrefs.getByteArray(listKey, byteArray);
            Object object = Misc.toObject(byteArray);
            if (object != null && object instanceof ArrayList) {
                theList = (ArrayList)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theList;
    }

    private void storeUniqueDirectories(String listKey, ArrayList theList, String directory, int maxListSize) {
        int index = theList.indexOf(directory);
        if (index > -1) {
            theList.remove(index);
        }
        theList.add(0, directory);
        while (theList.size() > maxListSize) {
            theList.remove(theList.size() - 1);
        }
        try {
            byte[] bytes = Misc.toByteArray(theList);
            this.myPrefs.putByteArray(listKey, bytes);
            this.myPrefs.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getDirectory(int type, boolean absolute) {
        String dir = null;
        switch (type) {
            case 0: {
                if (overrideTreeDir == null || overrideTreeDir.length() <= 0) break;
                dir = overrideTreeDir;
                break;
            }
            case 3: {
                if (overrideStartDir == null || overrideStartDir.length() <= 0) break;
                dir = overrideStartDir;
            }
        }
        if (dir == null) {
            String rawDir = this.myPrefs.get(DIR_LOOKUPS[type], null);
            dir = PathManager.normalizePathSeparator(rawDir);
            dir = PathManager.convert(dir, absolute);
        }
        if (dir == null) {
            dir = this.getDefaultPath(type);
            dir = PathManager.convert(dir, absolute);
        }
        return dir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String convert(String dir, boolean absolute) {
        if (dir == null) {
            return null;
        }
        dir = PathManager.normalizePathSeparator(dir);
        if (absolute) {
            if (!dir.startsWith(DOT)) return FileUtil.checkDirectory(dir);
            dir = dir.length() > 2 ? RELATIVE_DIR + "/" + dir.substring(2) : RELATIVE_DIR;
            return FileUtil.checkDirectory(dir);
        }
        if (dir.startsWith(DOT)) {
            if (dir.length() <= 2) return DOT;
            String fullPath = RELATIVE_DIR + "/" + dir.substring(2);
            if (FileUtil.checkDirectory(fullPath) != null) {
                return dir;
            }
        } else {
            if (!dir.startsWith(RELATIVE_DIR)) return FileUtil.checkDirectory(dir);
            if (dir.length() <= RELATIVE_DIR.length()) return DOT;
            if (FileUtil.checkDirectory(dir) == null) return null;
            return RELATIVE_TOKEN + dir.substring(RELATIVE_DIR.length() + 1);
        }
        dir = null;
        return FileUtil.checkDirectory(dir);
    }

    private void showDirDialog(RelativePathTextField field, String label) {
        String dir = field.getText();
        if ((dir = PathManager.convert(dir, true)) == null) {
            dir = this.pathRelative.isSelected() ? this.calcDefaultRelDir(field) : System.getProperty("user.home");
        } else if (this.pathRelative.isSelected() && !dir.startsWith(RELATIVE_DIR)) {
            dir = this.calcDefaultRelDir(field);
        }
        dir = FileUtil.lookupDir(label, dir, this.basicPanel);
        if (dir != null) {
            field.setText(dir);
        }
    }

    private String calcDefaultRelDir(RelativePathTextField field) {
        String relDefault = RELATIVE_DIR + field.myDefaultName;
        String dir = FileUtil.checkDirectory(relDefault);
        if (dir == null) {
            dir = RELATIVE_DIR;
        }
        return dir;
    }

    public JComponent directoryPanel() {
        JLabel relPath = new JLabel(RELATIVE_DIR);
        ButtonGroup pathGroup = new ButtonGroup();
        pathGroup.add(this.pathAbsolute);
        pathGroup.add(this.pathRelative);
        if (this.getAbsolutePath()) {
            this.pathAbsolute.setSelected(true);
        } else {
            this.pathRelative.setSelected(true);
        }
        if (AppStarter.isThumbdrive()) {
            this.pathAbsolute.setSelected(false);
            this.pathAbsolute.setEnabled(false);
            this.pathRelative.setSelected(true);
        }
        this.adjustFields();
        this.pathAbsolute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PathManager.this.adjustFields();
            }
        });
        this.pathRelative.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PathManager.this.adjustFields();
            }
        });
        final JSlider treeSlider = new JSlider(0, MAX_DIRECTORY_COUNT, this.myPrefs.getInt(RECENT_TREE_COUNT, DEFAULT_MAX_COUNT));
        treeSlider.setSnapToTicks(true);
        treeSlider.setPaintLabels(true);
        treeSlider.setPaintTicks(true);
        treeSlider.setMinimum(1);
        treeSlider.setMajorTickSpacing(5);
        treeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PathManager.this.myPrefs.putInt(RECENT_TREE_COUNT, treeSlider.getValue());
                try {
                    PathManager.this.myPrefs.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JButton treeClearBtn = new JButton("Clear");
        treeClearBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PathManager.this.myPrefs.remove(RECENT_TREE);
                try {
                    PathManager.this.myPrefs.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JSlider dirSlider = new JSlider(0, MAX_DIRECTORY_COUNT, this.myPrefs.getInt(RECENT_VIEW_COUNT, DEFAULT_MAX_COUNT));
        dirSlider.setSnapToTicks(true);
        dirSlider.setPaintLabels(true);
        dirSlider.setPaintTicks(true);
        dirSlider.setMinimum(1);
        dirSlider.setMajorTickSpacing(5);
        dirSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PathManager.this.myPrefs.putInt(RECENT_VIEW_COUNT, treeSlider.getValue());
                try {
                    PathManager.this.myPrefs.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JButton dirClearBtn = new JButton("Clear");
        dirClearBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PathManager.this.myPrefs.remove(RECENT_VIEW);
                try {
                    PathManager.this.myPrefs.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel leftPanel = new JPanel(new GridLayout(4, 1));
        leftPanel.add(new JLabel(AppStarter.getString("VPDMainPanel.19") + ": "));
        leftPanel.add(new JLabel(AppStarter.getString("VPDMainPanel.21") + ": "));
        leftPanel.add(new JLabel(AppStarter.getString("VPDMainPanel.23") + ": "));
        leftPanel.add(new JLabel(AppStarter.getString("VPDMainPanel.55") + ": "));
        JPanel centerPanel = new JPanel(new GridLayout(4, 1));
        centerPanel.add(this.treeFld);
        centerPanel.add(this.deleteFld);
        centerPanel.add(this.parkFld);
        centerPanel.add(this.startFld);
        JPanel rightPanel = new JPanel(new GridLayout(4, 1));
        rightPanel.add(this.btnTree);
        rightPanel.add(this.btnDelete);
        rightPanel.add(this.btnPark);
        rightPanel.add(this.btnStartDir);
        JPanel daGrid = new JPanel(new BorderLayout());
        daGrid.add((Component)leftPanel, "West");
        daGrid.add((Component)centerPanel, "Center");
        daGrid.add((Component)rightPanel, "East");
        JPanelRows relPathPanel = new JPanelRows();
        JPanel nextRow = relPathPanel.topRow();
        nextRow.add(this.pathAbsolute);
        nextRow = relPathPanel.nextRow();
        nextRow.add(this.pathRelative);
        nextRow.add(relPath);
        nextRow = relPathPanel.nextRow();
        nextRow.add(daGrid);
        nextRow = relPathPanel.nextRow();
        nextRow.add(new JLabel("View directories to remember: "));
        nextRow.add(dirSlider);
        nextRow.add(dirClearBtn);
        nextRow = relPathPanel.nextRow();
        nextRow.add(new JLabel("Tree directories to remember: "));
        nextRow.add(treeSlider);
        nextRow.add(treeClearBtn);
        return relPathPanel;
    }

    public void adjustView(boolean startParticularDir) {
        if (startParticularDir) {
            this.startFld.setEnabled(true);
            this.btnStartDir.setEnabled(true);
        } else {
            this.startFld.setEnabled(false);
            this.btnStartDir.setEnabled(false);
        }
    }

    public void save() {
        try {
            String start;
            String tree = PathManager.convert(this.treeFld.getText(), true);
            if (!PathManager.checkDirectory(tree, this.basicPanel)) {
                JOptionPane.showMessageDialog(this.basicPanel, AppStarter.getString("VPDMainPanel.72") + "\n" + AppStarter.getString("VPDMainPanel.74"), AppStarter.getString("save.failed"), 2);
                return;
            }
            String trash = PathManager.convert(this.deleteFld.getText(), true);
            if (trash != null && trash.length() > 0 && !PathManager.checkDirectory(trash, this.basicPanel)) {
                JOptionPane.showMessageDialog(this.basicPanel, AppStarter.getString("VPDMainPanel.76") + AppStarter.getString("VPDMainPanel.77") + AppStarter.getString("VPDMainPanel.78"), AppStarter.getString("save.failed"), 2);
                return;
            }
            String park = PathManager.convert(this.parkFld.getText(), true);
            if (park != null && park.length() > 0 && !PathManager.checkDirectory(park, this.basicPanel)) {
                JOptionPane.showMessageDialog(this.basicPanel, AppStarter.getString("VPDMainPanel.80") + "\n" + AppStarter.getString("VPDMainPanel.82"), AppStarter.getString("save.failed"), 2);
                return;
            }
            if (this.startFld.isEnabled() && !PathManager.checkDirectory(start = PathManager.convert(this.startFld.getText(), true), this.basicPanel)) {
                JOptionPane.showMessageDialog(this.basicPanel, AppStarter.getString("VPDMainPanel.84") + "\n" + AppStarter.getString("VPDMainPanel.86"), AppStarter.getString("save.failed"), 2);
            }
            this.setAbsolutePath(this.pathAbsolute.isSelected());
            this.setDirectory(0, this.treeFld.getText());
            this.setDirectory(1, this.deleteFld.getText());
            this.setDirectory(2, this.parkFld.getText());
            this.setDirectory(3, this.startFld.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.basicPanel, ex.getMessage(), AppStarter.getString("save.failed"), 0);
            return;
        }
    }

    private void adjustFields() {
        this.treeFld.adjustText();
        this.deleteFld.adjustText();
        this.parkFld.adjustText();
        this.startFld.adjustText();
    }

    private static String getRelativeDirectoryBase() {
        String path = AppStarter.getStartupDirectory().getAbsolutePath();
        if ((path = PathManager.normalizePathSeparator(path)).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static boolean checkDirectory(String dir, Component showOnTopOf) {
        if (dir == null || dir.trim().length() == 0) {
            return false;
        }
        try {
            FileUtil.validateDirectory(dir.toString());
        }
        catch (FileNotFoundException ex) {
            int create = JOptionPane.showConfirmDialog(showOnTopOf, dir + " " + AppStarter.getString("VPDMainPanel.90"), AppStarter.getString("VPDMainPanel.91"), 0);
            if (create == 0) {
                boolean rtnMe = false;
                File file = new File(dir);
                try {
                    rtnMe = file.mkdir();
                }
                catch (Exception exx) {
                    JOptionPane.showMessageDialog(showOnTopOf, exx.getMessage(), AppStarter.getString("VPDMainPanel.92"), 0);
                    return false;
                }
                return rtnMe;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static String normalizePathSeparator(String in) {
        if (in == null) {
            return null;
        }
        return in.replace('\\', '/');
    }

    public static void overrideInitialDirectories(String tree, String start) {
        overrideTreeDir = FileUtil.checkDirectory(tree);
        overrideStartDir = FileUtil.checkDirectory(start);
        AppStarter.log("overrideTreeDir: " + overrideTreeDir);
        AppStarter.log("overrideStartDir: " + overrideStartDir);
    }

    public void flush() {
        try {
            this.myPrefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    private String getDefaultPath(int type) {
        switch (type) {
            case 1: {
                return null;
            }
            case 2: {
                String park = this.myPrefs.get(DIR_LOOKUPS[2], null);
                if (park == null) break;
                return park;
            }
        }
        return AppStarter.getMyDocumentsDir().getAbsolutePath();
    }

    private void doFirstTimeInitialization() {
        System.out.println("===================================================");
        System.out.println("Doing First Time Initialization");
        System.out.println("===================================================");
        File picsDir = AppStarter.getMyPicturesDir();
        this.setDirectory(4, picsDir);
        this.setDirectory(3, picsDir);
        this.setDirectory(0, picsDir);
        File baseDir = new File(this.myPlugins.getDirectoryForParkAndDelete());
        if (!baseDir.exists()) {
            try {
                baseDir.mkdir();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                baseDir = null;
            }
        }
        if (baseDir != null) {
            this.makeNewDir(baseDir, 2, "park");
            this.makeNewDir(baseDir, 1, "delete");
        }
        for (int i = 0; i < DIR_LOOKUPS.length; ++i) {
            String item = this.myPlugins.getPreference(DIR_LOOKUPS[i], null);
            if (item == null) continue;
            this.myPrefs.put(DIR_LOOKUPS[i], item);
            this.myPlugins.removePreference(DIR_LOOKUPS[i]);
        }
        this.flush();
    }

    private void initializeThumbdrive() {
        File baseDir = new File(RELATIVE_DIR);
        this.makeNewDir(baseDir, 4, "pictures");
        this.makeNewDir(baseDir, 3, "pictures");
        this.makeNewDir(baseDir, 0, "pictures");
        this.makeNewDir(baseDir, 2, "pictures/park");
        this.makeNewDir(baseDir, 1, "pictures/delete");
        this.flush();
    }

    void makeNewDir(File baseDir, int dirType, String dirName) {
        File newDir = new File(baseDir.getAbsoluteFile() + "/" + dirName);
        if (newDir.exists()) {
            this.setDirectory(dirType, newDir);
        } else {
            try {
                newDir.mkdir();
                this.setDirectory(dirType, newDir);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean getAbsolutePath() {
        return this.myPrefs.getBoolean(PATH_ABSOLUTE, true);
    }

    private void setAbsolutePath(boolean absolute) {
        this.myPrefs.putBoolean(PATH_ABSOLUTE, absolute);
    }

    public static void main(String[] args) {
        PathManager pm = new PathManager(null, "PathManager");
        pm.setDirectory(3, "D:\\dev\\workspaces\\JIBS\\bin\\aaa");
        pm.flush();
        System.out.println("==========================================");
        System.out.println(RELATIVE_DIR);
        System.out.println("==========================================");
        PathManager.runTest(pm, "D:\\dev\\workspaces\\JIBS\\bin\\aaa");
        PathManager.runTest(pm, "D:/dev/workspaces/JIBS/bin/aaa");
        PathManager.runTest(pm, ".\\aaa");
        PathManager.runTest(pm, "./aaa");
        PathManager.runTest(pm, "D:/dev/workspaces/JIBS/bin");
        PathManager.runTest(pm, DOT);
        PathManager.runTest(pm, RELATIVE_TOKEN);
        PathManager.runTest(pm, "D:/dev/workspaces/JIBS/bin/bbb");
        PathManager.runTest(pm, "./bbb");
    }

    private static void runTest(PathManager pm, String test) {
        System.out.println("The Test: " + test);
        pm.setDirectory(3, test);
        pm.flush();
        System.out.println("Absolute: " + pm.getDirectoryAbsolute(3));
        System.out.println("Relative: " + pm.getDirectoryRelative(3));
        System.out.println("=========================================");
    }

    class ViewMenuListener
    implements MenuListener {
        ViewMenuListener() {
        }

        public void menuSelected(MenuEvent eA) {
            PathManager.this.myRecentDirMenu.removeAll();
            int maxCount = PathManager.this.myPrefs.getInt(RECENT_VIEW_COUNT, DEFAULT_MAX_COUNT);
            ArrayList theList = PathManager.this.getDirectoryFromDisk(RECENT_VIEW);
            for (int i = 0; i <= maxCount && i < theList.size(); ++i) {
                final String dirName = (String)theList.get(i);
                if (dirName == null) continue;
                JMenuItem anItem = new JMenuItem(dirName);
                anItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent eB) {
                        ((ViewMenuListener)ViewMenuListener.this).PathManager.this.myPlugins.setCurrentDirectory(dirName);
                    }
                });
                PathManager.this.myRecentDirMenu.add(anItem);
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    class TreeMenuListener
    implements MenuListener {
        TreeMenuListener() {
        }

        public void menuSelected(MenuEvent eA) {
            PathManager.this.myRecentTreeMenu.removeAll();
            int maxCount = PathManager.this.myPrefs.getInt(RECENT_TREE_COUNT, DEFAULT_MAX_COUNT);
            ArrayList theList = PathManager.this.getDirectoryFromDisk(RECENT_TREE);
            for (int i = 0; i <= maxCount && i < theList.size(); ++i) {
                final String dirName = (String)theList.get(i);
                if (dirName == null) continue;
                JMenuItem anItem = new JMenuItem(dirName);
                anItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent eB) {
                        ((TreeMenuListener)TreeMenuListener.this).PathManager.this.myPlugins.setTreeDirectory(dirName);
                    }
                });
                PathManager.this.myRecentTreeMenu.add(anItem);
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    class DirButton
    extends JButton {
        DirButton(final RelativePathTextField field, final String toolTip) {
            super("...");
            super.setToolTipText(toolTip);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PathManager.this.showDirDialog(field, AppStarter.getString("PathManager.1") + toolTip);
                }
            });
        }
    }

    class RelativePathTextField
    extends JTextField {
        String myDefaultName;

        RelativePathTextField(int cols, String defaultName, String text) {
            super(cols);
            this.myDefaultName = PathManager.RELATIVE_TOKEN + defaultName;
            this.setText(text);
        }

        public void setText(String text) {
            if (text == null) {
                super.setText(this.myDefaultName);
            } else {
                super.setText(PathManager.convert(text, PathManager.this.pathAbsolute.isSelected()));
            }
        }

        public void adjustText() {
            String text = PathManager.convert(this.getText(), PathManager.this.pathAbsolute.isSelected());
            super.setText(text);
        }
    }
}

