/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import ij.ImagePlus;
import ij.io.Opener;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageFactoryImageJ;
import org.gerhardb.lib.image.ImageUtil;
import org.gerhardb.lib.util.startup.AppStarter;

class IOImageImageJ
extends IOImage {
    Opener opener = new Opener();

    public IOImageImageJ(File file) throws Exception {
        super(file);
        String path = file.getAbsolutePath();
        ImagePlus ip = this.opener.openImage(path);
        Image image = ip.getImage();
        this.myImage = ImageUtil.toBufferedImage(image);
    }

    public String getImageFactoryName() {
        return "ImageJ";
    }

    public BufferedImage getImage() {
        return this.myImage;
    }

    public boolean isSaveInNataveFormatPossible() {
        return false;
    }

    public void save(BufferedImage image, File saveAsFile) throws IOException {
        throw new IOException(AppStarter.getString("IOImageImageJ.1"));
    }

    public static void main(String[] args) {
        ImageFactoryImageJ factory = new ImageFactoryImageJ();
        try {
            File aFile = new File("D:/testpics/bad/a.jpg");
            factory.canHandle(aFile);
            System.out.println("Looked Good");
            IOImageImageJ image = new IOImageImageJ(aFile);
            System.out.println("Created OK");
            image.save(image.getImage());
            System.out.println("Image Saved!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

